/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_18_R2.entity.nonliving;

import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_18_R2.entity.MobEntityController;
import net.citizensnpcs.nms.v1_18_R2.entity.nonliving.ItemFrameController;
import net.citizensnpcs.nms.v1_18_R2.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftGlowItemFrame;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class GlowItemFrameController
extends MobEntityController {
    public GlowItemFrameController() {
        super(ItemFrameController.EntityItemFrameNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        Entity e2 = super.createEntity(at, npc);
        GlowItemFrame item = (GlowItemFrame)((CraftEntity)e2).getHandle();
        item.a(EnumDirection.f);
        item.c = new BlockPosition(at.getX(), at.getY(), at.getZ());
        return e2;
    }

    public org.bukkit.entity.GlowItemFrame getBukkitEntity() {
        return (org.bukkit.entity.GlowItemFrame)super.getBukkitEntity();
    }

    public static class GlowItemFrameNPC
    extends CraftGlowItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public GlowItemFrameNPC(EntityGlowItemFrameNPC entity) {
            super((CraftServer)Bukkit.getServer(), (GlowItemFrame)entity);
            this.npc = entity.npc;
            this.getItem().setAmount(this.npc.data().get("item-type-amount", Integer.valueOf(1)).intValue());
            this.getItem().setType(Material.getMaterial((String)this.npc.data().get("item-type-id", "STONE"), (boolean)false));
            this.getItem().setDurability(this.npc.data().get("item-type-data", this.npc.data().get("falling-block-data", Short.valueOf((short)0))).shortValue());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void setType(Material material, int data) {
            this.npc.data().setPersistent("item-type-id", (Object)material.name());
            this.npc.data().setPersistent("item-type-data", (Object)data);
            if (this.npc.isSpawned()) {
                this.npc.despawn(DespawnReason.PENDING_RESPAWN);
                this.npc.spawn(this.npc.getStoredLocation(), SpawnReason.RESPAWN);
            }
        }
    }

    public static class EntityGlowItemFrameNPC
    extends GlowItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityGlowItemFrameNPC(EntityTypes<? extends GlowItemFrame> types, World level) {
            this(types, level, null);
        }

        public EntityGlowItemFrameNPC(EntityTypes<? extends GlowItemFrame> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new GlowItemFrameNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public boolean r() {
            return this.npc == null || !this.npc.isProtected() ? super.r() : true;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldserver, BlockPosition location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void k() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.k();
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            Vec3D old = this.da().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.g(old);
            }
            return res;
        }
    }
}

