/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_18_R2.entity.nonliving;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_18_R2.entity.MobEntityController;
import net.citizensnpcs.nms.v1_18_R2.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_18_R2.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftFishHook;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.util.Vector;

public class FishingHookController
extends MobEntityController {
    public FishingHookController() {
        super(EntityFishingHookNPC.class);
    }

    public FishHook getBukkitEntity() {
        return (FishHook)super.getBukkitEntity();
    }

    public static class EntityFishingHookNPC
    extends EntityFishingHook
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityFishingHookNPC(EntityTypes<? extends EntityFishingHook> types, World level) {
            this(types, level, null);
        }

        public EntityFishingHookNPC(EntityTypes<? extends EntityFishingHook> types, World level, NPC npc) {
            super((EntityHuman)new EntityPlayer(MinecraftServer.getServer(), (WorldServer)level, new GameProfile(UUID.randomUUID(), "dummyfishhook")){}, level, 0, 0);
            this.npc = (CitizensNPC)npc;
        }

        public double f(net.minecraft.world.entity.Entity entity) {
            if (entity == this.i()) {
                return 0.0;
            }
            return super.f(entity);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new FishingHookNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldserver, BlockPosition location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void k() {
            if (this.npc != null) {
                ((EntityPlayer)this.i()).c(20.0f);
                this.i().dr();
                ((EntityPlayer)this.i()).fr().h.set(((EntityPlayer)this.i()).fr().k, (Object)new ItemStack((IMaterial)Items.or, 1));
                NMSImpl.setLife(this, 0);
                this.npc.update();
            } else {
                super.k();
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            Vec3D old = this.da().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.g(old);
            }
            return res;
        }
    }

    public static class FishingHookNPC
    extends CraftFishHook
    implements ForwardingNPCHolder {
        public FishingHookNPC(EntityFishingHookNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityFishingHook)entity);
        }
    }
}

