/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_18_R2.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_18_R2.network.EmptyNetHandler;
import net.citizensnpcs.nms.v1_18_R2.network.EmptyNetworkManager;
import net.citizensnpcs.nms.v1_18_R2.network.EmptySocket;
import net.citizensnpcs.nms.v1_18_R2.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_18_R2.util.EmptyServerStatsCounter;
import net.citizensnpcs.nms.v1_18_R2.util.NMSImpl;
import net.citizensnpcs.nms.v1_18_R2.util.PlayerControllerJump;
import net.citizensnpcs.nms.v1_18_R2.util.PlayerMoveControl;
import net.citizensnpcs.nms.v1_18_R2.util.PlayerNavigation;
import net.citizensnpcs.nms.v1_18_R2.util.PlayerlistTracker;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder,
SkinnableEntity {
    private PlayerControllerJump controllerJump;
    private PlayerMoveControl controllerMove;
    private final Map<EnumItemSlot, ItemStack> equipmentCache = Maps.newEnumMap(EnumItemSlot.class);
    private int jumpTicks = 0;
    private final Map<PathType, Float> malus = Maps.newEnumMap(PathType.class);
    private PlayerNavigation navigation;
    private final CitizensNPC npc;
    private final Location packetLocationCache = new Location(null, 0.0, 0.0, 0.0);
    private PlayerlistTracker playerlistTracker;
    private final SkinPacketTracker skinTracker;
    private EmptyServerStatsCounter statsCache;
    private int updateCounter = 0;
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP = NMS.getFirstGetter(AttributeProvider.class, Map.class);
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP_SETTER = NMS.getFinalSetter(AttributeProvider.class, "a");
    private static final MethodHandle ATTRIBUTE_SUPPLIER = NMS.getFirstGetter(AttributeMapBase.class, AttributeProvider.class);
    private static final float EPSILON = 0.003f;
    private static final MethodHandle GAMEMODE_SETTING = NMS.getFirstMethodHandle(PlayerInteractManager.class, true, EnumGamemode.class, EnumGamemode.class);
    private static final Location LOADED_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer world, GameProfile gameProfile, NPC npc) {
        super(minecraftServer, world, gameProfile);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.skinTracker = new SkinPacketTracker(this);
            try {
                GAMEMODE_SETTING.invoke(this.d, EnumGamemode.a, null);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            this.initialise(minecraftServer);
        } else {
            this.skinTracker = null;
        }
    }

    public boolean a(EntityPlayer entityplayer) {
        if (this.npc != null && this.playerlistTracker == null) {
            return false;
        }
        return super.a(entityplayer);
    }

    public boolean canCutCorner(PathType pathtype) {
        return pathtype != PathType.n && pathtype != PathType.p && pathtype != PathType.r && pathtype != PathType.d;
    }

    public boolean a(float f, float f1, DamageSource damagesource) {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.a(f, f1, damagesource);
        }
        return false;
    }

    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, iblockdata, blockposition);
        }
    }

    public void a(DamageSource damagesource) {
        if (this.be) {
            return;
        }
        super.a(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                EntityHumanNPC.this.x().a((EntityPlayer)EntityHumanNPC.this, Entity.RemovalReason.a);
                ((WorldServer)EntityHumanNPC.this.s).k().a((net.minecraft.world.entity.Entity)EntityHumanNPC.this);
            }
        }, 15L);
    }

    public void a(double d0, double d1, double d2) {
        if (this.npc == null) {
            super.a(d0, d1, d2);
            return;
        }
        NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            super.a(d0, d1, d2);
        }
    }

    public void l() {
        boolean navigating;
        if (this.npc == null) {
            super.l();
            return;
        }
        super.an();
        boolean bl = navigating = this.npc.getNavigator().isNavigating() || this.controllerMove.b();
        if (!navigating && this.getBukkitEntity() != null && (!this.npc.hasTrait(Gravity.class) || this.npc.getOrAddTrait(Gravity.class).hasGravity()) && Util.isLoaded(this.getBukkitEntity().getLocation(LOADED_LOCATION)) && SpigotUtil.checkYSafe(this.de(), this.getBukkitEntity().getWorld())) {
            this.moveWithFallDamage(Vec3D.a);
        }
        Vec3D mot = this.da();
        if (Math.abs(mot.b) < (double)0.003f && Math.abs(mot.c) < (double)0.003f && Math.abs(mot.d) < (double)0.003f) {
            this.g(Vec3D.a);
        }
        if (navigating) {
            if (!this.navigation.l()) {
                this.navigation.c();
            }
            this.moveOnCurrentHeading();
        }
        NMSImpl.updateAI((EntityLiving)this);
        if (this.B_()) {
            this.Q = true;
            this.y = false;
        }
        if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue()) {
            this.eG();
        }
        if (this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(!this.npc.isProtected())).booleanValue()) {
            AxisAlignedBB axisalignedbb = this.bF() && !this.cN().dp() ? this.cw().b(this.cN().cw()).c(1.0, 0.0, 1.0) : this.cw().c(1.0, 0.5, 1.0);
            for (net.minecraft.world.entity.Entity entity : this.s.a_((net.minecraft.world.entity.Entity)this, axisalignedbb)) {
                entity.b((EntityHuman)this);
            }
        }
    }

    public Packet<?> S() {
        if (this.playerlistTracker != null) {
            this.playerlistTracker.updateLastPlayer();
        }
        return super.S();
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
            NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PlayerNPC(this));
        }
        return super.getBukkitEntity();
    }

    public PlayerControllerJump getControllerJump() {
        return this.controllerJump;
    }

    protected SoundEffect x_() {
        return NMSImpl.getSoundEffect(this.npc, super.x_(), "death-sound");
    }

    protected SoundEffect c(DamageSource damagesource) {
        return NMSImpl.getSoundEffect(this.npc, super.c(damagesource), "hurt-sound");
    }

    public PlayerMoveControl getMoveControl() {
        return this.controllerMove;
    }

    public NavigationAbstract getNavigation() {
        return this.navigation;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    public float getPathfindingMalus(PathType pathtype) {
        return this.malus.containsKey(pathtype) ? this.malus.get(pathtype).floatValue() : pathtype.a();
    }

    @Override
    public GameProfile getProfile() {
        return super.fq();
    }

    @Override
    public String getSkinName() {
        String skinName = this.npc.getOrAddTrait(SkinTrait.class).getSkinName();
        if (skinName == null) {
            skinName = this.npc.getName();
        }
        return skinName.toLowerCase();
    }

    @Override
    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public ServerStatisticManager D() {
        return this.statsCache == null ? (this.statsCache = new EmptyServerStatsCounter()) : this.statsCache;
    }

    public IChatBaseComponent J() {
        if (this.npc.data().get("removefromplayerlist", Boolean.valueOf(Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean())).booleanValue()) {
            return new ChatComponentText("");
        }
        return super.J();
    }

    public boolean a(DamageSource damagesource, float f) {
        boolean damaged = super.a(damagesource, f);
        if (damaged && this.D) {
            this.D = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    EntityHumanNPC.this.D = true;
                }
            });
        }
        return damaged;
    }

    private void initialise(MinecraftServer minecraftServer) {
        EmptySocket socket = new EmptySocket();
        EmptyNetworkManager conn = null;
        try {
            conn = new EmptyNetworkManager(EnumProtocolDirection.b);
            this.b = new EmptyNetHandler(minecraftServer, conn, this);
            conn.a((PacketListener)this.b);
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AttributeModifiable range = this.a(GenericAttributes.b);
        if (range == null) {
            try {
                AttributeProvider provider = ATTRIBUTE_SUPPLIER.invoke(this.eq());
                HashMap all = Maps.newHashMap((Map)ATTRIBUTE_PROVIDER_MAP.invoke(provider));
                all.put(GenericAttributes.b, new AttributeModifiable(GenericAttributes.b, (Consumer)new Consumer<AttributeModifiable>(){

                    @Override
                    public void accept(AttributeModifiable att) {
                        throw new UnsupportedOperationException("Tried to change value for default attribute instance FOLLOW_RANGE");
                    }
                }));
                ATTRIBUTE_PROVIDER_MAP_SETTER.invoke(provider, ImmutableMap.copyOf((Map)all));
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            range = this.a(GenericAttributes.b);
        }
        this.a(GenericAttributes.d).a(0.3);
        range.a(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
        this.controllerJump = new PlayerControllerJump(this);
        this.controllerMove = new PlayerMoveControl((EntityLiving)this);
        this.navigation = new PlayerNavigation(this, this.s);
        this.W = 0;
        NMS.setStepHeight((Entity)this.getBukkitEntity(), 1.0f);
        this.setSkinFlags((byte)-1);
        EmptyAdvancementDataPlayer.clear(this.M());
        NMSImpl.setAdvancement((Player)this.getBukkitEntity(), new EmptyAdvancementDataPlayer(minecraftServer.aw(), minecraftServer.ac(), minecraftServer.ax(), CitizensAPI.getDataFolder().getParentFile(), this));
    }

    public boolean bm() {
        if (this.npc == null || this.Q || this.fc()) {
            return super.bm();
        }
        return Util.inBlock((Entity)this.getBukkitEntity());
    }

    public boolean isNavigating() {
        return this.npc.getNavigator().isNavigating();
    }

    public boolean bi() {
        return this.npc == null ? super.bi() : this.npc.data().get("collidable", Boolean.valueOf(!this.npc.isProtected())).booleanValue();
    }

    private void moveOnCurrentHeading() {
        if (this.bn) {
            if (this.y && this.jumpTicks == 0) {
                this.eA();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.bo *= 0.98f;
        this.bq *= 0.98f;
        this.moveWithFallDamage(new Vec3D((double)this.bo, (double)this.bp, (double)this.bq));
        NMS.setHeadYaw((Entity)this.getBukkitEntity(), this.dn());
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(Vec3D vec) {
        double y = this.de();
        this.h(vec);
        if (!this.npc.isProtected()) {
            this.a(this.de() - y, this.y);
        }
    }

    public boolean b_() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.b_();
        }
        return false;
    }

    public void i(double x, double y, double z) {
        Vector vector = Util.callPushEvent(this.npc, x, y, z);
        if (vector != null) {
            super.i(vector.getX(), vector.getY(), vector.getZ());
        }
    }

    public void g(net.minecraft.world.entity.Entity entity) {
        super.g(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    public void a(Entity.RemovalReason reason) {
        super.a(reason);
        this.M().b();
    }

    public void setMoveDestination(double x, double y, double z, double speed) {
        this.controllerMove.a(x, y, z, speed);
    }

    public void setPathfindingMalus(PathType pathtype, float f) {
        this.malus.put(pathtype, Float.valueOf(f));
    }

    public void setShouldJump() {
        this.controllerJump.jump();
    }

    @Override
    public void setSkinFlags(byte flags) {
        this.ai().b(EntityHuman.bP, (Object)flags);
    }

    @Override
    public void setSkinName(String name) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name);
    }

    @Override
    public void setSkinName(String name, boolean forceUpdate) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name, forceUpdate);
    }

    @Override
    public void setSkinPersistent(String skinName, String signature, String data) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinPersistent(skinName, signature, data);
    }

    public void setTracked(PlayerlistTracker tracker) {
        this.playerlistTracker = tracker;
    }

    public void k() {
        super.k();
        if (this.npc == null) {
            return;
        }
        this.Q = this.B_();
        if (this.updateCounter + 1 > Settings.Setting.PACKET_UPDATE_DELAY.asInt()) {
            this.bW = true;
        }
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        this.updatePackets(this.npc.getNavigator().isNavigating());
        this.npc.update();
    }

    public void h(Vec3D vec3d) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.h(vec3d);
        } else {
            NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
        }
    }

    public void updateAI() {
        this.controllerMove.a();
        this.controllerJump.tick();
    }

    private void updatePackets(boolean navigating) {
        if (this.updateCounter++ <= this.npc.data().get(NPC.Metadata.PACKET_UPDATE_DELAY, Integer.valueOf(Settings.Setting.PACKET_UPDATE_DELAY.asInt()))) {
            return;
        }
        this.updateCounter = 0;
        boolean itemChanged = false;
        for (EnumItemSlot slot : EnumItemSlot.values()) {
            ItemStack equipment = this.b(slot);
            ItemStack cache = this.equipmentCache.get(slot);
            if (!(cache == null && equipment == null || !(cache == null ^ equipment == null) && ItemStack.c((ItemStack)cache, (ItemStack)equipment))) {
                itemChanged = true;
            }
            this.equipmentCache.put(slot, equipment);
        }
        if (!itemChanged) {
            return;
        }
        Location current = this.getBukkitEntity().getLocation(this.packetLocationCache);
        ArrayList vals = Lists.newArrayList();
        for (EnumItemSlot slot : EnumItemSlot.values()) {
            vals.add(new Pair((Object)slot, (Object)this.b(slot)));
        }
        Packet[] packets = new Packet[]{new PacketPlayOutEntityEquipment(this.ae(), (List)vals)};
        NMSImpl.sendPacketsNearby((Player)this.getBukkitEntity(), current, packets);
    }

    public void updatePathfindingRange(float pathfindingRange) {
        this.navigation.setRange(pathfindingRange);
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CraftServer cserver;
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
            this.cserver = (CraftServer)Bukkit.getServer();
            this.npc.getOrAddTrait(Inventory.class);
        }

        public boolean canSee(Entity entity) {
            if (entity != null && entity.getType() == EntityType.ITEM_FRAME) {
                return false;
            }
            return super.canSee(entity);
        }

        @Override
        public Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        @Override
        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        @Override
        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            this.cserver.getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            this.cserver.getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }

        @Override
        public void setSkinFlags(byte flags) {
            ((SkinnableEntity)this.entity).setSkinFlags(flags);
        }

        @Override
        public void setSkinName(String name) {
            ((SkinnableEntity)this.entity).setSkinName(name);
        }

        @Override
        public void setSkinName(String skinName, boolean forceUpdate) {
            ((SkinnableEntity)this.entity).setSkinName(skinName, forceUpdate);
        }

        @Override
        public void setSkinPersistent(String skinName, String signature, String data) {
            ((SkinnableEntity)this.entity).setSkinPersistent(skinName, signature, data);
        }
    }
}

