/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_17_R1.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_17_R1.entity.EntityHumanNPC;
import net.citizensnpcs.nms.v1_17_R1.util.PlayerNodeEvaluator;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;

public class PlayerPathfinder
extends Pathfinder {
    private final int maxVisitedNodes;
    private final PathPoint[] neighbors = new PathPoint[32];
    private final PlayerNodeEvaluator nodeEvaluator;
    private final Path openSet;

    public PlayerPathfinder() {
        super(null, Settings.Setting.MAXIMUM_VISITED_NODES.asInt());
        this.nodeEvaluator = new PlayerNodeEvaluator();
        this.openSet = new Path();
        this.maxVisitedNodes = Settings.Setting.MAXIMUM_VISITED_NODES.asInt();
    }

    public PlayerPathfinder(PlayerNodeEvaluator var0, int var1) {
        super((PathfinderAbstract)var0, var1);
        this.openSet = new Path();
        this.nodeEvaluator = var0;
        this.maxVisitedNodes = var1;
    }

    public PathEntity findPath(ChunkCache var0, EntityHumanNPC var1, Set<BlockPosition> var2, float var3, int var4, float var5) {
        this.openSet.a();
        this.nodeEvaluator.prepare(var0, var1);
        PathPoint var6 = this.nodeEvaluator.b();
        Map<PathDestination, BlockPosition> var7 = var2.stream().collect(Collectors.toMap(p -> this.nodeEvaluator.a((double)p.getX(), (double)p.getY(), (double)p.getZ()), Function.identity()));
        PathEntity var8 = this.findPath(var0.a(), var6, var7, var3, var4, var5);
        this.nodeEvaluator.a();
        return var8;
    }

    public PathEntity a(ChunkCache var0, EntityInsentient var1, Set<BlockPosition> var2, float var3, int var4, float var5) {
        this.openSet.a();
        this.nodeEvaluator.a(var0, var1);
        PathPoint var6 = this.nodeEvaluator.b();
        Map<PathDestination, BlockPosition> var7 = var2.stream().collect(Collectors.toMap(p -> this.nodeEvaluator.a((double)p.getX(), (double)p.getY(), (double)p.getZ()), Function.identity()));
        PathEntity var8 = this.findPath(var0.a(), var6, var7, var3, var4, var5);
        this.nodeEvaluator.a();
        return var8;
    }

    private PathEntity findPath(GameProfilerFiller var0, PathPoint var1, Map<PathDestination, BlockPosition> var2, float var3, int var4, float var5) {
        var0.enter("find_path");
        var0.a(MetricCategory.a);
        Set<PathDestination> var6 = var2.keySet();
        var1.e = 0.0f;
        var1.g = var1.f = this.getBestH(var1, var6);
        this.openSet.a();
        this.openSet.a(var1);
        ImmutableSet immutableSet = ImmutableSet.of();
        int var8 = 0;
        HashSet var9 = Sets.newHashSetWithExpectedSize((int)var6.size());
        int var10 = (int)((float)this.maxVisitedNodes * var5);
        while (!this.openSet.e() && ++var8 < var10) {
            PathPoint node = this.openSet.c();
            node.i = true;
            for (PathDestination target : var6) {
                if (!(node.c((PathPoint)target) <= (float)var4)) continue;
                target.e();
                var9.add(target);
            }
            if (!var9.isEmpty()) break;
            if (node.a(var1) >= var3) continue;
            int i = this.nodeEvaluator.a(this.neighbors, node);
            for (int var13 = 0; var13 < i; ++var13) {
                PathPoint var14 = this.neighbors[var13];
                float var15 = node.a(var14);
                node.j += var15;
                float var16 = node.e + var15 + var14.k;
                if (!(var14.j < var3) || var14.c() && !(var16 < var14.e)) continue;
                var14.h = node;
                var14.e = var16;
                var14.f = this.getBestH(var14, var6) * 1.5f;
                if (var14.c()) {
                    this.openSet.a(var14, var14.e + var14.f);
                    continue;
                }
                var14.g = var14.e + var14.f;
                this.openSet.a(var14);
            }
        }
        Optional<PathEntity> var11 = !var9.isEmpty() ? var9.stream().map(p -> this.reconstructPath(p.d(), (BlockPosition)var2.get(p), true)).min(Comparator.comparingInt(PathEntity::e)) : this.getFallbackDestinations(var2, var6).findFirst();
        var0.exit();
        if (!var11.isPresent()) {
            return null;
        }
        PathEntity var12 = var11.get();
        return var12;
    }

    private float getBestH(PathPoint var0, Set<PathDestination> var1) {
        float var2 = Float.MAX_VALUE;
        for (PathDestination var4 : var1) {
            float var5 = var0.a((PathPoint)var4);
            var4.a(var5, var0);
            var2 = Math.min(var5, var2);
        }
        return var2;
    }

    public Stream<PathEntity> getFallbackDestinations(Map<PathDestination, BlockPosition> var1, Set<PathDestination> var5) {
        if (Settings.Setting.DISABLE_MC_NAVIGATION_FALLBACK.asBoolean()) {
            return Stream.empty();
        }
        return var5.stream().map(var1x -> this.reconstructPath(var1x.d(), (BlockPosition)var1.get(var1x), false)).sorted(Comparator.comparingDouble(PathEntity::n).thenComparingInt(PathEntity::e));
    }

    private PathEntity reconstructPath(PathPoint var0, BlockPosition var1, boolean var2) {
        ArrayList var3 = Lists.newArrayList();
        PathPoint var4 = var0;
        var3.add(0, var4);
        while (var4.h != null) {
            var4 = var4.h;
            var3.add(0, var4);
        }
        return new PathEntity((List)var3, var1, var2);
    }
}

