/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_17_R1.util;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_17_R1.entity.EntityHumanNPC;
import net.citizensnpcs.nms.v1_17_R1.util.PlayerNodeEvaluator;
import net.citizensnpcs.nms.v1_17_R1.util.PlayerPathfinder;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;

public class PlayerNavigation
extends NavigationAbstract {
    private boolean avoidSun;
    private final AttributeModifiable followRange;
    protected boolean m;
    private boolean isStuck;
    protected int f;
    protected Vec3D g = Vec3D.a;
    protected long j;
    protected final World b;
    protected float l = 0.5f;
    private float maxVisitedNodesMultiplier = 1.0f;
    protected final EntityHumanNPC mob;
    protected PlayerNodeEvaluator nodeEvaluator;
    protected PathEntity c;
    private final PlayerPathfinder pathFinder;
    private int reachRange;
    protected double d;
    private BlockPosition targetPos;
    protected int e;
    protected long n;
    protected BaseBlockPosition h = BaseBlockPosition.f;
    protected double k;
    protected long i;

    public PlayerNavigation(EntityHumanNPC entityinsentient, World world) {
        super(PlayerNavigation.getDummyInsentient(entityinsentient, world), world);
        this.mob = entityinsentient;
        this.b = world;
        this.followRange = entityinsentient.getAttributeInstance(GenericAttributes.b);
        this.nodeEvaluator = new PlayerNodeEvaluator();
        this.nodeEvaluator.a(true);
        this.pathFinder = new PlayerPathfinder(this.nodeEvaluator, Settings.Setting.MAXIMUM_VISITED_NODES.asInt());
        this.setRange(24.0f);
    }

    public boolean r() {
        return this.nodeEvaluator.f();
    }

    protected boolean a(Vec3D var0, Vec3D var1, int var2, int var3, int var4) {
        int var5 = MathHelper.floor((double)var0.b);
        int var6 = MathHelper.floor((double)var0.d);
        double var7 = var1.b - var0.b;
        double var9 = var1.d - var0.d;
        double var11 = var7 * var7 + var9 * var9;
        if (var11 < 1.0E-8) {
            return false;
        }
        double var13 = 1.0 / Math.sqrt(var11);
        if (!this.canWalkOn(var5, MathHelper.floor((double)var0.c), var6, var2 += 2, var3, var4 += 2, var0, var7 *= var13, var9 *= var13)) {
            return false;
        }
        var2 -= 2;
        var4 -= 2;
        double var15 = 1.0 / Math.abs(var7);
        double var17 = 1.0 / Math.abs(var9);
        double var19 = (double)var5 - var0.b;
        double var21 = (double)var6 - var0.d;
        if (var7 >= 0.0) {
            var19 += 1.0;
        }
        if (var9 >= 0.0) {
            var21 += 1.0;
        }
        var19 /= var7;
        var21 /= var9;
        int var23 = var7 < 0.0 ? -1 : 1;
        int var24 = var9 < 0.0 ? -1 : 1;
        int var25 = MathHelper.floor((double)var1.b);
        int var26 = MathHelper.floor((double)var1.d);
        int var27 = var25 - var5;
        int var28 = var26 - var6;
        while (var27 * var23 > 0 || var28 * var24 > 0) {
            if (var19 < var21) {
                var19 += var15;
                var27 = var25 - (var5 += var23);
            } else {
                var21 += var17;
                var28 = var26 - (var6 += var24);
            }
            if (this.canWalkOn(var5, MathHelper.floor((double)var0.c), var6, var2, var3, var4, var0, var7, var9)) continue;
            return false;
        }
        return true;
    }

    public boolean canOpenDoors() {
        return this.nodeEvaluator.d();
    }

    public boolean canPassDoors() {
        return this.nodeEvaluator.d();
    }

    protected boolean a() {
        return this.mob.isOnGround() || this.p() || this.mob.isPassenger();
    }

    private boolean canWalkAbove(int var0, int var1, int var2, int var3, int var4, int var5, Vec3D var6, double var7, double var9) {
        for (BlockPosition var12 : BlockPosition.a((BlockPosition)new BlockPosition(var0, var1, var2), (BlockPosition)new BlockPosition(var0 + var3 - 1, var1 + var4 - 1, var2 + var5 - 1))) {
            double var15;
            double var13 = (double)var12.getX() + 0.5 - var6.b;
            if (var13 * var7 + (var15 = (double)var12.getZ() + 0.5 - var6.d) * var9 < 0.0 || this.b.getType(var12).a((IBlockAccess)this.b, var12, PathMode.a)) continue;
            return false;
        }
        return true;
    }

    private boolean canWalkOn(int var0, int var1, int var2, int var3, int var4, int var5, Vec3D var6, double var7, double var9) {
        int var11 = var0 - var3 / 2;
        int var12 = var2 - var5 / 2;
        if (!this.canWalkAbove(var11, var1, var12, var3, var4, var5, var6, var7, var9)) {
            return false;
        }
        for (int var13 = var11; var13 < var11 + var3; ++var13) {
            for (int var14 = var12; var14 < var12 + var5; ++var14) {
                double var15 = (double)var13 + 0.5 - var6.b;
                double var17 = (double)var14 + 0.5 - var6.d;
                if (!(var15 * var7 + var17 * var9 >= 0.0)) continue;
                PathType var19 = this.nodeEvaluator.getBlockPathType((IBlockAccess)this.b, var13, var1 - 1, var14, this.mob, var3, var4, var5, true, true);
                if (!this.hasValidPathType(var19)) {
                    return false;
                }
                var19 = this.nodeEvaluator.getBlockPathType((IBlockAccess)this.b, var13, var1, var14, this.mob, var3, var4, var5, true, true);
                float var20 = this.mob.getPathfindingMalus(var19);
                if (var20 < 0.0f || var20 >= 8.0f) {
                    return false;
                }
                if (var19 != PathType.n && var19 != PathType.m && var19 != PathType.r) continue;
                return false;
            }
        }
        return true;
    }

    public PathEntity a(BlockPosition var0, int var1) {
        BlockPosition var2;
        if (this.b.getType(var0).isAir()) {
            var2 = var0.down();
            while (var2.getY() > this.b.getMinBuildHeight() && this.b.getType(var2).isAir()) {
                var2 = var2.down();
            }
            if (var2.getY() > this.b.getMinBuildHeight()) {
                return this.supercreatePath(var2.up(), var1);
            }
            while (var2.getY() < this.b.getMaxBuildHeight() && this.b.getType(var2).isAir()) {
                var2 = var2.up();
            }
            var0 = var2;
        }
        if (this.b.getType(var0).getMaterial().isBuildable()) {
            var2 = var0.up();
            while (var2.getY() < this.b.getMaxBuildHeight() && this.b.getType(var2).getMaterial().isBuildable()) {
                var2 = var2.up();
            }
            return this.supercreatePath(var2, var1);
        }
        return this.supercreatePath(var0, var1);
    }

    public PathEntity a(BlockPosition var0, int var1, int var2) {
        return this.a((Set<BlockPosition>)ImmutableSet.of((Object)var0), 8, false, var1, (float)var2);
    }

    public PathEntity a(Entity var0, int var1) {
        return this.a(var0.getChunkCoordinates(), var1);
    }

    public PathEntity a(Set<BlockPosition> var0, int var1) {
        return this.a(var0, 8, false, var1);
    }

    protected PathEntity a(Set<BlockPosition> var0, int var1, boolean var2, int var3) {
        return this.a(var0, var1, var2, var3, (float)this.mob.b(GenericAttributes.b));
    }

    protected PathEntity a(Set<BlockPosition> var0, int var1, boolean var2, int var3, float var4) {
        if (var0.isEmpty() || this.mob.locY() < (double)this.b.getMinBuildHeight() || !this.a()) {
            return null;
        }
        if (this.c != null && !this.c.c() && var0.contains(this.targetPos)) {
            return this.c;
        }
        this.b.getMethodProfiler().enter("pathfind");
        BlockPosition var5 = var2 ? this.mob.getChunkCoordinates().up() : this.mob.getChunkCoordinates();
        int var6 = (int)(var4 + (float)var1);
        ChunkCache var7 = new ChunkCache(this.b, var5.c(-var6, -var6, -var6), var5.c(var6, var6, var6));
        PathEntity var8 = this.pathFinder.findPath(var7, this.mob, var0, var4, var3, this.maxVisitedNodesMultiplier);
        this.b.getMethodProfiler().exit();
        if (var8 != null && var8.m() != null) {
            this.targetPos = var8.m();
            this.reachRange = var3;
            this.resetStuckTimeout();
        }
        return var8;
    }

    public PathEntity a(Stream<BlockPosition> var0, int var1) {
        return this.a(var0.collect(Collectors.toSet()), 8, false, var1);
    }

    protected Pathfinder a(int paramInt) {
        return null;
    }

    protected void a(Vec3D var0) {
        if (this.e - this.f > 100) {
            if (var0.distanceSquared(this.g) < 2.25) {
                this.isStuck = true;
                this.o();
            } else {
                this.isStuck = false;
            }
            this.f = this.e;
            this.g = var0;
        }
        if (this.c != null && !this.c.c()) {
            BlockPosition blockPos = this.c.g();
            if (blockPos.equals((Object)this.h)) {
                this.i += System.currentTimeMillis() - this.j;
            } else {
                this.h = blockPos;
                double var2 = var0.f(Vec3D.c((BaseBlockPosition)this.h));
                double d = this.k = this.mob.ew() > 0.0f ? var2 / (double)this.mob.ew() * 1000.0 : 0.0;
            }
            if (this.k > 0.0 && (double)this.i > this.k * 3.0) {
                this.timeoutPath();
            }
            this.j = System.currentTimeMillis();
        }
    }

    protected void l() {
        boolean var8;
        Vec3D var0 = this.b();
        this.l = this.mob.getWidth() > 0.75f ? this.mob.getWidth() / 2.0f : 0.75f - this.mob.getWidth() / 2.0f;
        BlockPosition blockPos = this.c.g();
        double var2 = Math.abs(this.mob.locX() - ((double)blockPos.getX() + 0.5));
        double var4 = Math.abs(this.mob.locY() - (double)blockPos.getY());
        double var6 = Math.abs(this.mob.locZ() - ((double)blockPos.getZ() + 0.5));
        boolean bl = var8 = var2 < (double)this.l && var6 < (double)this.l && var4 < 1.0;
        if (var8 || this.mob.canCutCorner(this.c.h().l) && this.shouldTargetNextNodeInDirection(var0)) {
            this.c.a();
        }
        this.a(var0);
    }

    public float s() {
        return this.l;
    }

    public PathfinderAbstract q() {
        return this.nodeEvaluator;
    }

    public PathEntity k() {
        return this.c;
    }

    public PathEntity getPathEntity() {
        return this.c;
    }

    private int getSurfaceY() {
        if (!this.mob.isInWater() || !this.r()) {
            return MathHelper.floor((double)(this.mob.locY() + 0.5));
        }
        int var0 = this.mob.cY();
        IBlockData var1 = this.b.getType(new BlockPosition(this.mob.locX(), (double)var0, this.mob.locZ()));
        int var2 = 0;
        while (var1.a(Blocks.A)) {
            var1 = this.b.getType(new BlockPosition(this.mob.locX(), (double)(++var0), this.mob.locZ()));
            if (++var2 <= 16) continue;
            return this.mob.cY();
        }
        return var0;
    }

    public BlockPosition h() {
        return this.targetPos;
    }

    protected Vec3D b() {
        return new Vec3D(this.mob.locX(), (double)this.getSurfaceY(), this.mob.locZ());
    }

    public boolean i() {
        return this.m;
    }

    protected boolean hasValidPathType(PathType var0) {
        return var0 != PathType.i && var0 != PathType.h && var0 != PathType.b;
    }

    public boolean m() {
        return this.c == null || this.c.c();
    }

    protected boolean p() {
        return this.mob.aO() || this.mob.aX();
    }

    public boolean n() {
        return !this.m();
    }

    public boolean a(BlockPosition var0) {
        BlockPosition var1 = var0.down();
        return this.b.getType(var1).i((IBlockAccess)this.b, var1);
    }

    public boolean t() {
        return this.isStuck;
    }

    public boolean a(double var0, double var2, double var4, double var6) {
        return this.a(this.a(new BlockPosition(var0, var2, var4), 1), var6);
    }

    public boolean a(Entity var0, double var1) {
        PathEntity var3 = this.a(var0, 1);
        return var3 != null && this.a(var3, var1);
    }

    public boolean a(PathEntity var0, double var1) {
        if (var0 == null) {
            this.c = null;
            return false;
        }
        if (!var0.a(this.c)) {
            this.c = var0;
        }
        if (this.m()) {
            return false;
        }
        this.D_();
        if (this.c.e() <= 0) {
            return false;
        }
        this.d = var1;
        Vec3D var3 = this.b();
        this.f = this.e;
        this.g = var3;
        return true;
    }

    public void j() {
        if (this.b.getTime() - this.n > 20L) {
            if (this.targetPos != null) {
                this.c = null;
                this.c = this.a(this.targetPos, this.reachRange);
                this.n = this.b.getTime();
                this.m = false;
            }
        } else {
            this.m = true;
        }
    }

    public void b(BlockPosition var0) {
        if (this.c == null || this.c.c() || this.c.e() == 0) {
            return;
        }
        PathPoint var1 = this.c.d();
        Vec3D var2 = new Vec3D(((double)var1.a + this.mob.locX()) / 2.0, ((double)var1.b + this.mob.locY()) / 2.0, ((double)var1.c + this.mob.locZ()) / 2.0);
        if (var0.a((IPosition)var2, (double)(this.c.e() - this.c.f()))) {
            this.j();
        }
    }

    public void g() {
        this.maxVisitedNodesMultiplier = 1.0f;
    }

    private void resetStuckTimeout() {
        this.h = BaseBlockPosition.f;
        this.i = 0L;
        this.k = 0.0;
        this.isStuck = false;
    }

    public void setAvoidSun(boolean var0) {
        this.avoidSun = var0;
    }

    public void d(boolean var0) {
        this.nodeEvaluator.c(var0);
    }

    public void setCanOpenDoors(boolean var0) {
        this.nodeEvaluator.b(var0);
    }

    public void setCanPassDoors(boolean var0) {
        this.nodeEvaluator.a(var0);
    }

    public void a(float var0) {
        this.maxVisitedNodesMultiplier = var0;
    }

    public void setRange(float pathfindingRange) {
        this.followRange.setValue((double)pathfindingRange);
    }

    public void a(double var0) {
        this.d = var0;
    }

    private boolean shouldTargetNextNodeInDirection(Vec3D var0) {
        Vec3D var4;
        if (this.c.f() + 1 >= this.c.e()) {
            return false;
        }
        Vec3D var1 = Vec3D.c((BaseBlockPosition)this.c.g());
        if (!var0.a((IPosition)var1, 2.0)) {
            return false;
        }
        Vec3D var2 = Vec3D.c((BaseBlockPosition)this.c.d(this.c.f() + 1));
        Vec3D var3 = var2.d(var1);
        return var3.b(var4 = var0.d(var1)) > 0.0;
    }

    public void o() {
        this.c = null;
    }

    public PathEntity supercreatePath(BlockPosition var0, int var1) {
        return this.a((Set<BlockPosition>)ImmutableSet.of((Object)var0), 8, false, var1);
    }

    protected void supertrimPath() {
        if (this.c == null) {
            return;
        }
        for (int var0 = 0; var0 < this.c.e(); ++var0) {
            PathPoint var1 = this.c.a(var0);
            PathPoint var2 = var0 + 1 < this.c.e() ? this.c.a(var0 + 1) : null;
            IBlockData var3 = this.b.getType(new BlockPosition(var1.a, var1.b, var1.c));
            if (!var3.a((Tag)TagsBlock.aV)) continue;
            this.c.a(var0, var1.a(var1.a, var1.b + 1, var1.c));
            if (var2 == null || var1.b < var2.b) continue;
            this.c.a(var0 + 1, var1.a(var2.a, var1.b + 1, var2.c));
        }
    }

    public void c() {
        ++this.e;
        if (this.m) {
            this.j();
        }
        if (this.m()) {
            return;
        }
        if (this.a()) {
            this.l();
        } else if (this.c != null && !this.c.c()) {
            Vec3D vec31 = this.b();
            Vec3D vec32 = this.c.a((Entity)this.mob);
            if (vec31.c > vec32.c && !this.mob.isOnGround() && MathHelper.floor((double)vec31.b) == MathHelper.floor((double)vec32.b) && MathHelper.floor((double)vec31.d) == MathHelper.floor((double)vec32.d)) {
                this.c.a();
            }
        }
        if (this.m()) {
            return;
        }
        Vec3D var0 = this.c.a((Entity)this.mob);
        BlockPosition var1 = new BlockPosition(var0);
        this.mob.getMoveControl().a(var0.b, this.b.getType(var1.down()).isAir() ? var0.c : PathfinderNormal.a((IBlockAccess)this.b, (BlockPosition)var1), var0.d, this.d);
    }

    private void timeoutPath() {
        this.resetStuckTimeout();
        this.o();
    }

    protected void D_() {
        this.supertrimPath();
        if (this.avoidSun) {
            if (this.b.g(new BlockPosition(this.mob.locX(), this.mob.locY() + 0.5, this.mob.locZ()))) {
                return;
            }
            for (int var0 = 0; var0 < this.c.e(); ++var0) {
                PathPoint var1 = this.c.a(var0);
                if (!this.b.g(new BlockPosition(var1.a, var1.b, var1.c))) continue;
                this.c.b(var0);
                return;
            }
        }
    }

    private static EntityInsentient getDummyInsentient(EntityHumanNPC from, World world) {
        return new EntityInsentient(EntityTypes.aV, world){};
    }
}

