/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_17_R1.util;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.citizensnpcs.nms.v1_17_R1.util.NMSImpl;
import net.citizensnpcs.util.PlayerAnimation;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.EnumHand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerAnimationImpl {
    private static EnumMap<PlayerAnimation, Integer> DEFAULTS = Maps.newEnumMap(PlayerAnimation.class);

    public static void play(PlayerAnimation animation, Player bplayer, int radius) {
        EntityPlayer player = (EntityPlayer)NMSImpl.getHandle((Entity)bplayer);
        if (DEFAULTS.containsKey((Object)animation)) {
            PlayerAnimationImpl.playDefaultAnimation(player, radius, DEFAULTS.get((Object)animation));
            return;
        }
        switch (animation) {
            case SNEAK: {
                player.getBukkitEntity().setSneaking(true);
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
                break;
            }
            case START_ELYTRA: {
                player.startGliding();
                break;
            }
            case STOP_ELYTRA: {
                player.stopGliding();
                break;
            }
            case START_USE_MAINHAND_ITEM: {
                player.c(EnumHand.a);
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
                break;
            }
            case START_USE_OFFHAND_ITEM: {
                player.c(EnumHand.b);
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
                break;
            }
            case STOP_SNEAKING: {
                player.getBukkitEntity().setSneaking(false);
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
                break;
            }
            case STOP_USE_ITEM: {
                player.clearActiveItem();
                PlayerAnimationImpl.sendPacketNearby(new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static void playDefaultAnimation(EntityPlayer player, int radius, int code) {
        PacketPlayOutAnimation packet = new PacketPlayOutAnimation((net.minecraft.world.entity.Entity)player, code);
        PlayerAnimationImpl.sendPacketNearby(packet, player, radius);
    }

    protected static void sendPacketNearby(Packet<?> packet, EntityPlayer player, int radius) {
        NMSImpl.sendPacketNearby((Player)player.getBukkitEntity(), player.getBukkitEntity().getLocation(), packet, radius);
    }

    static {
        DEFAULTS.put(PlayerAnimation.ARM_SWING, 0);
        DEFAULTS.put(PlayerAnimation.HURT, 1);
        DEFAULTS.put(PlayerAnimation.LEAVE_BED, 2);
        DEFAULTS.put(PlayerAnimation.ARM_SWING_OFFHAND, 3);
        DEFAULTS.put(PlayerAnimation.CRIT, 4);
        DEFAULTS.put(PlayerAnimation.MAGIC_CRIT, 5);
    }
}

