/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_17_R1.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.citizensnpcs.util.NMS;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCod;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySalmon;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCaveSpider;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;

public class CustomEntityRegistry
extends RegistryBlocks {
    private final BiMap<MinecraftKey, EntityTypes> entities = HashBiMap.create();
    private final BiMap<EntityTypes, MinecraftKey> entityClasses = this.entities.inverse();
    private final Map<EntityTypes, Integer> entityIds = Maps.newHashMap();
    private final RegistryMaterials<EntityTypes<?>> wrapped;
    private static final MethodHandle IREGISTRY_LIFECYCLE = NMS.getFirstGetter(IRegistry.class, Lifecycle.class);
    private static final MethodHandle IREGISTRY_RESOURCE_KEY = NMS.getGetter(IRegistry.class, "b");
    private static final BiMap<EntityTypes, Class<?>> minecraftClassMap = HashBiMap.create();

    public CustomEntityRegistry(RegistryBlocks<EntityTypes<?>> original) throws Throwable {
        super(original.a().getNamespace(), IREGISTRY_RESOURCE_KEY.invoke(original), IREGISTRY_LIFECYCLE.invoke(original));
        this.wrapped = original;
    }

    public Object fromId(int var0) {
        return this.wrapped.fromId(var0);
    }

    public EntityTypes findType(Class<?> search) {
        return (EntityTypes)minecraftClassMap.inverse().get(search);
    }

    public EntityTypes get(MinecraftKey key) {
        if (this.entities.containsKey((Object)key)) {
            return (EntityTypes)this.entities.get((Object)key);
        }
        return (EntityTypes)this.wrapped.get(key);
    }

    public int getId(Object key) {
        if (this.entityIds.containsKey(key)) {
            return this.entityIds.get(key);
        }
        return this.wrapped.getId((Object)((EntityTypes)key));
    }

    public MinecraftKey getKey(Object value) {
        if (this.entityClasses.containsKey(value)) {
            return (MinecraftKey)this.entityClasses.get(value);
        }
        return this.wrapped.getKey((Object)((EntityTypes)value));
    }

    public Optional getOptional(MinecraftKey var0) {
        if (this.entities.containsKey((Object)var0)) {
            return Optional.of((EntityTypes)this.entities.get((Object)var0));
        }
        return this.wrapped.getOptional(var0);
    }

    public Object a(Random paramRandom) {
        return this.wrapped.a(paramRandom);
    }

    public RegistryMaterials<EntityTypes<?>> getWrapped() {
        return this.wrapped;
    }

    public Iterator<Object> iterator() {
        return this.wrapped.iterator();
    }

    public Set<Object> keySet() {
        return this.wrapped.keySet();
    }

    public void put(int entityId, MinecraftKey key, EntityTypes entityClass) {
        this.entities.put((Object)key, (Object)entityClass);
        this.entityIds.put(entityClass, entityId);
    }

    static {
        minecraftClassMap.put((Object)EntityTypes.b, EntityAreaEffectCloud.class);
        minecraftClassMap.put((Object)EntityTypes.c, EntityArmorStand.class);
        minecraftClassMap.put((Object)EntityTypes.d, EntityTippedArrow.class);
        minecraftClassMap.put((Object)EntityTypes.e, Axolotl.class);
        minecraftClassMap.put((Object)EntityTypes.f, EntityBat.class);
        minecraftClassMap.put((Object)EntityTypes.g, EntityBee.class);
        minecraftClassMap.put((Object)EntityTypes.h, EntityBlaze.class);
        minecraftClassMap.put((Object)EntityTypes.i, EntityBoat.class);
        minecraftClassMap.put((Object)EntityTypes.j, EntityCat.class);
        minecraftClassMap.put((Object)EntityTypes.k, EntityCaveSpider.class);
        minecraftClassMap.put((Object)EntityTypes.l, EntityChicken.class);
        minecraftClassMap.put((Object)EntityTypes.m, EntityCod.class);
        minecraftClassMap.put((Object)EntityTypes.n, EntityCow.class);
        minecraftClassMap.put((Object)EntityTypes.o, EntityCreeper.class);
        minecraftClassMap.put((Object)EntityTypes.p, EntityDolphin.class);
        minecraftClassMap.put((Object)EntityTypes.q, EntityHorseDonkey.class);
        minecraftClassMap.put((Object)EntityTypes.r, EntityDragonFireball.class);
        minecraftClassMap.put((Object)EntityTypes.s, EntityDrowned.class);
        minecraftClassMap.put((Object)EntityTypes.t, EntityGuardianElder.class);
        minecraftClassMap.put((Object)EntityTypes.u, EntityEnderCrystal.class);
        minecraftClassMap.put((Object)EntityTypes.v, EntityEnderDragon.class);
        minecraftClassMap.put((Object)EntityTypes.w, EntityEnderman.class);
        minecraftClassMap.put((Object)EntityTypes.x, EntityEndermite.class);
        minecraftClassMap.put((Object)EntityTypes.y, EntityEvoker.class);
        minecraftClassMap.put((Object)EntityTypes.z, EntityEvokerFangs.class);
        minecraftClassMap.put((Object)EntityTypes.A, EntityExperienceOrb.class);
        minecraftClassMap.put((Object)EntityTypes.B, EntityEnderSignal.class);
        minecraftClassMap.put((Object)EntityTypes.C, EntityFallingBlock.class);
        minecraftClassMap.put((Object)EntityTypes.D, EntityFireworks.class);
        minecraftClassMap.put((Object)EntityTypes.E, EntityFox.class);
        minecraftClassMap.put((Object)EntityTypes.F, EntityGhast.class);
        minecraftClassMap.put((Object)EntityTypes.G, EntityGiantZombie.class);
        minecraftClassMap.put((Object)EntityTypes.H, GlowItemFrame.class);
        minecraftClassMap.put((Object)EntityTypes.I, GlowSquid.class);
        minecraftClassMap.put((Object)EntityTypes.J, Goat.class);
        minecraftClassMap.put((Object)EntityTypes.K, EntityGuardian.class);
        minecraftClassMap.put((Object)EntityTypes.L, EntityHoglin.class);
        minecraftClassMap.put((Object)EntityTypes.M, EntityHorse.class);
        minecraftClassMap.put((Object)EntityTypes.N, EntityZombieHusk.class);
        minecraftClassMap.put((Object)EntityTypes.O, EntityIllagerIllusioner.class);
        minecraftClassMap.put((Object)EntityTypes.P, EntityIronGolem.class);
        minecraftClassMap.put((Object)EntityTypes.Q, EntityItem.class);
        minecraftClassMap.put((Object)EntityTypes.R, EntityItemFrame.class);
        minecraftClassMap.put((Object)EntityTypes.S, EntityLargeFireball.class);
        minecraftClassMap.put((Object)EntityTypes.T, EntityLeash.class);
        minecraftClassMap.put((Object)EntityTypes.U, EntityLightning.class);
        minecraftClassMap.put((Object)EntityTypes.V, EntityLlama.class);
        minecraftClassMap.put((Object)EntityTypes.W, EntityLlamaSpit.class);
        minecraftClassMap.put((Object)EntityTypes.X, EntityMagmaCube.class);
        minecraftClassMap.put((Object)EntityTypes.Y, Marker.class);
        minecraftClassMap.put((Object)EntityTypes.Z, EntityMinecartRideable.class);
        minecraftClassMap.put((Object)EntityTypes.aa, EntityMinecartChest.class);
        minecraftClassMap.put((Object)EntityTypes.ab, EntityMinecartCommandBlock.class);
        minecraftClassMap.put((Object)EntityTypes.ac, EntityMinecartFurnace.class);
        minecraftClassMap.put((Object)EntityTypes.ad, EntityMinecartHopper.class);
        minecraftClassMap.put((Object)EntityTypes.ae, EntityMinecartMobSpawner.class);
        minecraftClassMap.put((Object)EntityTypes.af, EntityMinecartTNT.class);
        minecraftClassMap.put((Object)EntityTypes.ag, EntityHorseMule.class);
        minecraftClassMap.put((Object)EntityTypes.ah, EntityMushroomCow.class);
        minecraftClassMap.put((Object)EntityTypes.ai, EntityOcelot.class);
        minecraftClassMap.put((Object)EntityTypes.aj, EntityPainting.class);
        minecraftClassMap.put((Object)EntityTypes.ak, EntityPanda.class);
        minecraftClassMap.put((Object)EntityTypes.al, EntityParrot.class);
        minecraftClassMap.put((Object)EntityTypes.am, EntityPhantom.class);
        minecraftClassMap.put((Object)EntityTypes.an, EntityPig.class);
        minecraftClassMap.put((Object)EntityTypes.ao, EntityPiglin.class);
        minecraftClassMap.put((Object)EntityTypes.ap, EntityPiglinBrute.class);
        minecraftClassMap.put((Object)EntityTypes.aq, EntityPillager.class);
        minecraftClassMap.put((Object)EntityTypes.ar, EntityPolarBear.class);
        minecraftClassMap.put((Object)EntityTypes.as, EntityTNTPrimed.class);
        minecraftClassMap.put((Object)EntityTypes.at, EntityPufferFish.class);
        minecraftClassMap.put((Object)EntityTypes.au, EntityRabbit.class);
        minecraftClassMap.put((Object)EntityTypes.av, EntityRavager.class);
        minecraftClassMap.put((Object)EntityTypes.aw, EntitySalmon.class);
        minecraftClassMap.put((Object)EntityTypes.ax, EntitySheep.class);
        minecraftClassMap.put((Object)EntityTypes.ay, EntityShulker.class);
        minecraftClassMap.put((Object)EntityTypes.az, EntityShulkerBullet.class);
        minecraftClassMap.put((Object)EntityTypes.aA, EntitySilverfish.class);
        minecraftClassMap.put((Object)EntityTypes.aB, EntitySkeleton.class);
        minecraftClassMap.put((Object)EntityTypes.aC, EntityHorseSkeleton.class);
        minecraftClassMap.put((Object)EntityTypes.aD, EntitySlime.class);
        minecraftClassMap.put((Object)EntityTypes.aE, EntitySmallFireball.class);
        minecraftClassMap.put((Object)EntityTypes.aF, EntitySnowman.class);
        minecraftClassMap.put((Object)EntityTypes.aG, EntitySnowball.class);
        minecraftClassMap.put((Object)EntityTypes.aH, EntitySpectralArrow.class);
        minecraftClassMap.put((Object)EntityTypes.aI, EntitySpider.class);
        minecraftClassMap.put((Object)EntityTypes.aJ, EntitySquid.class);
        minecraftClassMap.put((Object)EntityTypes.aK, EntitySkeletonStray.class);
        minecraftClassMap.put((Object)EntityTypes.aL, EntityStrider.class);
        minecraftClassMap.put((Object)EntityTypes.aM, EntityEgg.class);
        minecraftClassMap.put((Object)EntityTypes.aN, EntityEnderPearl.class);
        minecraftClassMap.put((Object)EntityTypes.aO, EntityThrownExpBottle.class);
        minecraftClassMap.put((Object)EntityTypes.aP, EntityPotion.class);
        minecraftClassMap.put((Object)EntityTypes.aQ, EntityThrownTrident.class);
        minecraftClassMap.put((Object)EntityTypes.aR, EntityLlamaTrader.class);
        minecraftClassMap.put((Object)EntityTypes.aS, EntityTropicalFish.class);
        minecraftClassMap.put((Object)EntityTypes.aT, EntityTurtle.class);
        minecraftClassMap.put((Object)EntityTypes.aU, EntityVex.class);
        minecraftClassMap.put((Object)EntityTypes.aV, EntityVillager.class);
        minecraftClassMap.put((Object)EntityTypes.aW, EntityVindicator.class);
        minecraftClassMap.put((Object)EntityTypes.aX, EntityVillagerTrader.class);
        minecraftClassMap.put((Object)EntityTypes.aY, EntityWitch.class);
        minecraftClassMap.put((Object)EntityTypes.aZ, EntityWither.class);
        minecraftClassMap.put((Object)EntityTypes.ba, EntitySkeletonWither.class);
        minecraftClassMap.put((Object)EntityTypes.bb, EntityWitherSkull.class);
        minecraftClassMap.put((Object)EntityTypes.bc, EntityWolf.class);
        minecraftClassMap.put((Object)EntityTypes.bd, EntityZoglin.class);
        minecraftClassMap.put((Object)EntityTypes.be, EntityZombie.class);
        minecraftClassMap.put((Object)EntityTypes.bf, EntityHorseZombie.class);
        minecraftClassMap.put((Object)EntityTypes.bg, EntityZombieVillager.class);
        minecraftClassMap.put((Object)EntityTypes.bh, EntityPigZombie.class);
        minecraftClassMap.put((Object)EntityTypes.bj, EntityFishingHook.class);
    }
}

