/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_17_R1.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_17_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_17_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_17_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftLargeFireball;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LargeFireball;
import org.bukkit.util.Vector;

public class LargeFireballController
extends MobEntityController {
    public LargeFireballController() {
        super(EntityLargeFireballNPC.class);
    }

    public LargeFireball getBukkitEntity() {
        return (LargeFireball)super.getBukkitEntity();
    }

    public static class EntityLargeFireballNPC
    extends EntityLargeFireball
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityLargeFireballNPC(EntityTypes<? extends EntityLargeFireball> types, World level) {
            this(types, level, null);
        }

        public EntityLargeFireballNPC(EntityTypes<? extends EntityLargeFireball> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new LargeFireballNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void collide(net.minecraft.world.entity.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void updateSize() {
            if (this.npc == null) {
                super.updateSize();
            } else {
                NMSImpl.setSize((net.minecraft.world.entity.Entity)this, this.X);
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public void tick() {
            if (this.npc != null) {
                this.npc.update();
                if (!this.npc.data().get("protected", Boolean.valueOf(true)).booleanValue()) {
                    super.tick();
                }
            } else {
                super.tick();
            }
        }

        public boolean a(Tag<FluidType> Tag2, double d0) {
            Vec3D old = this.getMot().add(0.0, 0.0, 0.0);
            boolean res = super.a(Tag2, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(old);
            }
            return res;
        }
    }

    public static class LargeFireballNPC
    extends CraftLargeFireball
    implements ForwardingNPCHolder {
        public LargeFireballNPC(EntityLargeFireballNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityLargeFireball)entity);
        }
    }
}

