/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_17_R1.entity.nonliving;

import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_17_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_17_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftItemFrame;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ItemFrameController
extends MobEntityController {
    public ItemFrameController() {
        super(EntityItemFrameNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        Entity e2 = super.createEntity(at, npc);
        EntityItemFrame item = (EntityItemFrame)((CraftEntity)e2).getHandle();
        item.setDirection(EnumDirection.f);
        item.c = new BlockPosition(at.getX(), at.getY(), at.getZ());
        return e2;
    }

    public ItemFrame getBukkitEntity() {
        return (ItemFrame)super.getBukkitEntity();
    }

    public static class EntityItemFrameNPC
    extends EntityItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityItemFrameNPC(EntityTypes<? extends EntityItemFrame> types, World level) {
            this(types, level, null);
        }

        public EntityItemFrameNPC(EntityTypes<? extends EntityItemFrame> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new ItemFrameNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void collide(net.minecraft.world.entity.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public boolean survives() {
            return this.npc == null || !this.npc.isProtected() ? super.survives() : true;
        }

        public void tick() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.tick();
            }
        }

        public boolean a(Tag<FluidType> Tag2, double d0) {
            Vec3D old = this.getMot().add(0.0, 0.0, 0.0);
            boolean res = super.a(Tag2, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(old);
            }
            return res;
        }
    }

    public static class ItemFrameNPC
    extends CraftItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public ItemFrameNPC(EntityItemFrameNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityItemFrame)entity);
            this.npc = entity.npc;
            int amount = this.npc.data().get("item-type-amount", Integer.valueOf(1));
            Material material = Material.getMaterial((String)this.npc.data().get("item-type-id", "STONE"), (boolean)false);
            Number durability = this.npc.data().get("item-type-data", (Number)this.npc.data().get("falling-block-data", Short.valueOf((short)0)));
            this.setItem(new ItemStack(material, amount, durability.shortValue()));
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void setType(Material material, int data) {
            this.npc.data().setPersistent("item-type-id", (Object)material.name());
            this.npc.data().setPersistent("item-type-data", (Object)data);
            if (this.npc.isSpawned()) {
                this.npc.despawn(DespawnReason.PENDING_RESPAWN);
                this.npc.spawn(this.npc.getStoredLocation(), SpawnReason.RESPAWN);
            }
        }
    }
}

