/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_17_R1.entity.nonliving;

import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_17_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_17_R1.entity.nonliving.ItemFrameController;
import net.citizensnpcs.nms.v1_17_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftGlowItemFrame;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class GlowItemFrameController
extends MobEntityController {
    public GlowItemFrameController() {
        super(ItemFrameController.EntityItemFrameNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        Entity e2 = super.createEntity(at, npc);
        GlowItemFrame item = (GlowItemFrame)((CraftEntity)e2).getHandle();
        item.setDirection(EnumDirection.f);
        item.c = new BlockPosition(at.getX(), at.getY(), at.getZ());
        return e2;
    }

    public org.bukkit.entity.GlowItemFrame getBukkitEntity() {
        return (org.bukkit.entity.GlowItemFrame)super.getBukkitEntity();
    }

    public static class GlowItemFrameNPC
    extends CraftGlowItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public GlowItemFrameNPC(EntityGlowItemFrameNPC entity) {
            super((CraftServer)Bukkit.getServer(), (GlowItemFrame)entity);
            this.npc = entity.npc;
            Material id = Material.STONE;
            int data = this.npc.data().get("item-type-data", this.npc.data().get("falling-block-data", Integer.valueOf(0)));
            if (this.npc.data().has("item-type-id")) {
                id = Material.getMaterial((String)((String)this.npc.data().get("item-type-id")));
            }
            this.getItem().setAmount(this.npc.data().get("item-type-amount", Integer.valueOf(1)).intValue());
            this.getItem().setType(id);
            this.getItem().setDurability((short)data);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void setType(Material material, int data) {
            this.npc.data().setPersistent("item-type-id", (Object)material.name());
            this.npc.data().setPersistent("item-type-data", (Object)data);
            if (this.npc.isSpawned()) {
                this.npc.despawn(DespawnReason.PENDING_RESPAWN);
                this.npc.spawn(this.npc.getStoredLocation(), SpawnReason.RESPAWN);
            }
        }
    }

    public static class EntityGlowItemFrameNPC
    extends GlowItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityGlowItemFrameNPC(EntityTypes<? extends GlowItemFrame> types, World level) {
            this(types, level, null);
        }

        public EntityGlowItemFrameNPC(EntityTypes<? extends GlowItemFrame> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new GlowItemFrameNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void collide(net.minecraft.world.entity.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public boolean survives() {
            return this.npc == null || !this.npc.isProtected() ? super.survives() : true;
        }

        public void tick() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.tick();
            }
        }

        public boolean a(Tag<FluidType> Tag2, double d0) {
            Vec3D old = this.getMot().add(0.0, 0.0, 0.0);
            boolean res = super.a(Tag2, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(old);
            }
            return res;
        }
    }
}

