/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_17_R1.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_17_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_17_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_17_R1.util.NMSImpl;
import net.citizensnpcs.nms.v1_17_R1.util.PlayerMoveControl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.PufferFishTrait;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.Tag;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPufferFish;
import org.bukkit.entity.Entity;
import org.bukkit.entity.PufferFish;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class PufferFishController
extends MobEntityController {
    public PufferFishController() {
        super(EntityPufferFishNPC.class);
    }

    public PufferFish getBukkitEntity() {
        return (PufferFish)super.getBukkitEntity();
    }

    public static class EntityPufferFishNPC
    extends EntityPufferFish
    implements NPCHolder {
        private final CitizensNPC npc;
        private ControllerMove oldMoveController;

        public EntityPufferFishNPC(EntityTypes<? extends EntityPufferFish> types, World level) {
            this(types, level, null);
        }

        public EntityPufferFishNPC(EntityTypes<? extends EntityPufferFish> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.oldMoveController = this.bM;
                this.bM = new ControllerMove((EntityInsentient)this);
            }
        }

        public void movementTick() {
            boolean lastInWater = this.B;
            int lastPuffState = this.getPuffState();
            if (this.npc != null) {
                this.B = false;
                this.setPuffState(0);
            }
            super.movementTick();
            if (this.npc != null) {
                this.B = lastInWater;
                this.setPuffState(lastPuffState);
            }
        }

        protected boolean l(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return this.npc.data().get("protected", Boolean.valueOf(true)) == false;
            }
            return super.l(entity);
        }

        public boolean a(float f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void mobTick() {
            super.mobTick();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI() && this.bM != this.oldMoveController) {
                    this.bM = this.oldMoveController;
                }
                if (!this.npc.useMinecraftAI() && this.bM == this.oldMoveController) {
                    this.bM = new PlayerMoveControl((EntityLiving)this);
                }
                this.npc.update();
            }
        }

        public void a(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.a(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.a(d0, d1, d2);
            }
        }

        protected SoundEffect getSoundAmbient() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundAmbient(), "ambient-sound");
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PufferFishNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect getSoundDeath() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundDeath(), "death-sound");
        }

        public EntitySize a(EntityPose entitypose) {
            if (this.npc == null) {
                return super.a(entitypose);
            }
            return super.a(entitypose).a(1.0f / EntityPufferFishNPC.s(this.getPuffState())).a(0.5f);
        }

        protected SoundEffect getSoundHurt(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundHurt(damagesource), "hurt-sound");
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean isLeashed() {
            if (this.npc == null) {
                return super.isLeashed();
            }
            boolean protectedDefault = this.npc.data().get("protected", Boolean.valueOf(true));
            if (!protectedDefault || !this.npc.data().get("protected-leash", Boolean.valueOf(protectedDefault)).booleanValue()) {
                return super.isLeashed();
            }
            if (super.isLeashed()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void p(double strength, double dx, double dz) {
            NPCKnockbackEvent event = new NPCKnockbackEvent(this.npc, strength, dx, dz);
            Bukkit.getPluginManager().callEvent((Event)event);
            Vector kb = event.getKnockbackVector();
            super.p(event.getStrength(), kb.getX(), kb.getZ());
        }

        protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
            if (this.npc == null || !this.npc.isProtected()) {
                return super.b(entityhuman, enumhand);
            }
            ItemStack itemstack = entityhuman.b(enumhand);
            if (itemstack.getItem() == Items.nX && this.isAlive()) {
                return EnumInteractionResult.e;
            }
            return super.b(entityhuman, enumhand);
        }

        public boolean isClimbing() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.isClimbing();
            }
            return false;
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void collide(net.minecraft.world.entity.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public void tick() {
            if (this.npc != null) {
                NMSImpl.resetPuffTicks(this);
            }
            super.tick();
            PufferFishTrait trait = null;
            if (this.npc != null && (trait = this.npc.getTraitNullable(PufferFishTrait.class)) != null) {
                this.setPuffState(trait.getPuffState());
            }
        }

        public void g(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                if (!NMSImpl.moveFish(this.npc, (EntityInsentient)this, vec3d)) {
                    super.g(vec3d);
                }
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(Tag<FluidType> Tag2, double d0) {
            Vec3D old = this.getMot().add(0.0, 0.0, 0.0);
            boolean res = super.a(Tag2, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(old);
            }
            return res;
        }

        private static float s(int i) {
            switch (i) {
                case 0: {
                    return 0.5f;
                }
                case 1: {
                    return 0.7f;
                }
            }
            return 1.0f;
        }
    }

    public static class PufferFishNPC
    extends CraftPufferFish
    implements ForwardingNPCHolder {
        public PufferFishNPC(EntityPufferFishNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPufferFish)entity);
        }
    }
}

