/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_17_R1.entity;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.WeakHashMap;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_17_R1.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.entity.Entity;

public abstract class MobEntityController
extends AbstractEntityController {
    private final Class<?> clazz;
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new WeakHashMap();

    protected MobEntityController(Class<?> clazz) {
        super(clazz);
        this.clazz = clazz;
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        Material beneath;
        EntityTypes type = NMSImpl.getEntityType(this.clazz);
        net.minecraft.world.entity.Entity entity = this.createEntityFromClass(type, ((CraftWorld)at.getWorld()).getHandle(), npc);
        entity.setLocation(at.getX(), at.getY(), at.getZ(), at.getYaw(), at.getPitch());
        if (entity instanceof EntityInsentient) {
            NMSImpl.clearGoals(npc, ((EntityInsentient)entity).bP, ((EntityInsentient)entity).bQ);
        }
        if ((beneath = at.getBlock().getRelative(BlockFace.DOWN).getType()).isSolid()) {
            entity.setOnGround(true);
        }
        entity.a_(npc.getUniqueId());
        if (Settings.Setting.USE_SCOREBOARD_TEAMS.asBoolean()) {
            npc.getOrAddTrait(ScoreboardTrait.class).createTeam(npc.getUniqueId().toString());
        }
        return entity.getBukkitEntity();
    }

    private net.minecraft.world.entity.Entity createEntityFromClass(Object ... args) {
        try {
            return (net.minecraft.world.entity.Entity)MobEntityController.getConstructor(this.clazz).newInstance(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static Constructor<?> getConstructor(Class<?> clazz) {
        Constructor<?> constructor = CONSTRUCTOR_CACHE.get(clazz);
        if (constructor != null) {
            return constructor;
        }
        try {
            constructor = clazz.getConstructor(EntityTypes.class, World.class, NPC.class);
            CONSTRUCTOR_CACHE.put(clazz, constructor);
            return constructor;
        }
        catch (Exception ex) {
            throw new IllegalStateException("unable to find an entity constructor");
        }
    }
}

