/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_17_R1.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_17_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_17_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_17_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftSkeletonHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class HorseSkeletonController
extends MobEntityController {
    public HorseSkeletonController() {
        super(EntityHorseSkeletonNPC.class);
    }

    public SkeletonHorse getBukkitEntity() {
        return (SkeletonHorse)super.getBukkitEntity();
    }

    @Override
    public void spawn(Location at, NPC npc) {
        npc.getOrAddTrait(HorseModifiers.class);
        super.spawn(at, npc);
    }

    public static class EntityHorseSkeletonNPC
    extends EntityHorseSkeleton
    implements NPCHolder {
        private double baseMovementSpeed;
        boolean calledNMSHeight = false;
        private final CitizensNPC npc;
        private boolean riding;

        public EntityHorseSkeletonNPC(EntityTypes<? extends EntityHorseSkeleton> types, World level) {
            this(types, level, null);
        }

        public EntityHorseSkeletonNPC(EntityTypes<? extends EntityHorseSkeleton> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                ((SkeletonHorse)this.getBukkitEntity()).setDomestication(((SkeletonHorse)this.getBukkitEntity()).getMaxDomestication());
                this.baseMovementSpeed = this.getAttributeInstance(GenericAttributes.d).getValue();
            }
        }

        public boolean fd() {
            return this.npc != null && this.npc.getNavigator().isNavigating() ? false : super.fd();
        }

        protected boolean l(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return this.npc.data().get("protected", Boolean.valueOf(true)) == false;
            }
            return super.l(entity);
        }

        public boolean a(float f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void mobTick() {
            super.mobTick();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                if (this.npc.hasTrait(Controllable.class) && this.npc.getOrAddTrait(Controllable.class).isEnabled()) {
                    this.riding = this.getBukkitEntity().getPassengers().size() > 0;
                    this.getAttributeInstance(GenericAttributes.d).setValue(this.baseMovementSpeed * (double)this.npc.getNavigator().getDefaultParameters().speedModifier());
                } else {
                    this.riding = false;
                }
                if (this.riding) {
                    if (this.npc.getNavigator().isNavigating()) {
                        CraftEntity basePassenger = ((net.minecraft.world.entity.Entity)this.at.get(0)).getBukkitEntity();
                        NMS.look((Entity)basePassenger, this.getYRot(), this.getXRot());
                    }
                    this.d(4, true);
                }
                NMS.setStepHeight((Entity)this.getBukkitEntity(), 1.0f);
                this.npc.update();
            }
        }

        public void a(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.a(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.a(d0, d1, d2);
            }
        }

        protected SoundEffect getSoundAmbient() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundAmbient(), "ambient-sound");
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new HorseSkeletonNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect getSoundDeath() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundDeath(), "death-sound");
        }

        protected SoundEffect getSoundHurt(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundHurt(damagesource), "hurt-sound");
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean cH() {
            if (this.npc != null && this.riding) {
                return true;
            }
            return super.cH();
        }

        public boolean isLeashed() {
            if (this.npc == null) {
                return super.isLeashed();
            }
            boolean protectedDefault = this.npc.data().get("protected", Boolean.valueOf(true));
            if (!protectedDefault || !this.npc.data().get("protected-leash", Boolean.valueOf(protectedDefault)).booleanValue()) {
                return super.isLeashed();
            }
            if (super.isLeashed()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void p(double strength, double dx, double dz) {
            NPCKnockbackEvent event = new NPCKnockbackEvent(this.npc, strength, dx, dz);
            Bukkit.getPluginManager().callEvent((Event)event);
            Vector kb = event.getKnockbackVector();
            super.p(event.getStrength(), kb.getX(), kb.getZ());
        }

        public boolean isClimbing() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.isClimbing();
            }
            return false;
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc != null && !this.calledNMSHeight) {
                this.calledNMSHeight = true;
                NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject);
                this.calledNMSHeight = false;
                return;
            }
            super.a(datawatcherobject);
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void collide(net.minecraft.world.entity.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public void g(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.g(vec3d);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(Tag<FluidType> Tag2, double d0) {
            Vec3D old = this.getMot().add(0.0, 0.0, 0.0);
            boolean res = super.a(Tag2, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(old);
            }
            return res;
        }
    }

    public static class HorseSkeletonNPC
    extends CraftSkeletonHorse
    implements ForwardingNPCHolder {
        public HorseSkeletonNPC(EntityHorseSkeletonNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityHorseSkeleton)entity);
        }
    }
}

