/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_17_R1.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_17_R1.network.EmptyNetHandler;
import net.citizensnpcs.nms.v1_17_R1.network.EmptyNetworkManager;
import net.citizensnpcs.nms.v1_17_R1.network.EmptySocket;
import net.citizensnpcs.nms.v1_17_R1.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_17_R1.util.EmptyServerStatsCounter;
import net.citizensnpcs.nms.v1_17_R1.util.NMSImpl;
import net.citizensnpcs.nms.v1_17_R1.util.PlayerControllerJump;
import net.citizensnpcs.nms.v1_17_R1.util.PlayerMoveControl;
import net.citizensnpcs.nms.v1_17_R1.util.PlayerNavigation;
import net.citizensnpcs.nms.v1_17_R1.util.PlayerlistTracker;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder,
SkinnableEntity {
    private PlayerControllerJump controllerJump;
    private PlayerMoveControl controllerMove;
    private final Map<EnumItemSlot, ItemStack> equipmentCache = Maps.newEnumMap(EnumItemSlot.class);
    private int jumpTicks = 0;
    private final Map<PathType, Float> malus = Maps.newEnumMap(PathType.class);
    private PlayerNavigation navigation;
    private final CitizensNPC npc;
    private final Location packetLocationCache = new Location(null, 0.0, 0.0, 0.0);
    private PlayerlistTracker playerlistTracker;
    private final SkinPacketTracker skinTracker;
    private EmptyServerStatsCounter statsCache;
    private int updateCounter = 0;
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP = NMS.getFirstGetter(AttributeProvider.class, Map.class);
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP_SETTER = NMS.getFinalSetter(AttributeProvider.class, "a");
    private static final MethodHandle ATTRIBUTE_SUPPLIER = NMS.getFirstGetter(AttributeMapBase.class, AttributeProvider.class);
    private static final float EPSILON = 0.003f;
    private static final MethodHandle GAMEMODE_SETTING = NMS.getFirstMethodHandle(PlayerInteractManager.class, true, EnumGamemode.class, EnumGamemode.class);
    private static final Location LOADED_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer world, GameProfile gameProfile, NPC npc) {
        super(minecraftServer, world, gameProfile);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.skinTracker = new SkinPacketTracker(this);
            try {
                GAMEMODE_SETTING.invoke(this.d, EnumGamemode.a, null);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            this.initialise(minecraftServer);
        } else {
            this.skinTracker = null;
        }
    }

    public boolean a(EntityPlayer entityplayer) {
        if (this.npc != null && this.playerlistTracker == null) {
            return false;
        }
        return super.a(entityplayer);
    }

    public boolean canCutCorner(PathType pathtype) {
        return pathtype != PathType.m && pathtype != PathType.o && pathtype != PathType.q && pathtype != PathType.d;
    }

    public boolean a(float f, float f1, DamageSource damagesource) {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.a(f, f1, damagesource);
        }
        return false;
    }

    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, iblockdata, blockposition);
        }
    }

    public void die(DamageSource damagesource) {
        if (this.be) {
            return;
        }
        super.die(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                EntityHumanNPC.this.getWorldServer().a((EntityPlayer)EntityHumanNPC.this, Entity.RemovalReason.a);
                ((WorldServer)EntityHumanNPC.this.t).getChunkProvider().removeEntity((net.minecraft.world.entity.Entity)EntityHumanNPC.this);
            }
        }, 15L);
    }

    public void a(double d0, double d1, double d2) {
        if (this.npc == null) {
            super.a(d0, d1, d2);
            return;
        }
        NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            super.a(d0, d1, d2);
        }
    }

    public void playerTick() {
        boolean navigating;
        if (this.npc == null) {
            super.playerTick();
            return;
        }
        super.entityBaseTick();
        boolean bl = navigating = this.npc.getNavigator().isNavigating() || this.controllerMove.b();
        if (!navigating && this.getBukkitEntity() != null && (!this.npc.hasTrait(Gravity.class) || this.npc.getOrAddTrait(Gravity.class).hasGravity()) && Util.isLoaded(this.getBukkitEntity().getLocation(LOADED_LOCATION)) && SpigotUtil.checkYSafe(this.locY(), this.getBukkitEntity().getWorld())) {
            this.moveWithFallDamage(Vec3D.a);
        }
        Vec3D mot = this.getMot();
        if (Math.abs(mot.b) < (double)0.003f && Math.abs(mot.c) < (double)0.003f && Math.abs(mot.d) < (double)0.003f) {
            this.setMot(Vec3D.a);
        }
        if (navigating) {
            if (!this.navigation.m()) {
                this.navigation.c();
            }
            this.moveOnCurrentHeading();
        }
        NMSImpl.updateAI((EntityLiving)this);
        if (this.isSpectator()) {
            this.P = true;
            this.z = false;
        }
        if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue()) {
            this.collideNearby();
        }
        if (this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(!this.npc.isProtected())).booleanValue()) {
            AxisAlignedBB axisalignedbb = this.isPassenger() && !this.getVehicle().isRemoved() ? this.getBoundingBox().b(this.getVehicle().getBoundingBox()).grow(1.0, 0.0, 1.0) : this.getBoundingBox().grow(1.0, 0.5, 1.0);
            for (net.minecraft.world.entity.Entity entity : this.t.getEntities((net.minecraft.world.entity.Entity)this, axisalignedbb)) {
                entity.pickup((EntityHuman)this);
            }
        }
    }

    public Packet<?> getPacket() {
        if (this.playerlistTracker != null) {
            this.playerlistTracker.updateLastPlayer();
        }
        return super.getPacket();
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
            NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PlayerNPC(this));
        }
        return super.getBukkitEntity();
    }

    public PlayerControllerJump getControllerJump() {
        return this.controllerJump;
    }

    protected SoundEffect getSoundDeath() {
        return NMSImpl.getSoundEffect(this.npc, super.getSoundDeath(), "death-sound");
    }

    protected SoundEffect getSoundHurt(DamageSource damagesource) {
        return NMSImpl.getSoundEffect(this.npc, super.getSoundHurt(damagesource), "hurt-sound");
    }

    public PlayerMoveControl getMoveControl() {
        return this.controllerMove;
    }

    public NavigationAbstract getNavigation() {
        return this.navigation;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    public float getPathfindingMalus(PathType pathtype) {
        return this.malus.containsKey(pathtype) ? this.malus.get(pathtype).floatValue() : pathtype.a();
    }

    @Override
    public GameProfile getProfile() {
        return super.getProfile();
    }

    @Override
    public String getSkinName() {
        String skinName = this.npc.getOrAddTrait(SkinTrait.class).getSkinName();
        if (skinName == null) {
            skinName = this.npc.getName();
        }
        return skinName.toLowerCase();
    }

    @Override
    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public ServerStatisticManager getStatisticManager() {
        return this.statsCache == null ? (this.statsCache = new EmptyServerStatsCounter()) : this.statsCache;
    }

    public IChatBaseComponent getPlayerListName() {
        if (this.npc.data().get("removefromplayerlist", Boolean.valueOf(Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean())).booleanValue()) {
            return new ChatComponentText("");
        }
        return super.getPlayerListName();
    }

    public boolean damageEntity(DamageSource damagesource, float f) {
        boolean damaged = super.damageEntity(damagesource, f);
        if (damaged && this.C) {
            this.C = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    EntityHumanNPC.this.C = true;
                }
            });
        }
        return damaged;
    }

    private void initialise(MinecraftServer minecraftServer) {
        EmptySocket socket = new EmptySocket();
        EmptyNetworkManager conn = null;
        try {
            conn = new EmptyNetworkManager(EnumProtocolDirection.b);
            this.b = new EmptyNetHandler(minecraftServer, conn, this);
            conn.setPacketListener((PacketListener)this.b);
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AttributeModifiable range = this.getAttributeInstance(GenericAttributes.b);
        if (range == null) {
            try {
                AttributeProvider provider = ATTRIBUTE_SUPPLIER.invoke(this.getAttributeMap());
                HashMap all = Maps.newHashMap((Map)ATTRIBUTE_PROVIDER_MAP.invoke(provider));
                all.put(GenericAttributes.b, new AttributeModifiable(GenericAttributes.b, (Consumer)new Consumer<AttributeModifiable>(){

                    @Override
                    public void accept(AttributeModifiable att) {
                        throw new UnsupportedOperationException("Tried to change value for default attribute instance FOLLOW_RANGE");
                    }
                }));
                ATTRIBUTE_PROVIDER_MAP_SETTER.invoke(provider, ImmutableMap.copyOf((Map)all));
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            range = this.getAttributeInstance(GenericAttributes.b);
        }
        this.getAttributeInstance(GenericAttributes.d).setValue(0.3);
        range.setValue(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
        this.controllerJump = new PlayerControllerJump(this);
        this.controllerMove = new PlayerMoveControl((EntityLiving)this);
        this.navigation = new PlayerNavigation(this, this.t);
        this.W = 0;
        NMS.setStepHeight((Entity)this.getBukkitEntity(), 1.0f);
        this.setSkinFlags((byte)-1);
        EmptyAdvancementDataPlayer.clear(this.getAdvancementData());
        NMSImpl.setAdvancement((Player)this.getBukkitEntity(), new EmptyAdvancementDataPlayer(minecraftServer.getDataFixer(), minecraftServer.getPlayerList(), minecraftServer.getAdvancementData(), CitizensAPI.getDataFolder().getParentFile(), this));
    }

    public boolean inBlock() {
        if (this.npc == null || this.P || this.isSleeping()) {
            return super.inBlock();
        }
        return Util.inBlock((Entity)this.getBukkitEntity());
    }

    public boolean isNavigating() {
        return this.npc.getNavigator().isNavigating();
    }

    public boolean isCollidable() {
        return this.npc == null ? super.isCollidable() : (this.npc.data().has("collidable") ? (Boolean)this.npc.data().get("collidable") : !this.npc.isProtected());
    }

    private void moveOnCurrentHeading() {
        if (this.bn) {
            if (this.z && this.jumpTicks == 0) {
                this.jump();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.bo *= 0.98f;
        this.bq *= 0.98f;
        this.moveWithFallDamage(new Vec3D((double)this.bo, (double)this.bp, (double)this.bq));
        NMS.setHeadYaw((Entity)this.getBukkitEntity(), this.getYRot());
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(Vec3D vec) {
        double y = this.locY();
        this.g(vec);
        if (!this.npc.isProtected()) {
            this.a(this.locY() - y, this.z);
        }
    }

    public boolean isClimbing() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.isClimbing();
        }
        return false;
    }

    public void i(double x, double y, double z) {
        Vector vector = Util.callPushEvent(this.npc, x, y, z);
        if (vector != null) {
            super.i(vector.getX(), vector.getY(), vector.getZ());
        }
    }

    public void collide(net.minecraft.world.entity.Entity entity) {
        super.collide(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    public void a(Entity.RemovalReason reason) {
        super.a(reason);
        this.getAdvancementData().b();
    }

    public void setMoveDestination(double x, double y, double z, double speed) {
        this.controllerMove.a(x, y, z, speed);
    }

    public void setPathfindingMalus(PathType pathtype, float f) {
        this.malus.put(pathtype, Float.valueOf(f));
    }

    public void setShouldJump() {
        this.controllerJump.jump();
    }

    @Override
    public void setSkinFlags(byte flags) {
        this.getDataWatcher().set(EntityHuman.bP, (Object)flags);
    }

    @Override
    public void setSkinName(String name) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name);
    }

    @Override
    public void setSkinName(String name, boolean forceUpdate) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name, forceUpdate);
    }

    @Override
    public void setSkinPersistent(String skinName, String signature, String data) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinPersistent(skinName, signature, data);
    }

    public void setTracked(PlayerlistTracker tracker) {
        this.playerlistTracker = tracker;
    }

    public void tick() {
        super.tick();
        if (this.npc == null) {
            return;
        }
        this.P = this.isSpectator();
        if (this.updateCounter + 1 > Settings.Setting.PACKET_UPDATE_DELAY.asInt()) {
            this.bV = true;
        }
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        this.updatePackets(this.npc.getNavigator().isNavigating());
        this.npc.update();
    }

    public void g(Vec3D vec3d) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.g(vec3d);
        } else {
            NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
        }
    }

    public void updateAI() {
        this.controllerMove.a();
        this.controllerJump.b();
    }

    private void updatePackets(boolean navigating) {
        if (this.updateCounter++ <= this.npc.data().get(NPC.Metadata.PACKET_UPDATE_DELAY, Integer.valueOf(Settings.Setting.PACKET_UPDATE_DELAY.asInt()))) {
            return;
        }
        this.updateCounter = 0;
        boolean itemChanged = false;
        for (EnumItemSlot slot : EnumItemSlot.values()) {
            ItemStack equipment = this.getEquipment(slot);
            ItemStack cache = this.equipmentCache.get(slot);
            if (!(cache == null && equipment == null || !(cache == null ^ equipment == null) && ItemStack.c((ItemStack)cache, (ItemStack)equipment))) {
                itemChanged = true;
            }
            this.equipmentCache.put(slot, equipment);
        }
        if (!itemChanged) {
            return;
        }
        Location current = this.getBukkitEntity().getLocation(this.packetLocationCache);
        ArrayList vals = Lists.newArrayList();
        for (EnumItemSlot slot : EnumItemSlot.values()) {
            vals.add(new Pair((Object)slot, (Object)this.getEquipment(slot)));
        }
        Packet[] packets = new Packet[]{new PacketPlayOutEntityEquipment(this.getId(), (List)vals)};
        NMSImpl.sendPacketsNearby((Player)this.getBukkitEntity(), current, packets);
    }

    public void updatePathfindingRange(float pathfindingRange) {
        this.navigation.setRange(pathfindingRange);
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CraftServer cserver;
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
            this.cserver = (CraftServer)Bukkit.getServer();
            this.npc.getOrAddTrait(Inventory.class);
        }

        @Override
        public Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        @Override
        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        @Override
        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            this.cserver.getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            this.cserver.getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }

        @Override
        public void setSkinFlags(byte flags) {
            ((SkinnableEntity)this.entity).setSkinFlags(flags);
        }

        @Override
        public void setSkinName(String name) {
            ((SkinnableEntity)this.entity).setSkinName(name);
        }

        @Override
        public void setSkinName(String skinName, boolean forceUpdate) {
            ((SkinnableEntity)this.entity).setSkinName(skinName, forceUpdate);
        }

        @Override
        public void setSkinPersistent(String skinName, String signature, String data) {
            ((SkinnableEntity)this.entity).setSkinPersistent(skinName, signature, data);
        }
    }
}

