/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.util;

import java.lang.invoke.MethodHandle;
import java.util.Objects;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.nms.v1_16_R3.entity.EntityHumanNPC;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EntityTrackerEntry;
import net.minecraft.server.v1_16_R3.PacketPlayOutAnimation;
import net.minecraft.server.v1_16_R3.PlayerChunkMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerlistTracker
extends PlayerChunkMap.EntityTracker {
    private EntityPlayer lastUpdatedPlayer;
    private final Entity tracker;
    private static final MethodHandle D = NMS.getGetter(EntityTrackerEntry.class, "d");
    private static final MethodHandle E = NMS.getGetter(EntityTrackerEntry.class, "e");
    private static final MethodHandle TRACKER = NMS.getGetter(PlayerChunkMap.EntityTracker.class, "tracker");
    private static final MethodHandle TRACKER_ENTRY = NMS.getGetter(PlayerChunkMap.EntityTracker.class, "trackerEntry");
    private static final MethodHandle TRACKING_DISTANCE = NMS.getGetter(PlayerChunkMap.EntityTracker.class, "trackingDistance");

    public PlayerlistTracker(PlayerChunkMap map, Entity entity, int i, int j, boolean flag) {
        PlayerChunkMap playerChunkMap = map;
        Objects.requireNonNull(playerChunkMap);
        super(playerChunkMap, entity, i, j, flag);
        this.tracker = entity;
    }

    public PlayerlistTracker(PlayerChunkMap map, PlayerChunkMap.EntityTracker entry) {
        this(map, PlayerlistTracker.getTracker(entry), PlayerlistTracker.getTrackingDistance(entry), PlayerlistTracker.getD(entry), PlayerlistTracker.getE(entry));
    }

    public void updateLastPlayer() {
        if (this.tracker.dead) {
            return;
        }
        final EntityPlayer entityplayer = this.lastUpdatedPlayer;
        if (entityplayer == null) {
            return;
        }
        NMS.sendTabListAdd((Player)entityplayer.getBukkitEntity(), (Player)this.tracker.getBukkitEntity());
        if (!Settings.Setting.DISABLE_TABLIST.asBoolean()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                NMSImpl.sendPacket((Player)entityplayer.getBukkitEntity(), new PacketPlayOutAnimation(PlayerlistTracker.this.tracker, 0));
                NMS.sendTabListRemove((Player)entityplayer.getBukkitEntity(), (Player)PlayerlistTracker.this.tracker.getBukkitEntity());
            }
        }, (long)Settings.Setting.TABLIST_REMOVE_PACKET_DELAY.asInt());
    }

    public void updatePlayer(EntityPlayer entityplayer) {
        if (entityplayer instanceof EntityHumanNPC) {
            return;
        }
        this.lastUpdatedPlayer = entityplayer;
        super.updatePlayer(entityplayer);
    }

    private static int getD(PlayerChunkMap.EntityTracker entry) {
        try {
            return D.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    private static boolean getE(PlayerChunkMap.EntityTracker entry) {
        try {
            return E.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private static Entity getTracker(PlayerChunkMap.EntityTracker entry) {
        try {
            return TRACKER.invoke(entry);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private static int getTrackingDistance(PlayerChunkMap.EntityTracker entry) {
        try {
            return TRACKING_DISTANCE.invoke(entry);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return 0;
        }
    }
}

