/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_16_R3.EntityAreaEffectCloud;
import net.minecraft.server.v1_16_R3.EntityArmorStand;
import net.minecraft.server.v1_16_R3.EntityBat;
import net.minecraft.server.v1_16_R3.EntityBee;
import net.minecraft.server.v1_16_R3.EntityBlaze;
import net.minecraft.server.v1_16_R3.EntityBoat;
import net.minecraft.server.v1_16_R3.EntityCat;
import net.minecraft.server.v1_16_R3.EntityCaveSpider;
import net.minecraft.server.v1_16_R3.EntityChicken;
import net.minecraft.server.v1_16_R3.EntityCod;
import net.minecraft.server.v1_16_R3.EntityCow;
import net.minecraft.server.v1_16_R3.EntityCreeper;
import net.minecraft.server.v1_16_R3.EntityDolphin;
import net.minecraft.server.v1_16_R3.EntityDragonFireball;
import net.minecraft.server.v1_16_R3.EntityDrowned;
import net.minecraft.server.v1_16_R3.EntityEgg;
import net.minecraft.server.v1_16_R3.EntityEnderCrystal;
import net.minecraft.server.v1_16_R3.EntityEnderDragon;
import net.minecraft.server.v1_16_R3.EntityEnderPearl;
import net.minecraft.server.v1_16_R3.EntityEnderSignal;
import net.minecraft.server.v1_16_R3.EntityEnderman;
import net.minecraft.server.v1_16_R3.EntityEndermite;
import net.minecraft.server.v1_16_R3.EntityEvoker;
import net.minecraft.server.v1_16_R3.EntityEvokerFangs;
import net.minecraft.server.v1_16_R3.EntityExperienceOrb;
import net.minecraft.server.v1_16_R3.EntityFallingBlock;
import net.minecraft.server.v1_16_R3.EntityFireworks;
import net.minecraft.server.v1_16_R3.EntityFox;
import net.minecraft.server.v1_16_R3.EntityGhast;
import net.minecraft.server.v1_16_R3.EntityGiantZombie;
import net.minecraft.server.v1_16_R3.EntityGuardian;
import net.minecraft.server.v1_16_R3.EntityGuardianElder;
import net.minecraft.server.v1_16_R3.EntityHoglin;
import net.minecraft.server.v1_16_R3.EntityHorse;
import net.minecraft.server.v1_16_R3.EntityHorseDonkey;
import net.minecraft.server.v1_16_R3.EntityHorseMule;
import net.minecraft.server.v1_16_R3.EntityHorseSkeleton;
import net.minecraft.server.v1_16_R3.EntityHorseZombie;
import net.minecraft.server.v1_16_R3.EntityIllagerIllusioner;
import net.minecraft.server.v1_16_R3.EntityIronGolem;
import net.minecraft.server.v1_16_R3.EntityItem;
import net.minecraft.server.v1_16_R3.EntityItemFrame;
import net.minecraft.server.v1_16_R3.EntityLargeFireball;
import net.minecraft.server.v1_16_R3.EntityLeash;
import net.minecraft.server.v1_16_R3.EntityLightning;
import net.minecraft.server.v1_16_R3.EntityLlama;
import net.minecraft.server.v1_16_R3.EntityLlamaSpit;
import net.minecraft.server.v1_16_R3.EntityLlamaTrader;
import net.minecraft.server.v1_16_R3.EntityMagmaCube;
import net.minecraft.server.v1_16_R3.EntityMinecartChest;
import net.minecraft.server.v1_16_R3.EntityMinecartCommandBlock;
import net.minecraft.server.v1_16_R3.EntityMinecartFurnace;
import net.minecraft.server.v1_16_R3.EntityMinecartHopper;
import net.minecraft.server.v1_16_R3.EntityMinecartMobSpawner;
import net.minecraft.server.v1_16_R3.EntityMinecartRideable;
import net.minecraft.server.v1_16_R3.EntityMinecartTNT;
import net.minecraft.server.v1_16_R3.EntityMushroomCow;
import net.minecraft.server.v1_16_R3.EntityOcelot;
import net.minecraft.server.v1_16_R3.EntityPainting;
import net.minecraft.server.v1_16_R3.EntityPanda;
import net.minecraft.server.v1_16_R3.EntityParrot;
import net.minecraft.server.v1_16_R3.EntityPhantom;
import net.minecraft.server.v1_16_R3.EntityPig;
import net.minecraft.server.v1_16_R3.EntityPigZombie;
import net.minecraft.server.v1_16_R3.EntityPiglin;
import net.minecraft.server.v1_16_R3.EntityPiglinBrute;
import net.minecraft.server.v1_16_R3.EntityPillager;
import net.minecraft.server.v1_16_R3.EntityPolarBear;
import net.minecraft.server.v1_16_R3.EntityPotion;
import net.minecraft.server.v1_16_R3.EntityPufferFish;
import net.minecraft.server.v1_16_R3.EntityRabbit;
import net.minecraft.server.v1_16_R3.EntityRavager;
import net.minecraft.server.v1_16_R3.EntitySalmon;
import net.minecraft.server.v1_16_R3.EntitySheep;
import net.minecraft.server.v1_16_R3.EntityShulker;
import net.minecraft.server.v1_16_R3.EntityShulkerBullet;
import net.minecraft.server.v1_16_R3.EntitySilverfish;
import net.minecraft.server.v1_16_R3.EntitySkeleton;
import net.minecraft.server.v1_16_R3.EntitySkeletonStray;
import net.minecraft.server.v1_16_R3.EntitySkeletonWither;
import net.minecraft.server.v1_16_R3.EntitySlime;
import net.minecraft.server.v1_16_R3.EntitySmallFireball;
import net.minecraft.server.v1_16_R3.EntitySnowball;
import net.minecraft.server.v1_16_R3.EntitySnowman;
import net.minecraft.server.v1_16_R3.EntitySpectralArrow;
import net.minecraft.server.v1_16_R3.EntitySpider;
import net.minecraft.server.v1_16_R3.EntitySquid;
import net.minecraft.server.v1_16_R3.EntityStrider;
import net.minecraft.server.v1_16_R3.EntityTNTPrimed;
import net.minecraft.server.v1_16_R3.EntityThrownExpBottle;
import net.minecraft.server.v1_16_R3.EntityThrownTrident;
import net.minecraft.server.v1_16_R3.EntityTippedArrow;
import net.minecraft.server.v1_16_R3.EntityTropicalFish;
import net.minecraft.server.v1_16_R3.EntityTurtle;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EntityVex;
import net.minecraft.server.v1_16_R3.EntityVillager;
import net.minecraft.server.v1_16_R3.EntityVillagerTrader;
import net.minecraft.server.v1_16_R3.EntityVindicator;
import net.minecraft.server.v1_16_R3.EntityWitch;
import net.minecraft.server.v1_16_R3.EntityWither;
import net.minecraft.server.v1_16_R3.EntityWitherSkull;
import net.minecraft.server.v1_16_R3.EntityWolf;
import net.minecraft.server.v1_16_R3.EntityZoglin;
import net.minecraft.server.v1_16_R3.EntityZombie;
import net.minecraft.server.v1_16_R3.EntityZombieHusk;
import net.minecraft.server.v1_16_R3.EntityZombieVillager;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.RegistryBlocks;
import net.minecraft.server.v1_16_R3.RegistryMaterials;

public class CustomEntityRegistry
extends RegistryBlocks {
    private final BiMap<MinecraftKey, EntityTypes> entities = HashBiMap.create();
    private final BiMap<EntityTypes, MinecraftKey> entityClasses = this.entities.inverse();
    private final Map<EntityTypes, Integer> entityIds = Maps.newHashMap();
    private final RegistryMaterials<EntityTypes<?>> wrapped;
    private static final MethodHandle IREGISTRY_LIFECYCLE = NMS.getGetter(IRegistry.class, "bf");
    private static final MethodHandle IREGISTRY_RESOURCE_KEY = NMS.getGetter(IRegistry.class, "b");
    private static final BiMap<EntityTypes, Class<?>> minecraftClassMap = HashBiMap.create();

    public CustomEntityRegistry(RegistryBlocks<EntityTypes<?>> original) throws Throwable {
        super(original.a().getNamespace(), IREGISTRY_RESOURCE_KEY.invoke(original), IREGISTRY_LIFECYCLE.invoke(original));
        this.wrapped = original;
    }

    public int a(Object key) {
        if (this.entityIds.containsKey(key)) {
            return this.entityIds.get(key);
        }
        return this.wrapped.a((Object)((EntityTypes)key));
    }

    public Object a(Random paramRandom) {
        return this.wrapped.a(paramRandom);
    }

    public EntityTypes findType(Class<?> search) {
        return (EntityTypes)minecraftClassMap.inverse().get(search);
    }

    public Object fromId(int var0) {
        return this.wrapped.fromId(var0);
    }

    public EntityTypes get(MinecraftKey key) {
        if (this.entities.containsKey((Object)key)) {
            return (EntityTypes)this.entities.get((Object)key);
        }
        return (EntityTypes)this.wrapped.get(key);
    }

    public MinecraftKey getKey(Object value) {
        if (this.entityClasses.containsKey(value)) {
            return (MinecraftKey)this.entityClasses.get(value);
        }
        return this.wrapped.getKey((Object)((EntityTypes)value));
    }

    public Optional getOptional(MinecraftKey var0) {
        if (this.entities.containsKey((Object)var0)) {
            return Optional.of((EntityTypes)this.entities.get((Object)var0));
        }
        return this.wrapped.getOptional(var0);
    }

    public RegistryMaterials<EntityTypes<?>> getWrapped() {
        return this.wrapped;
    }

    public Iterator<Object> iterator() {
        return this.wrapped.iterator();
    }

    public Set<Object> keySet() {
        return this.wrapped.keySet();
    }

    public void put(int entityId, MinecraftKey key, EntityTypes entityClass) {
        this.entities.put((Object)key, (Object)entityClass);
        this.entityIds.put(entityClass, entityId);
    }

    static {
        minecraftClassMap.put((Object)EntityTypes.AREA_EFFECT_CLOUD, EntityAreaEffectCloud.class);
        minecraftClassMap.put((Object)EntityTypes.ARMOR_STAND, EntityArmorStand.class);
        minecraftClassMap.put((Object)EntityTypes.ARROW, EntityTippedArrow.class);
        minecraftClassMap.put((Object)EntityTypes.BAT, EntityBat.class);
        minecraftClassMap.put((Object)EntityTypes.BEE, EntityBee.class);
        minecraftClassMap.put((Object)EntityTypes.BLAZE, EntityBlaze.class);
        minecraftClassMap.put((Object)EntityTypes.BOAT, EntityBoat.class);
        minecraftClassMap.put((Object)EntityTypes.CAT, EntityCat.class);
        minecraftClassMap.put((Object)EntityTypes.CAVE_SPIDER, EntityCaveSpider.class);
        minecraftClassMap.put((Object)EntityTypes.CHICKEN, EntityChicken.class);
        minecraftClassMap.put((Object)EntityTypes.COD, EntityCod.class);
        minecraftClassMap.put((Object)EntityTypes.COW, EntityCow.class);
        minecraftClassMap.put((Object)EntityTypes.CREEPER, EntityCreeper.class);
        minecraftClassMap.put((Object)EntityTypes.DOLPHIN, EntityDolphin.class);
        minecraftClassMap.put((Object)EntityTypes.DONKEY, EntityHorseDonkey.class);
        minecraftClassMap.put((Object)EntityTypes.DRAGON_FIREBALL, EntityDragonFireball.class);
        minecraftClassMap.put((Object)EntityTypes.DROWNED, EntityDrowned.class);
        minecraftClassMap.put((Object)EntityTypes.ELDER_GUARDIAN, EntityGuardianElder.class);
        minecraftClassMap.put((Object)EntityTypes.END_CRYSTAL, EntityEnderCrystal.class);
        minecraftClassMap.put((Object)EntityTypes.ENDER_DRAGON, EntityEnderDragon.class);
        minecraftClassMap.put((Object)EntityTypes.ENDERMAN, EntityEnderman.class);
        minecraftClassMap.put((Object)EntityTypes.ENDERMITE, EntityEndermite.class);
        minecraftClassMap.put((Object)EntityTypes.EVOKER, EntityEvoker.class);
        minecraftClassMap.put((Object)EntityTypes.EVOKER_FANGS, EntityEvokerFangs.class);
        minecraftClassMap.put((Object)EntityTypes.EXPERIENCE_ORB, EntityExperienceOrb.class);
        minecraftClassMap.put((Object)EntityTypes.EYE_OF_ENDER, EntityEnderSignal.class);
        minecraftClassMap.put((Object)EntityTypes.FALLING_BLOCK, EntityFallingBlock.class);
        minecraftClassMap.put((Object)EntityTypes.FIREWORK_ROCKET, EntityFireworks.class);
        minecraftClassMap.put((Object)EntityTypes.FOX, EntityFox.class);
        minecraftClassMap.put((Object)EntityTypes.GHAST, EntityGhast.class);
        minecraftClassMap.put((Object)EntityTypes.GIANT, EntityGiantZombie.class);
        minecraftClassMap.put((Object)EntityTypes.GUARDIAN, EntityGuardian.class);
        minecraftClassMap.put((Object)EntityTypes.HOGLIN, EntityHoglin.class);
        minecraftClassMap.put((Object)EntityTypes.HORSE, EntityHorse.class);
        minecraftClassMap.put((Object)EntityTypes.HUSK, EntityZombieHusk.class);
        minecraftClassMap.put((Object)EntityTypes.ILLUSIONER, EntityIllagerIllusioner.class);
        minecraftClassMap.put((Object)EntityTypes.IRON_GOLEM, EntityIronGolem.class);
        minecraftClassMap.put((Object)EntityTypes.ITEM, EntityItem.class);
        minecraftClassMap.put((Object)EntityTypes.ITEM_FRAME, EntityItemFrame.class);
        minecraftClassMap.put((Object)EntityTypes.FIREBALL, EntityLargeFireball.class);
        minecraftClassMap.put((Object)EntityTypes.LEASH_KNOT, EntityLeash.class);
        minecraftClassMap.put((Object)EntityTypes.LIGHTNING_BOLT, EntityLightning.class);
        minecraftClassMap.put((Object)EntityTypes.LLAMA, EntityLlama.class);
        minecraftClassMap.put((Object)EntityTypes.LLAMA_SPIT, EntityLlamaSpit.class);
        minecraftClassMap.put((Object)EntityTypes.MAGMA_CUBE, EntityMagmaCube.class);
        minecraftClassMap.put((Object)EntityTypes.MINECART, EntityMinecartRideable.class);
        minecraftClassMap.put((Object)EntityTypes.CHEST_MINECART, EntityMinecartChest.class);
        minecraftClassMap.put((Object)EntityTypes.COMMAND_BLOCK_MINECART, EntityMinecartCommandBlock.class);
        minecraftClassMap.put((Object)EntityTypes.FURNACE_MINECART, EntityMinecartFurnace.class);
        minecraftClassMap.put((Object)EntityTypes.HOPPER_MINECART, EntityMinecartHopper.class);
        minecraftClassMap.put((Object)EntityTypes.SPAWNER_MINECART, EntityMinecartMobSpawner.class);
        minecraftClassMap.put((Object)EntityTypes.TNT_MINECART, EntityMinecartTNT.class);
        minecraftClassMap.put((Object)EntityTypes.MULE, EntityHorseMule.class);
        minecraftClassMap.put((Object)EntityTypes.MOOSHROOM, EntityMushroomCow.class);
        minecraftClassMap.put((Object)EntityTypes.OCELOT, EntityOcelot.class);
        minecraftClassMap.put((Object)EntityTypes.PAINTING, EntityPainting.class);
        minecraftClassMap.put((Object)EntityTypes.PANDA, EntityPanda.class);
        minecraftClassMap.put((Object)EntityTypes.PARROT, EntityParrot.class);
        minecraftClassMap.put((Object)EntityTypes.PHANTOM, EntityPhantom.class);
        minecraftClassMap.put((Object)EntityTypes.PIG, EntityPig.class);
        minecraftClassMap.put((Object)EntityTypes.PIGLIN, EntityPiglin.class);
        minecraftClassMap.put((Object)EntityTypes.PIGLIN_BRUTE, EntityPiglinBrute.class);
        minecraftClassMap.put((Object)EntityTypes.PILLAGER, EntityPillager.class);
        minecraftClassMap.put((Object)EntityTypes.POLAR_BEAR, EntityPolarBear.class);
        minecraftClassMap.put((Object)EntityTypes.TNT, EntityTNTPrimed.class);
        minecraftClassMap.put((Object)EntityTypes.PUFFERFISH, EntityPufferFish.class);
        minecraftClassMap.put((Object)EntityTypes.RABBIT, EntityRabbit.class);
        minecraftClassMap.put((Object)EntityTypes.RAVAGER, EntityRavager.class);
        minecraftClassMap.put((Object)EntityTypes.SALMON, EntitySalmon.class);
        minecraftClassMap.put((Object)EntityTypes.SHEEP, EntitySheep.class);
        minecraftClassMap.put((Object)EntityTypes.SHULKER, EntityShulker.class);
        minecraftClassMap.put((Object)EntityTypes.SHULKER_BULLET, EntityShulkerBullet.class);
        minecraftClassMap.put((Object)EntityTypes.SILVERFISH, EntitySilverfish.class);
        minecraftClassMap.put((Object)EntityTypes.SKELETON, EntitySkeleton.class);
        minecraftClassMap.put((Object)EntityTypes.SKELETON_HORSE, EntityHorseSkeleton.class);
        minecraftClassMap.put((Object)EntityTypes.SLIME, EntitySlime.class);
        minecraftClassMap.put((Object)EntityTypes.SMALL_FIREBALL, EntitySmallFireball.class);
        minecraftClassMap.put((Object)EntityTypes.SNOW_GOLEM, EntitySnowman.class);
        minecraftClassMap.put((Object)EntityTypes.SNOWBALL, EntitySnowball.class);
        minecraftClassMap.put((Object)EntityTypes.SPECTRAL_ARROW, EntitySpectralArrow.class);
        minecraftClassMap.put((Object)EntityTypes.SPIDER, EntitySpider.class);
        minecraftClassMap.put((Object)EntityTypes.SQUID, EntitySquid.class);
        minecraftClassMap.put((Object)EntityTypes.STRAY, EntitySkeletonStray.class);
        minecraftClassMap.put((Object)EntityTypes.STRIDER, EntityStrider.class);
        minecraftClassMap.put((Object)EntityTypes.EGG, EntityEgg.class);
        minecraftClassMap.put((Object)EntityTypes.ENDER_PEARL, EntityEnderPearl.class);
        minecraftClassMap.put((Object)EntityTypes.EXPERIENCE_BOTTLE, EntityThrownExpBottle.class);
        minecraftClassMap.put((Object)EntityTypes.POTION, EntityPotion.class);
        minecraftClassMap.put((Object)EntityTypes.TRIDENT, EntityThrownTrident.class);
        minecraftClassMap.put((Object)EntityTypes.TRADER_LLAMA, EntityLlamaTrader.class);
        minecraftClassMap.put((Object)EntityTypes.TROPICAL_FISH, EntityTropicalFish.class);
        minecraftClassMap.put((Object)EntityTypes.TURTLE, EntityTurtle.class);
        minecraftClassMap.put((Object)EntityTypes.VEX, EntityVex.class);
        minecraftClassMap.put((Object)EntityTypes.VILLAGER, EntityVillager.class);
        minecraftClassMap.put((Object)EntityTypes.VINDICATOR, EntityVindicator.class);
        minecraftClassMap.put((Object)EntityTypes.WANDERING_TRADER, EntityVillagerTrader.class);
        minecraftClassMap.put((Object)EntityTypes.WITCH, EntityWitch.class);
        minecraftClassMap.put((Object)EntityTypes.WITHER, EntityWither.class);
        minecraftClassMap.put((Object)EntityTypes.WITHER_SKELETON, EntitySkeletonWither.class);
        minecraftClassMap.put((Object)EntityTypes.WITHER_SKULL, EntityWitherSkull.class);
        minecraftClassMap.put((Object)EntityTypes.WOLF, EntityWolf.class);
        minecraftClassMap.put((Object)EntityTypes.ZOGLIN, EntityZoglin.class);
        minecraftClassMap.put((Object)EntityTypes.ZOMBIE, EntityZombie.class);
        minecraftClassMap.put((Object)EntityTypes.ZOMBIE_HORSE, EntityHorseZombie.class);
        minecraftClassMap.put((Object)EntityTypes.ZOMBIE_VILLAGER, EntityZombieVillager.class);
        minecraftClassMap.put((Object)EntityTypes.ZOMBIFIED_PIGLIN, EntityPigZombie.class);
    }
}

