/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_16_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.EntityBoat;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumMoveType;
import net.minecraft.server.v1_16_R3.Fluid;
import net.minecraft.server.v1_16_R3.FluidType;
import net.minecraft.server.v1_16_R3.IBlockAccess;
import net.minecraft.server.v1_16_R3.MathHelper;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.TagsFluid;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class BoatController
extends MobEntityController {
    public BoatController() {
        super(EntityBoatNPC.class);
    }

    public Boat getBukkitEntity() {
        return (Boat)super.getBukkitEntity();
    }

    public static class EntityBoatNPC
    extends EntityBoat
    implements NPCHolder {
        private double aC;
        private float aD;
        private EntityBoat.EnumStatus aE;
        private EntityBoat.EnumStatus aF;
        private double ap;
        private double ar;
        private final CitizensNPC npc;

        public EntityBoatNPC(EntityTypes<? extends EntityBoat> types, World world) {
            this(types, world, null);
        }

        public EntityBoatNPC(EntityTypes<? extends EntityBoat> types, World world, NPC npc) {
            super(types, world);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(Tag<FluidType> tag, double d0) {
            Vec3D old = this.getMot().add(0.0, 0.0, 0.0);
            boolean res = super.a(tag, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(old);
            }
            return res;
        }

        public void collide(net.minecraft.server.v1_16_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_16_R3.Entity)this, (CraftEntity)new BoatNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        private EntityBoat.EnumStatus getStatus() {
            EntityBoat.EnumStatus entityboat_enumstatus = this.u();
            if (entityboat_enumstatus != null) {
                this.aC = this.getBoundingBox().maxY;
                return entityboat_enumstatus;
            }
            if (this.t()) {
                return EntityBoat.EnumStatus.IN_WATER;
            }
            float f = this.k();
            if (f > 0.0f) {
                this.aD = f;
                return EntityBoat.EnumStatus.ON_LAND;
            }
            return EntityBoat.EnumStatus.IN_AIR;
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        private boolean t() {
            boolean m = false;
            AxisAlignedBB axisalignedbb = this.getBoundingBox();
            int i = MathHelper.floor((double)axisalignedbb.minX);
            int j = MathHelper.f((double)axisalignedbb.maxX);
            int k = MathHelper.floor((double)axisalignedbb.minY);
            int l = MathHelper.f((double)(axisalignedbb.minY + 0.001));
            int i1 = MathHelper.floor((double)axisalignedbb.minZ);
            int j1 = MathHelper.f((double)axisalignedbb.maxZ);
            boolean flag = false;
            this.aC = Double.MIN_VALUE;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.d(k1, l1, i2);
                        Fluid fluid = this.world.getFluid((BlockPosition)blockposition_mutableblockposition);
                        if (!fluid.a((Tag)TagsFluid.WATER)) continue;
                        float f = (float)l1 + fluid.getHeight((IBlockAccess)this.world, (BlockPosition)blockposition_mutableblockposition);
                        this.aC = Math.max((double)f, this.aC);
                        m = flag | axisalignedbb.minY < (double)f;
                    }
                }
            }
            return m;
        }

        public void tick() {
            if (this.npc != null) {
                this.npc.update();
                this.aF = this.aE;
                this.aE = this.getStatus();
                double d1 = this.isNoGravity() ? 0.0 : -0.04;
                double d2 = 0.0;
                this.ap = 0.05f;
                if (this.aF == EntityBoat.EnumStatus.IN_AIR && this.aE != EntityBoat.EnumStatus.IN_AIR && this.aE != EntityBoat.EnumStatus.ON_LAND) {
                    this.aC = this.e(1.0);
                    this.setPosition(this.locX(), (double)(this.i() - this.getHeight()) + 0.101, this.locZ());
                    this.setMot(this.getMot().d(1.0, 0.0, 1.0));
                    this.aE = EntityBoat.EnumStatus.IN_WATER;
                } else {
                    if (this.aE == EntityBoat.EnumStatus.IN_WATER) {
                        d2 = (this.aC - this.locY()) / (double)this.getHeight();
                        this.ap = 0.9f;
                    } else if (this.aE == EntityBoat.EnumStatus.UNDER_FLOWING_WATER) {
                        d1 = -7.0E-4;
                        this.ap = 0.9f;
                    } else if (this.aE == EntityBoat.EnumStatus.UNDER_WATER) {
                        d2 = 0.01;
                        this.ap = 0.45f;
                    } else if (this.aE == EntityBoat.EnumStatus.IN_AIR) {
                        this.ap = 0.9f;
                    } else if (this.aE == EntityBoat.EnumStatus.ON_LAND) {
                        this.ap = this.aD;
                        if (this.getRidingPassenger() instanceof EntityHuman) {
                            this.aD /= 2.0f;
                        }
                    }
                    Vec3D vec3d = this.getMot();
                    this.setMot(vec3d.x * this.ap, vec3d.y + d1, vec3d.z * this.ap);
                    this.ar *= this.ap;
                    if (d2 > 0.0) {
                        Vec3D vec3d1 = this.getMot();
                        this.setMot(vec3d1.x, vec3d1.y + d2 * 0.0615, vec3d1.z);
                    }
                }
                this.move(EnumMoveType.SELF, this.getMot());
                if (this.isVehicle()) {
                    this.yaw = (float)((double)this.yaw + this.ar);
                }
            } else {
                super.tick();
            }
        }

        private EntityBoat.EnumStatus u() {
            AxisAlignedBB axisalignedbb = this.getBoundingBox();
            double d0 = axisalignedbb.maxY + 0.001;
            int i = MathHelper.floor((double)axisalignedbb.minX);
            int j = MathHelper.f((double)axisalignedbb.maxX);
            int k = MathHelper.floor((double)axisalignedbb.maxY);
            int l = MathHelper.f((double)d0);
            int i1 = MathHelper.floor((double)axisalignedbb.minZ);
            int j1 = MathHelper.f((double)axisalignedbb.maxZ);
            boolean flag = false;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.d(k1, l1, i2);
                        Fluid fluid = this.world.getFluid((BlockPosition)blockposition_mutableblockposition);
                        if (!fluid.a((Tag)TagsFluid.WATER) || !(d0 < (double)((float)blockposition_mutableblockposition.getY() + fluid.getHeight((IBlockAccess)this.world, (BlockPosition)blockposition_mutableblockposition)))) continue;
                        if (!fluid.isSource()) {
                            return EntityBoat.EnumStatus.UNDER_FLOWING_WATER;
                        }
                        flag = true;
                    }
                }
            }
            return flag ? EntityBoat.EnumStatus.UNDER_WATER : null;
        }

        public void updateSize() {
            if (this.npc == null) {
                super.updateSize();
            } else {
                NMSImpl.setSize((net.minecraft.server.v1_16_R3.Entity)this, this.justCreated);
            }
        }
    }

    public static class BoatNPC
    extends CraftBoat
    implements ForwardingNPCHolder {
        public BoatNPC(EntityBoatNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityBoat)entity);
        }
    }
}

