/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_16_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.EntityArmorStand;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumHand;
import net.minecraft.server.v1_16_R3.EnumInteractionResult;
import net.minecraft.server.v1_16_R3.FluidType;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftArmorStand;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.util.Vector;

public class ArmorStandController
extends MobEntityController {
    public ArmorStandController() {
        super(EntityArmorStandNPC.class);
    }

    public ArmorStand getBukkitEntity() {
        return (ArmorStand)super.getBukkitEntity();
    }

    public static class EntityArmorStandNPC
    extends EntityArmorStand
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityArmorStandNPC(EntityTypes<? extends EntityArmorStand> types, World world) {
            this(types, world, null);
        }

        public EntityArmorStandNPC(EntityTypes<? extends EntityArmorStand> types, World world, NPC npc) {
            super(types, world);
            this.npc = (CitizensNPC)npc;
        }

        public EnumInteractionResult a(EntityHuman entityhuman, Vec3D vec3d, EnumHand enumhand) {
            if (this.npc == null) {
                return super.a(entityhuman, vec3d, enumhand);
            }
            PlayerInteractEntityEvent event = new PlayerInteractEntityEvent((Player)entityhuman.getBukkitEntity(), (Entity)this.getBukkitEntity());
            Bukkit.getPluginManager().callEvent((Event)event);
            return event.isCancelled() ? EnumInteractionResult.FAIL : EnumInteractionResult.SUCCESS;
        }

        public boolean a(Tag<FluidType> tag, double d0) {
            Vec3D old = this.getMot().add(0.0, 0.0, 0.0);
            boolean res = super.a(tag, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(old);
            }
            return res;
        }

        public void collide(net.minecraft.server.v1_16_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_16_R3.Entity)this, (CraftEntity)new ArmorStandNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void tick() {
            super.tick();
            if (this.npc != null) {
                this.npc.update();
            }
        }
    }

    public static class ArmorStandNPC
    extends CraftArmorStand
    implements ForwardingNPCHolder {
        public ArmorStandNPC(EntityArmorStandNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityArmorStand)entity);
        }
    }
}

