/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_16_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.nms.v1_16_R3.util.PlayerControllerMove;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.PufferFishTrait;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.ControllerMove;
import net.minecraft.server.v1_16_R3.DamageSource;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityBoat;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityMinecartAbstract;
import net.minecraft.server.v1_16_R3.EntityPose;
import net.minecraft.server.v1_16_R3.EntityPufferFish;
import net.minecraft.server.v1_16_R3.EntitySize;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumHand;
import net.minecraft.server.v1_16_R3.EnumInteractionResult;
import net.minecraft.server.v1_16_R3.FluidType;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.Items;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPufferFish;
import org.bukkit.entity.PufferFish;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class PufferFishController
extends MobEntityController {
    public PufferFishController() {
        super(EntityPufferFishNPC.class);
    }

    public PufferFish getBukkitEntity() {
        return (PufferFish)super.getBukkitEntity();
    }

    public static class EntityPufferFishNPC
    extends EntityPufferFish
    implements NPCHolder {
        private final CitizensNPC npc;
        private ControllerMove oldMoveController;

        public EntityPufferFishNPC(EntityTypes<? extends EntityPufferFish> types, World world) {
            this(types, world, null);
        }

        public EntityPufferFishNPC(EntityTypes<? extends EntityPufferFish> types, World world, NPC npc) {
            super(types, world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.oldMoveController = this.moveController;
                this.moveController = new ControllerMove((EntityInsentient)this);
            }
        }

        protected void a(double d0, boolean flag, IBlockData block, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, block, blockposition);
            }
        }

        public EntitySize a(EntityPose entitypose) {
            if (this.npc == null) {
                return super.a(entitypose);
            }
            return super.a(entitypose).a(1.0f / EntityPufferFishNPC.s(this.getPuffState())).a(0.5f);
        }

        public void a(float strength, double dx, double dz) {
            NPCKnockbackEvent event = new NPCKnockbackEvent(this.npc, strength, dx, dz);
            Bukkit.getPluginManager().callEvent((Event)event);
            Vector kb = event.getKnockbackVector();
            super.a((float)event.getStrength(), kb.getX(), kb.getZ());
        }

        public boolean a(Tag<FluidType> tag, double d0) {
            Vec3D old = this.getMot().add(0.0, 0.0, 0.0);
            boolean res = super.a(tag, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(old);
            }
            return res;
        }

        public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
            if (this.npc == null || !this.npc.isProtected()) {
                return super.b(entityhuman, enumhand);
            }
            ItemStack itemstack = entityhuman.b(enumhand);
            if (itemstack.getItem() == Items.WATER_BUCKET && this.isAlive()) {
                return EnumInteractionResult.FAIL;
            }
            return super.b(entityhuman, enumhand);
        }

        public boolean b(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.b(f, f1);
            }
            return false;
        }

        public void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        public void collide(Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void enderTeleportTo(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.enderTeleportTo(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.enderTeleportTo(d0, d1, d2);
            }
        }

        public void g(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                if (!NMSImpl.moveFish(this.npc, (EntityInsentient)this, vec3d)) {
                    super.g(vec3d);
                }
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((Entity)this, (CraftEntity)new PufferFishNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        protected SoundEffect getSoundAmbient() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundAmbient(), "ambient-sound");
        }

        protected SoundEffect getSoundDeath() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundDeath(), "death-sound");
        }

        protected SoundEffect getSoundHurt(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundHurt(damagesource), "hurt-sound");
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public boolean isClimbing() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.isClimbing();
            }
            return false;
        }

        public boolean isLeashed() {
            if (this.npc == null) {
                return super.isLeashed();
            }
            boolean protectedDefault = this.npc.data().get("protected", Boolean.valueOf(true));
            if (!protectedDefault || !this.npc.data().get("protected-leash", Boolean.valueOf(protectedDefault)).booleanValue()) {
                return super.isLeashed();
            }
            if (super.isLeashed()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void mobTick() {
            super.mobTick();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI() && this.moveController != this.oldMoveController) {
                    this.moveController = this.oldMoveController;
                }
                if (!this.npc.useMinecraftAI() && this.moveController == this.oldMoveController) {
                    this.moveController = new PlayerControllerMove((EntityLiving)this);
                }
                this.npc.update();
            }
        }

        public void movementTick() {
            boolean lastInWater = this.v;
            int lastPuffState = this.getPuffState();
            if (this.npc != null) {
                this.v = false;
                this.setPuffState(0);
            }
            super.movementTick();
            if (this.npc != null) {
                this.v = lastInWater;
                this.setPuffState(lastPuffState);
            }
        }

        protected boolean n(Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return this.npc.data().get("protected", Boolean.valueOf(true)) == false;
            }
            return super.n(entity);
        }

        public void tick() {
            if (this.npc != null) {
                NMSImpl.resetPuffTicks(this);
            }
            super.tick();
            PufferFishTrait trait = null;
            if (this.npc != null && (trait = this.npc.getTraitNullable(PufferFishTrait.class)) != null) {
                this.setPuffState(trait.getPuffState());
            }
        }

        private static float s(int i) {
            switch (i) {
                case 0: {
                    return 0.5f;
                }
                case 1: {
                    return 0.7f;
                }
            }
            return 1.0f;
        }
    }

    public static class PufferFishNPC
    extends CraftPufferFish
    implements ForwardingNPCHolder {
        public PufferFishNPC(EntityPufferFishNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPufferFish)entity);
        }
    }
}

