/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_16_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.nms.v1_16_R3.util.PlayerControllerMove;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.ControllerLook;
import net.minecraft.server.v1_16_R3.ControllerMove;
import net.minecraft.server.v1_16_R3.DamageSource;
import net.minecraft.server.v1_16_R3.DataWatcherObject;
import net.minecraft.server.v1_16_R3.EntityBoat;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityMinecartAbstract;
import net.minecraft.server.v1_16_R3.EntityPhantom;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumDifficulty;
import net.minecraft.server.v1_16_R3.FluidType;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldDataServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPhantom;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Phantom;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class PhantomController
extends MobEntityController {
    public PhantomController() {
        super(EntityPhantomNPC.class);
    }

    public Phantom getBukkitEntity() {
        return (Phantom)super.getBukkitEntity();
    }

    public static class EntityPhantomNPC
    extends EntityPhantom
    implements NPCHolder {
        boolean calledNMSHeight = false;
        private final CitizensNPC npc;
        private ControllerLook oldLookController;
        private ControllerMove oldMoveController;

        public EntityPhantomNPC(EntityTypes<? extends EntityPhantom> types, World world) {
            this(types, world, null);
        }

        public EntityPhantomNPC(EntityTypes<? extends EntityPhantom> types, World world, NPC npc) {
            super(types, world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.setNoAI(true);
                this.oldMoveController = this.moveController;
                this.oldLookController = this.lookController;
                this.moveController = new ControllerMove((EntityInsentient)this);
                this.lookController = new ControllerLook((EntityInsentient)this);
            }
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc != null && !this.calledNMSHeight) {
                this.calledNMSHeight = true;
                NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject);
                this.calledNMSHeight = false;
            }
            super.a(datawatcherobject);
        }

        protected void a(double d0, boolean flag, IBlockData block, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, block, blockposition);
            }
        }

        public void a(float strength, double dx, double dz) {
            NPCKnockbackEvent event = new NPCKnockbackEvent(this.npc, strength, dx, dz);
            Bukkit.getPluginManager().callEvent((Event)event);
            Vector kb = event.getKnockbackVector();
            super.a((float)event.getStrength(), kb.getX(), kb.getZ());
        }

        public boolean a(Tag<FluidType> tag, double d0) {
            Vec3D old = this.getMot().add(0.0, 0.0, 0.0);
            boolean res = super.a(tag, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(old);
            }
            return res;
        }

        public boolean b(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.b(f, f1);
            }
            return false;
        }

        public void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        public void collide(net.minecraft.server.v1_16_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public boolean eG() {
            if (this.npc == null || !this.npc.isProtected()) {
                return super.eG();
            }
            return false;
        }

        public void enderTeleportTo(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.enderTeleportTo(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.enderTeleportTo(d0, d1, d2);
            }
        }

        public void g(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.g(vec3d);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_16_R3.Entity)this, (CraftEntity)new PhantomNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        protected SoundEffect getSoundAmbient() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundAmbient(), "ambient-sound");
        }

        protected SoundEffect getSoundDeath() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundDeath(), "death-sound");
        }

        protected SoundEffect getSoundHurt(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundHurt(damagesource), "hurt-sound");
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public boolean isClimbing() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.isClimbing();
            }
            return false;
        }

        public boolean isLeashed() {
            if (this.npc == null) {
                return super.isLeashed();
            }
            boolean protectedDefault = this.npc.data().get("protected", Boolean.valueOf(true));
            if (!protectedDefault || !this.npc.data().get("protected-leash", Boolean.valueOf(protectedDefault)).booleanValue()) {
                return super.isLeashed();
            }
            if (super.isLeashed()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void movementTick() {
            super.movementTick();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI() && this.moveController != this.oldMoveController) {
                    this.moveController = this.oldMoveController;
                    this.lookController = this.oldLookController;
                    this.setNoAI(false);
                }
                if (!this.npc.useMinecraftAI() && this.moveController == this.oldMoveController) {
                    this.moveController = new PlayerControllerMove((EntityLiving)this);
                    this.lookController = new ControllerLook((EntityInsentient)this);
                    this.setNoAI(true);
                }
                if (this.npc.isProtected()) {
                    this.setOnFire(0);
                }
                this.npc.update();
            }
        }

        protected boolean n(net.minecraft.server.v1_16_R3.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return this.npc.data().get("protected", Boolean.valueOf(true)) == false;
            }
            return super.n(entity);
        }

        public void tick() {
            boolean resetDifficulty;
            boolean bl = resetDifficulty = this.world.getDifficulty() == EnumDifficulty.PEACEFUL;
            if (this.npc != null && resetDifficulty) {
                ((WorldDataServer)this.world.getWorldData()).setDifficulty(EnumDifficulty.NORMAL);
            }
            super.tick();
            if (this.npc != null && resetDifficulty) {
                ((WorldDataServer)this.world.getWorldData()).setDifficulty(EnumDifficulty.PEACEFUL);
            }
        }
    }

    public static class PhantomNPC
    extends CraftPhantom
    implements ForwardingNPCHolder {
        public PhantomNPC(EntityPhantomNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPhantom)entity);
        }
    }
}

