/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_16_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.DamageSource;
import net.minecraft.server.v1_16_R3.DataWatcherObject;
import net.minecraft.server.v1_16_R3.EntityBoat;
import net.minecraft.server.v1_16_R3.EntityHorseMule;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityMinecartAbstract;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.FluidType;
import net.minecraft.server.v1_16_R3.GenericAttributes;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMule;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mule;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class HorseMuleController
extends MobEntityController {
    public HorseMuleController() {
        super(EntityHorseMuleNPC.class);
    }

    public Mule getBukkitEntity() {
        return (Mule)super.getBukkitEntity();
    }

    @Override
    public void spawn(Location at, NPC npc) {
        npc.getOrAddTrait(HorseModifiers.class);
        super.spawn(at, npc);
    }

    public static class EntityHorseMuleNPC
    extends EntityHorseMule
    implements NPCHolder {
        private double baseMovementSpeed;
        boolean calledNMSHeight = false;
        private final CitizensNPC npc;
        private boolean riding;

        public EntityHorseMuleNPC(EntityTypes<? extends EntityHorseMule> types, World world) {
            this(types, world, null);
        }

        public EntityHorseMuleNPC(EntityTypes<? extends EntityHorseMule> types, World world, NPC npc) {
            super(types, world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                ((Mule)this.getBukkitEntity()).setDomestication(((Mule)this.getBukkitEntity()).getMaxDomestication());
                this.baseMovementSpeed = this.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).getValue();
            }
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc != null && !this.calledNMSHeight) {
                this.calledNMSHeight = true;
                NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject);
                this.calledNMSHeight = false;
            }
            super.a(datawatcherobject);
        }

        protected void a(double d0, boolean flag, IBlockData block, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, block, blockposition);
            }
        }

        public void a(float strength, double dx, double dz) {
            NPCKnockbackEvent event = new NPCKnockbackEvent(this.npc, strength, dx, dz);
            Bukkit.getPluginManager().callEvent((Event)event);
            Vector kb = event.getKnockbackVector();
            super.a((float)event.getStrength(), kb.getX(), kb.getZ());
        }

        public boolean a(Tag<FluidType> tag, double d0) {
            Vec3D old = this.getMot().add(0.0, 0.0, 0.0);
            boolean res = super.a(tag, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(old);
            }
            return res;
        }

        public boolean b(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.b(f, f1);
            }
            return false;
        }

        public void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        public void collide(net.minecraft.server.v1_16_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean cs() {
            if (this.npc != null && this.riding) {
                return true;
            }
            return super.cs();
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void enderTeleportTo(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.enderTeleportTo(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.enderTeleportTo(d0, d1, d2);
            }
        }

        public boolean er() {
            return this.npc != null && this.npc.getNavigator().isNavigating() ? false : super.er();
        }

        public void g(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.g(vec3d);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_16_R3.Entity)this, (CraftEntity)new HorseMuleNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        protected SoundEffect getSoundAmbient() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundAmbient(), "ambient-sound");
        }

        protected SoundEffect getSoundDeath() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundDeath(), "death-sound");
        }

        protected SoundEffect getSoundHurt(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundHurt(damagesource), "hurt-sound");
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public boolean isClimbing() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.isClimbing();
            }
            return false;
        }

        public boolean isLeashed() {
            if (this.npc == null) {
                return super.isLeashed();
            }
            boolean protectedDefault = this.npc.data().get("protected", Boolean.valueOf(true));
            if (!protectedDefault || !this.npc.data().get("protected-leash", Boolean.valueOf(protectedDefault)).booleanValue()) {
                return super.isLeashed();
            }
            if (super.isLeashed()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void mobTick() {
            super.mobTick();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                if (this.npc.hasTrait(Controllable.class) && this.npc.getOrAddTrait(Controllable.class).isEnabled()) {
                    this.riding = this.getBukkitEntity().getPassengers().size() > 0;
                    this.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(this.baseMovementSpeed * (double)this.npc.getNavigator().getDefaultParameters().speedModifier());
                } else {
                    this.riding = false;
                }
                if (this.riding) {
                    if (this.npc.getNavigator().isNavigating()) {
                        CraftEntity basePassenger = ((net.minecraft.server.v1_16_R3.Entity)this.passengers.get(0)).getBukkitEntity();
                        NMS.look((Entity)basePassenger, this.yaw, this.pitch);
                    }
                    this.d(4, true);
                }
                NMS.setStepHeight((Entity)this.getBukkitEntity(), 1.0f);
                this.npc.update();
            }
        }

        protected boolean n(net.minecraft.server.v1_16_R3.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return this.npc.data().get("protected", Boolean.valueOf(true)) == false;
            }
            return super.n(entity);
        }
    }

    public static class HorseMuleNPC
    extends CraftMule
    implements ForwardingNPCHolder {
        public HorseMuleNPC(EntityHorseMuleNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityHorseMule)entity);
        }
    }
}

