/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_16_R3.network.EmptyNetHandler;
import net.citizensnpcs.nms.v1_16_R3.network.EmptyNetworkManager;
import net.citizensnpcs.nms.v1_16_R3.network.EmptySocket;
import net.citizensnpcs.nms.v1_16_R3.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.nms.v1_16_R3.util.PlayerControllerJump;
import net.citizensnpcs.nms.v1_16_R3.util.PlayerControllerMove;
import net.citizensnpcs.nms.v1_16_R3.util.PlayerNavigation;
import net.citizensnpcs.nms.v1_16_R3.util.PlayerlistTracker;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.AttributeMapBase;
import net.minecraft.server.v1_16_R3.AttributeModifiable;
import net.minecraft.server.v1_16_R3.AttributeProvider;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.ChatComponentText;
import net.minecraft.server.v1_16_R3.DamageSource;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EnumGamemode;
import net.minecraft.server.v1_16_R3.EnumItemSlot;
import net.minecraft.server.v1_16_R3.EnumProtocolDirection;
import net.minecraft.server.v1_16_R3.GenericAttributes;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.MinecraftServer;
import net.minecraft.server.v1_16_R3.NavigationAbstract;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketListener;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_16_R3.PathType;
import net.minecraft.server.v1_16_R3.PlayerInteractManager;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder,
SkinnableEntity {
    private final Map<PathType, Float> bz = Maps.newEnumMap(PathType.class);
    private PlayerControllerJump controllerJump;
    private PlayerControllerMove controllerMove;
    private final Map<EnumItemSlot, ItemStack> equipmentCache = Maps.newEnumMap(EnumItemSlot.class);
    private int jumpTicks = 0;
    private PlayerNavigation navigation;
    private final CitizensNPC npc;
    private final Location packetLocationCache = new Location(null, 0.0, 0.0, 0.0);
    private PlayerlistTracker playerlistTracker;
    private final SkinPacketTracker skinTracker;
    private int updateCounter = 0;
    private static final MethodHandle ATTRIBUTE_MAP = NMS.getGetter(AttributeMapBase.class, "d");
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP = NMS.getGetter(AttributeProvider.class, "a");
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP_SETTER = NMS.getFinalSetter(AttributeProvider.class, "a");
    private static final float EPSILON = 0.003f;
    private static final Location LOADED_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer world, GameProfile gameProfile, PlayerInteractManager playerInteractManager, NPC npc) {
        super(minecraftServer, world, gameProfile, playerInteractManager);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.skinTracker = new SkinPacketTracker(this);
            playerInteractManager.setGameMode(EnumGamemode.SURVIVAL);
            this.initialise(minecraftServer);
        } else {
            this.skinTracker = null;
        }
    }

    protected void a(double d0, boolean flag, IBlockData block, BlockPosition blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, block, blockposition);
        }
    }

    public boolean a(EntityPlayer entityplayer) {
        if (this.npc != null && this.playerlistTracker == null) {
            return false;
        }
        return super.a(entityplayer);
    }

    public float a(PathType pathtype) {
        return this.bz.containsKey(pathtype) ? this.bz.get(pathtype).floatValue() : pathtype.a();
    }

    public void a(PathType pathtype, float f) {
        this.bz.put(pathtype, Float.valueOf(f));
    }

    public boolean b(float f, float f1) {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.b(f, f1);
        }
        return false;
    }

    public boolean b(PathType pathtype) {
        return pathtype != PathType.DANGER_FIRE && pathtype != PathType.DANGER_CACTUS && pathtype != PathType.DANGER_OTHER;
    }

    public void collide(Entity entity) {
        super.collide(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
        }
    }

    public boolean damageEntity(DamageSource damagesource, float f) {
        boolean damaged = super.damageEntity(damagesource, f);
        if (damaged && this.velocityChanged) {
            this.velocityChanged = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    EntityHumanNPC.this.velocityChanged = true;
                }
            });
        }
        return damaged;
    }

    public void die() {
        super.die();
        this.getAdvancementData().a();
    }

    public void die(DamageSource damagesource) {
        if (this.dead) {
            return;
        }
        super.die(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                ((WorldServer)EntityHumanNPC.this.world).removeEntity((Entity)EntityHumanNPC.this);
            }
        }, 15L);
    }

    public void enderTeleportTo(double d0, double d1, double d2) {
        if (this.npc == null) {
            super.enderTeleportTo(d0, d1, d2);
            return;
        }
        NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            super.enderTeleportTo(d0, d1, d2);
        }
    }

    public void g(Vec3D vec3d) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.g(vec3d);
        } else {
            NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
        }
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
            NMSImpl.setBukkitEntity((Entity)this, (CraftEntity)new PlayerNPC(this));
        }
        return super.getBukkitEntity();
    }

    public PlayerControllerJump getControllerJump() {
        return this.controllerJump;
    }

    public PlayerControllerMove getControllerMove() {
        return this.controllerMove;
    }

    public NavigationAbstract getNavigation() {
        return this.navigation;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    public IChatBaseComponent getPlayerListName() {
        if (this.npc.data().get("removefromplayerlist", Boolean.valueOf(Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean())).booleanValue()) {
            return new ChatComponentText("");
        }
        return super.getPlayerListName();
    }

    @Override
    public String getSkinName() {
        String skinName = this.npc.getOrAddTrait(SkinTrait.class).getSkinName();
        if (skinName == null) {
            skinName = this.npc.getName();
        }
        return skinName.toLowerCase();
    }

    @Override
    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    protected SoundEffect getSoundDeath() {
        return NMSImpl.getSoundEffect(this.npc, super.getSoundDeath(), "death-sound");
    }

    protected SoundEffect getSoundHurt(DamageSource damagesource) {
        return NMSImpl.getSoundEffect(this.npc, super.getSoundHurt(damagesource), "hurt-sound");
    }

    public void i(double x, double y, double z) {
        Vector vector = Util.callPushEvent(this.npc, x, y, z);
        if (vector != null) {
            super.i(vector.getX(), vector.getY(), vector.getZ());
        }
    }

    public boolean inBlock() {
        if (this.npc == null || this.noclip || this.isSleeping()) {
            return super.inBlock();
        }
        return Util.inBlock((org.bukkit.entity.Entity)this.getBukkitEntity());
    }

    private void initialise(MinecraftServer minecraftServer) {
        EmptySocket socket = new EmptySocket();
        EmptyNetworkManager conn = null;
        try {
            conn = new EmptyNetworkManager(EnumProtocolDirection.CLIENTBOUND);
            this.playerConnection = new EmptyNetHandler(minecraftServer, conn, this);
            conn.setPacketListener((PacketListener)this.playerConnection);
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AttributeModifiable range = this.getAttributeInstance(GenericAttributes.FOLLOW_RANGE);
        if (range == null) {
            try {
                AttributeProvider provider = ATTRIBUTE_MAP.invoke(this.getAttributeMap());
                HashMap all = Maps.newHashMap((Map)ATTRIBUTE_PROVIDER_MAP.invoke(provider));
                all.put(GenericAttributes.FOLLOW_RANGE, new AttributeModifiable(GenericAttributes.FOLLOW_RANGE, (Consumer)new Consumer<AttributeModifiable>(){

                    @Override
                    public void accept(AttributeModifiable att) {
                        throw new UnsupportedOperationException("Tried to change value for default attribute instance FOLLOW_RANGE");
                    }
                }));
                ATTRIBUTE_PROVIDER_MAP_SETTER.invoke(provider, ImmutableMap.copyOf((Map)all));
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            range = this.getAttributeMap().a(GenericAttributes.FOLLOW_RANGE);
        }
        range.setValue(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
        this.controllerJump = new PlayerControllerJump(this);
        this.controllerMove = new PlayerControllerMove((EntityLiving)this);
        this.navigation = new PlayerNavigation(this, this.world);
        this.invulnerableTicks = 0;
        NMS.setStepHeight((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0f);
        this.setSkinFlags((byte)-1);
        EmptyAdvancementDataPlayer.clear(this.getAdvancementData());
        NMSImpl.setAdvancement((Player)this.getBukkitEntity(), new EmptyAdvancementDataPlayer(minecraftServer.getDataFixer(), minecraftServer.getPlayerList(), minecraftServer.getAdvancementData(), CitizensAPI.getDataFolder().getParentFile(), this));
    }

    public boolean isClimbing() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.isClimbing();
        }
        return false;
    }

    public boolean isCollidable() {
        return this.npc == null ? super.isCollidable() : (this.npc.data().has("collidable") ? (Boolean)this.npc.data().get("collidable") : !this.npc.isProtected());
    }

    public boolean isNavigating() {
        return this.npc.getNavigator().isNavigating();
    }

    private void moveOnCurrentHeading() {
        if (this.jumping) {
            if (this.onGround && this.jumpTicks == 0) {
                this.jump();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.aR *= 0.98f;
        this.aT *= 0.98f;
        this.moveWithFallDamage(new Vec3D((double)this.aR, (double)this.aS, (double)this.aT));
        NMS.setHeadYaw((org.bukkit.entity.Entity)this.getBukkitEntity(), this.yaw);
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(Vec3D vec) {
        double y = this.locY();
        this.g(vec);
        if (!this.npc.isProtected()) {
            this.a(this.locY() - y, this.onGround);
        }
    }

    public Packet<?> P() {
        if (this.playerlistTracker != null) {
            this.playerlistTracker.updateLastPlayer();
        }
        return super.P();
    }

    public void playerTick() {
        Vec3D mot;
        boolean navigating;
        if (this.npc == null) {
            super.playerTick();
            return;
        }
        this.entityBaseTick();
        boolean bl = navigating = this.npc.getNavigator().isNavigating() || this.controllerMove.b();
        if (!navigating && this.getBukkitEntity() != null && (!this.npc.hasTrait(Gravity.class) || this.npc.getOrAddTrait(Gravity.class).hasGravity()) && Util.isLoaded(this.getBukkitEntity().getLocation(LOADED_LOCATION)) && SpigotUtil.checkYSafe(this.locY(), this.getBukkitEntity().getWorld())) {
            this.moveWithFallDamage(new Vec3D(0.0, 0.0, 0.0));
        }
        if (Math.abs((mot = this.getMot()).getX()) < (double)0.003f && Math.abs(mot.getY()) < (double)0.003f && Math.abs(mot.getZ()) < (double)0.003f) {
            this.setMot(new Vec3D(0.0, 0.0, 0.0));
        }
        if (navigating) {
            if (!NMSImpl.isNavigationFinished(this.navigation)) {
                NMSImpl.updateNavigation(this.navigation);
            }
            this.moveOnCurrentHeading();
        }
        NMSImpl.updateAI((EntityLiving)this);
        if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue()) {
            this.collideNearby();
        }
    }

    public void setMoveDestination(double x, double y, double z, double speed) {
        this.controllerMove.a(x, y, z, speed);
    }

    public void setShouldJump() {
        this.controllerJump.jump();
    }

    @Override
    public void setSkinFlags(byte flags) {
        this.getDataWatcher().set(EntityHuman.bi, (Object)flags);
    }

    @Override
    public void setSkinName(String name) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name);
    }

    @Override
    public void setSkinName(String name, boolean forceUpdate) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name, forceUpdate);
    }

    @Override
    public void setSkinPersistent(String skinName, String signature, String data) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinPersistent(skinName, signature, data);
    }

    public void setTracked(PlayerlistTracker tracker) {
        this.playerlistTracker = tracker;
    }

    public void tick() {
        super.tick();
        if (this.npc == null) {
            return;
        }
        this.noclip = this.isSpectator();
        if (this.updateCounter + 1 > Settings.Setting.PACKET_UPDATE_DELAY.asInt()) {
            this.updateEffects = true;
        }
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        boolean navigating = this.npc.getNavigator().isNavigating();
        this.updatePackets(navigating);
        this.npc.update();
        if (this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(!this.npc.isProtected())).booleanValue()) {
            AxisAlignedBB axisalignedbb = this.isPassenger() && !this.getVehicle().dead ? this.getBoundingBox().b(this.getVehicle().getBoundingBox()).grow(1.0, 0.0, 1.0) : this.getBoundingBox().grow(1.0, 0.5, 1.0);
            for (Entity entity : this.world.getEntities((Entity)this, axisalignedbb)) {
                if (entity.dead) continue;
                entity.pickup((EntityHuman)this);
            }
        }
    }

    public void updateAI() {
        this.controllerMove.a();
        this.controllerJump.b();
    }

    private void updatePackets(boolean navigating) {
        if (this.updateCounter++ <= this.npc.data().get(NPC.Metadata.PACKET_UPDATE_DELAY, Integer.valueOf(Settings.Setting.PACKET_UPDATE_DELAY.asInt()))) {
            return;
        }
        this.updateCounter = 0;
        boolean itemChanged = false;
        for (EnumItemSlot slot : EnumItemSlot.values()) {
            ItemStack equipment = this.getEquipment(slot);
            ItemStack cache = this.equipmentCache.get(slot);
            if (!(cache == null && equipment == null || !(cache == null ^ equipment == null) && ItemStack.equals((ItemStack)cache, (ItemStack)equipment))) {
                itemChanged = true;
            }
            this.equipmentCache.put(slot, equipment);
        }
        if (!itemChanged) {
            return;
        }
        Location current = this.getBukkitEntity().getLocation(this.packetLocationCache);
        Packet[] packets = new Packet[1];
        ArrayList vals = Lists.newArrayList();
        for (EnumItemSlot slot : EnumItemSlot.values()) {
            vals.add(new Pair((Object)slot, (Object)this.getEquipment(slot)));
        }
        packets[0] = new PacketPlayOutEntityEquipment(this.getId(), (List)vals);
        NMSImpl.sendPacketsNearby((Player)this.getBukkitEntity(), current, packets);
    }

    public void updatePathfindingRange(float pathfindingRange) {
        this.navigation.setRange(pathfindingRange);
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CraftServer cserver;
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
            this.cserver = (CraftServer)Bukkit.getServer();
            this.npc.getOrAddTrait(Inventory.class);
        }

        @Override
        public Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        @Override
        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        @Override
        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            this.cserver.getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            this.cserver.getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }

        @Override
        public void setSkinFlags(byte flags) {
            ((SkinnableEntity)this.entity).setSkinFlags(flags);
        }

        @Override
        public void setSkinName(String name) {
            ((SkinnableEntity)this.entity).setSkinName(name);
        }

        @Override
        public void setSkinName(String skinName, boolean forceUpdate) {
            ((SkinnableEntity)this.entity).setSkinName(skinName, forceUpdate);
        }

        @Override
        public void setSkinPersistent(String skinName, String signature, String data) {
            ((SkinnableEntity)this.entity).setSkinPersistent(skinName, signature, data);
        }
    }
}

