/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_16_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.DamageSource;
import net.minecraft.server.v1_16_R3.EntityBoat;
import net.minecraft.server.v1_16_R3.EntityEnderDragon;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityMinecartAbstract;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.FluidType;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class EnderDragonController
extends MobEntityController {
    public EnderDragonController() {
        super(EntityEnderDragonNPC.class);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)super.getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends EntityEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World world) {
            this(types, world, null);
        }

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World world, NPC npc) {
            super(types, world);
            this.npc = (CitizensNPC)npc;
        }

        public void a(float strength, double dx, double dz) {
            NPCKnockbackEvent event = new NPCKnockbackEvent(this.npc, strength, dx, dz);
            Bukkit.getPluginManager().callEvent((Event)event);
            Vector kb = event.getKnockbackVector();
            super.a((float)event.getStrength(), kb.getX(), kb.getZ());
        }

        public boolean a(Tag<FluidType> tag, double d0) {
            Vec3D old = this.getMot().add(0.0, 0.0, 0.0);
            boolean res = super.a(tag, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(old);
            }
            return res;
        }

        public void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        public void collide(net.minecraft.server.v1_16_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void enderTeleportTo(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.enderTeleportTo(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.enderTeleportTo(d0, d1, d2);
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_16_R3.Entity)this, (CraftEntity)new EnderDragonNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        protected SoundEffect getSoundAmbient() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundAmbient(), "ambient-sound");
        }

        protected SoundEffect getSoundDeath() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundDeath(), "death-sound");
        }

        protected SoundEffect getSoundHurt(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundHurt(damagesource), "hurt-sound");
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public boolean isLeashed() {
            if (this.npc == null) {
                return super.isLeashed();
            }
            boolean protectedDefault = this.npc.data().get("protected", Boolean.valueOf(true));
            if (!protectedDefault || !this.npc.data().get("protected-leash", Boolean.valueOf(protectedDefault)).booleanValue()) {
                return super.isLeashed();
            }
            if (super.isLeashed()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void movementTick() {
            if (this.npc != null) {
                this.npc.update();
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
            }
            if (this.npc != null && !this.npc.useMinecraftAI()) {
                Vec3D mot;
                if (this.getRidingPassenger() != null) {
                    this.yaw = this.getRidingPassenger().getBukkitYaw() - 180.0f;
                }
                if ((mot = this.getMot()).getX() != 0.0 || mot.getY() != 0.0 || mot.getZ() != 0.0) {
                    mot = mot.d(0.98, 0.98, 0.98);
                    if (this.getRidingPassenger() == null) {
                        this.yaw = Util.getDragonYaw((Entity)this.getBukkitEntity(), mot.x, mot.z);
                    }
                    this.setPosition(this.locX() + mot.getX(), this.locY() + mot.getY(), this.locZ() + mot.getZ());
                    this.setMot(mot);
                }
            } else {
                super.movementTick();
            }
        }

        protected boolean n(net.minecraft.server.v1_16_R3.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return this.npc.data().get("protected", Boolean.valueOf(true)) == false;
            }
            return super.n(entity);
        }
    }

    public static class EnderDragonNPC
    extends CraftEnderDragon
    implements ForwardingNPCHolder {
        public EnderDragonNPC(EntityEnderDragonNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderDragon)entity);
        }
    }
}

