/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_12_R1.util;

import java.lang.reflect.Field;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.nms.v1_12_R1.entity.EntityHumanNPC;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_12_R1.Entity;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import net.minecraft.server.v1_12_R1.EntityTrackerEntry;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerlistTrackerEntry
extends EntityTrackerEntry {
    private EntityPlayer lastUpdatedPlayer;
    private static Field E = NMS.getField(EntityTrackerEntry.class, "e");
    private static Field F = NMS.getField(EntityTrackerEntry.class, "f");
    private static Field G = NMS.getField(EntityTrackerEntry.class, "g");
    private static Field TRACKER = NMS.getField(EntityTrackerEntry.class, "tracker");
    private static Field U = NMS.getField(EntityTrackerEntry.class, "u");

    public PlayerlistTrackerEntry(Entity entity, int i, int j, int k, boolean flag) {
        super(entity, i, j, k, flag);
    }

    public PlayerlistTrackerEntry(EntityTrackerEntry entry) {
        this(PlayerlistTrackerEntry.getTracker(entry), PlayerlistTrackerEntry.getE(entry), PlayerlistTrackerEntry.getF(entry), PlayerlistTrackerEntry.getG(entry), PlayerlistTrackerEntry.getU(entry));
    }

    public boolean isUpdating() {
        return this.lastUpdatedPlayer != null;
    }

    public void updateLastPlayer() {
        if (this.lastUpdatedPlayer == null) {
            return;
        }
        final Entity tracker = PlayerlistTrackerEntry.getTracker(this);
        final EntityPlayer entityplayer = this.lastUpdatedPlayer;
        NMS.sendTabListAdd((Player)entityplayer.getBukkitEntity(), (Player)tracker.getBukkitEntity());
        this.lastUpdatedPlayer = null;
        if (!Settings.Setting.DISABLE_TABLIST.asBoolean()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                NMS.sendTabListRemove((Player)entityplayer.getBukkitEntity(), (Player)tracker.getBukkitEntity());
            }
        }, (long)Settings.Setting.TABLIST_REMOVE_PACKET_DELAY.asInt());
    }

    public void updatePlayer(EntityPlayer entityplayer) {
        if (entityplayer instanceof EntityHumanNPC) {
            return;
        }
        this.lastUpdatedPlayer = entityplayer;
        super.updatePlayer(entityplayer);
        this.lastUpdatedPlayer = null;
    }

    private static int getE(EntityTrackerEntry entry) {
        try {
            return (Integer)E.get(entry);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static int getF(EntityTrackerEntry entry) {
        try {
            return (Integer)F.get(entry);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static int getG(EntityTrackerEntry entry) {
        try {
            return (Integer)G.get(entry);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static Entity getTracker(EntityTrackerEntry entry) {
        try {
            return (Entity)TRACKER.get(entry);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static boolean getU(EntityTrackerEntry entry) {
        try {
            return (Boolean)U.get(entry);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }
}

