/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_12_R1.util;

import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.nms.v1_12_R1.util.NMSImpl;
import net.citizensnpcs.util.AbstractBlockBreaker;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.EnchantmentManager;
import net.minecraft.server.v1_12_R1.EntityLiving;
import net.minecraft.server.v1_12_R1.EnumItemSlot;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.Material;
import net.minecraft.server.v1_12_R1.MobEffects;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class CitizensBlockBreaker
extends AbstractBlockBreaker {
    public CitizensBlockBreaker(Entity entity, Block target, BlockBreaker.BlockBreakerConfiguration config) {
        super(entity, target, config);
    }

    private net.minecraft.server.v1_12_R1.ItemStack getCurrentItem() {
        return this.configuration.item() != null ? CraftItemStack.asNMSCopy((ItemStack)this.configuration.item()) : (this.getHandle() instanceof EntityLiving ? ((EntityLiving)this.getHandle()).getEquipment(EnumItemSlot.MAINHAND) : null);
    }

    @Override
    protected float getDamage(int tickDifference) {
        return this.getStrength(this.getHandle().world.getType(new BlockPosition(this.x, this.y, this.z))) * (float)(tickDifference + 1) * this.configuration.blockStrengthModifier();
    }

    private net.minecraft.server.v1_12_R1.Entity getHandle() {
        return NMSImpl.getHandle(this.entity);
    }

    private float getStrength(IBlockData block) {
        float base = block.getBlock().a(block, null, new BlockPosition(0, 0, 0));
        return base < 0.0f ? 0.0f : (!this.isDestroyable(block) ? 1.0f / base / 100.0f : this.strengthMod(block) / base / 30.0f);
    }

    private boolean isDestroyable(IBlockData block) {
        if (block.getMaterial().isAlwaysDestroyable()) {
            return true;
        }
        net.minecraft.server.v1_12_R1.ItemStack current = this.getCurrentItem();
        return current != null ? current.b(block) : false;
    }

    @Override
    protected void setBlockDamage(int modifiedDamage) {
        this.getHandle().world.c(this.getHandle().getId(), new BlockPosition(this.x, this.y, this.z), modifiedDamage);
    }

    private float strengthMod(IBlockData block) {
        net.minecraft.server.v1_12_R1.ItemStack itemstack = this.getCurrentItem();
        float f = itemstack.a(block);
        if (this.getHandle() instanceof EntityLiving) {
            int i;
            EntityLiving handle = (EntityLiving)this.getHandle();
            if (f > 1.0f && (i = EnchantmentManager.getDigSpeedEnchantmentLevel((EntityLiving)handle)) > 0) {
                f += (float)(i * i + 1);
            }
            if (handle.hasEffect(MobEffects.FASTER_DIG)) {
                f *= 1.0f + (float)(handle.getEffect(MobEffects.FASTER_DIG).getAmplifier() + 1) * 0.2f;
            }
            if (handle.hasEffect(MobEffects.SLOWER_DIG)) {
                float f1 = 1.0f;
                switch (handle.getEffect(MobEffects.SLOWER_DIG).getAmplifier()) {
                    case 0: {
                        f1 = 0.3f;
                        break;
                    }
                    case 1: {
                        f1 = 0.09f;
                        break;
                    }
                    case 2: {
                        f1 = 0.0027f;
                        break;
                    }
                    default: {
                        f1 = 8.1E-4f;
                    }
                }
                f *= f1;
            }
            if (handle.a(Material.WATER) && !EnchantmentManager.i((EntityLiving)handle)) {
                f /= 5.0f;
            }
        }
        if (!this.getHandle().onGround) {
            f /= 5.0f;
        }
        return f;
    }
}

