/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_12_R1.entity.nonliving;

import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_12_R1.entity.MobEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.EntityItemFrame;
import net.minecraft.server.v1_12_R1.EnumDirection;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftItemFrame;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ItemFrameController
extends MobEntityController {
    public ItemFrameController() {
        super(EntityItemFrameNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        Entity e = super.createEntity(at, npc);
        EntityItemFrame item = (EntityItemFrame)((CraftEntity)e).getHandle();
        item.setDirection(EnumDirection.EAST);
        item.blockPosition = new BlockPosition(at.getX(), at.getY(), at.getZ());
        return e;
    }

    public ItemFrame getBukkitEntity() {
        return (ItemFrame)super.getBukkitEntity();
    }

    public static class EntityItemFrameNPC
    extends EntityItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityItemFrameNPC(World world) {
            this(world, null);
        }

        public EntityItemFrameNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
        }

        public void B_() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.B_();
            }
        }

        public void collide(net.minecraft.server.v1_12_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void f(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.f(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new ItemFrameNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean survives() {
            return this.npc == null || !this.npc.isProtected() ? super.survives() : true;
        }
    }

    public static class ItemFrameNPC
    extends CraftItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public ItemFrameNPC(EntityItemFrameNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityItemFrame)entity);
            this.npc = entity.npc;
            int amount = this.npc.data().get("item-type-amount", Integer.valueOf(1));
            Material material = Material.getMaterial((String)this.npc.data().get("item-type-id", "STONE"));
            Number durability = this.npc.data().get("item-type-data", (Number)this.npc.data().get("falling-block-data", Short.valueOf((short)0)));
            this.setItem(new ItemStack(material, amount, durability.shortValue()));
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void setType(Material material, int data) {
            this.npc.data().setPersistent("item-type-id", (Object)material.name());
            this.npc.data().setPersistent("item-type-data", (Object)data);
            if (this.npc.isSpawned()) {
                this.npc.despawn(DespawnReason.PENDING_RESPAWN);
                this.npc.spawn(this.npc.getStoredLocation(), SpawnReason.RESPAWN);
            }
        }
    }
}

