/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_12_R1.entity.nonliving;

import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_12_R1.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_12_R1.Block;
import net.minecraft.server.v1_12_R1.Blocks;
import net.minecraft.server.v1_12_R1.EntityFallingBlock;
import net.minecraft.server.v1_12_R1.EnumMoveType;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.World;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

public class FallingBlockController
extends AbstractEntityController {
    public FallingBlockController() {
        super(EntityFallingBlockNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        WorldServer ws = ((CraftWorld)at.getWorld()).getHandle();
        Block id = Blocks.STONE;
        int data = npc.data().get("item-type-data", npc.data().get("falling-block-data", Integer.valueOf(0)));
        if (npc.data().has("falling-block-id") || npc.data().has("item-type-id")) {
            id = CraftMagicNumbers.getBlock((Material)Material.getMaterial((String)npc.data().get("item-type-id", (String)npc.data().get("falling-block-id"))));
        }
        EntityFallingBlockNPC handle = new EntityFallingBlockNPC((World)ws, npc, at.getX(), at.getY(), at.getZ(), id.fromLegacyData(data));
        return handle.getBukkitEntity();
    }

    public FallingBlock getBukkitEntity() {
        return (FallingBlock)super.getBukkitEntity();
    }

    public static class EntityFallingBlockNPC
    extends EntityFallingBlock
    implements NPCHolder {
        private final CitizensNPC npc;
        private static final double EPSILON = 0.001;

        public EntityFallingBlockNPC(World world) {
            this(world, null);
        }

        public EntityFallingBlockNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
        }

        public EntityFallingBlockNPC(World world, NPC npc, double d0, double d1, double d2, IBlockData data) {
            super(world, d0, d1, d2, data);
            this.npc = (CitizensNPC)npc;
        }

        public void B_() {
            if (this.npc != null) {
                this.npc.update();
                if (Math.abs(this.motX) > 0.001 || Math.abs(this.motY) > 0.001 || Math.abs(this.motZ) > 0.001) {
                    this.motX *= 0.98;
                    this.motY *= 0.98;
                    this.motZ *= 0.98;
                    this.move(EnumMoveType.SELF, this.motX, this.motY, this.motZ);
                }
            } else {
                super.B_();
            }
        }

        public void collide(net.minecraft.server.v1_12_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void f(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.f(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new FallingBlockNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void setSize(float f, float f1) {
            if (this.npc == null) {
                super.setSize(f, f1);
            } else {
                NMSImpl.setSize((net.minecraft.server.v1_12_R1.Entity)this, f, f1, this.justCreated);
            }
        }
    }

    public static class FallingBlockNPC
    extends CraftFallingBlock
    implements NPCHolder {
        private final CitizensNPC npc;

        public FallingBlockNPC(EntityFallingBlockNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityFallingBlock)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void setType(Material material, int data) {
            this.npc.data().setPersistent("item-type-id", (Object)material.name());
            this.npc.data().setPersistent("item-type-data", (Object)data);
            if (this.npc.isSpawned()) {
                this.npc.despawn(DespawnReason.PENDING_RESPAWN);
                this.npc.spawn(this.npc.getStoredLocation(), SpawnReason.RESPAWN);
            }
        }
    }
}

