/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_12_R1.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_12_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_12_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_12_R1.DamageSource;
import net.minecraft.server.v1_12_R1.EntityVex;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.SoundEffect;
import net.minecraft.server.v1_12_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftVex;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Vex;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class VexController
extends MobEntityController {
    public VexController() {
        super(EntityVexNPC.class);
    }

    public Vex getBukkitEntity() {
        return (Vex)super.getBukkitEntity();
    }

    public static class EntityVexNPC
    extends EntityVex
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityVexNPC(World world) {
            this(world, null);
        }

        public EntityVexNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.setNoGravity(true);
            }
        }

        public void a(net.minecraft.server.v1_12_R1.Entity entity, float strength, double dx, double dz) {
            NPCKnockbackEvent event = new NPCKnockbackEvent(this.npc, strength, dx, dz);
            Bukkit.getPluginManager().callEvent((Event)event);
            Vector kb = event.getKnockbackVector();
            super.a(entity, (float)event.getStrength(), kb.getX(), kb.getZ());
        }

        protected SoundEffect cf() {
            return NMSImpl.getSoundEffect(this.npc, super.cf(), "death-sound");
        }

        public void collide(net.minecraft.server.v1_12_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        protected SoundEffect d(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.d(damagesource), "hurt-sound");
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void enderTeleportTo(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.enderTeleportTo(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.enderTeleportTo(d0, d1, d2);
            }
        }

        public void f(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.f(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        protected SoundEffect F() {
            return NMSImpl.getSoundEffect(this.npc, super.F(), "ambient-sound");
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new VexNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean isLeashed() {
            if (this.npc == null) {
                return super.isLeashed();
            }
            boolean protectedDefault = this.npc.data().get("protected", Boolean.valueOf(true));
            if (!protectedDefault || !this.npc.data().get("protected-leash", Boolean.valueOf(protectedDefault)).booleanValue()) {
                return super.isLeashed();
            }
            if (super.isLeashed()) {
                this.unleash(true, false);
            }
            return false;
        }

        protected void L() {
            if (this.npc == null) {
                super.L();
            }
        }

        public void M() {
            super.M();
            if (this.npc != null) {
                this.npc.update();
            }
        }
    }

    public static class VexNPC
    extends CraftVex
    implements NPCHolder {
        private final CitizensNPC npc;

        public VexNPC(EntityVexNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityVex)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

