/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_12_R1.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_12_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_12_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_12_R1.DamageSource;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.EntityLiving;
import net.minecraft.server.v1_12_R1.EntityParrot;
import net.minecraft.server.v1_12_R1.EnumHand;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.SoundEffect;
import net.minecraft.server.v1_12_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftParrot;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Parrot;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class ParrotController
extends MobEntityController {
    public ParrotController() {
        super(EntityParrotNPC.class);
    }

    public Parrot getBukkitEntity() {
        return (Parrot)super.getBukkitEntity();
    }

    public static class EntityParrotNPC
    extends EntityParrot
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityParrotNPC(World world) {
            this(world, null);
        }

        public EntityParrotNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
        }

        public void a(net.minecraft.server.v1_12_R1.Entity entity, float strength, double dx, double dz) {
            NPCKnockbackEvent event = new NPCKnockbackEvent(this.npc, strength, dx, dz);
            Bukkit.getPluginManager().callEvent((Event)event);
            Vector kb = event.getKnockbackVector();
            super.a(entity, (float)event.getStrength(), kb.getX(), kb.getZ());
        }

        public boolean a(EntityHuman paramEntityHuman, EnumHand paramEnumHand) {
            if (this.npc == null || !this.npc.data().get("protected", Boolean.valueOf(true)).booleanValue()) {
                return super.a(paramEntityHuman, paramEnumHand);
            }
            return false;
        }

        protected SoundEffect cf() {
            return NMSImpl.getSoundEffect(this.npc, super.cf(), "death-sound");
        }

        public void collide(net.minecraft.server.v1_12_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        protected SoundEffect d(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.d(damagesource), "hurt-sound");
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void enderTeleportTo(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.enderTeleportTo(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.enderTeleportTo(d0, d1, d2);
            }
        }

        public void f(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.f(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public SoundEffect F() {
            return NMSImpl.getSoundEffect(this.npc, super.F(), "ambient-sound");
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new ParrotNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean isLeashed() {
            if (this.npc == null) {
                return super.isLeashed();
            }
            boolean protectedDefault = this.npc.data().get("protected", Boolean.valueOf(true));
            if (!protectedDefault || !this.npc.data().get("protected-leash", Boolean.valueOf(protectedDefault)).booleanValue()) {
                return super.isLeashed();
            }
            if (super.isLeashed()) {
                this.unleash(true, false);
            }
            return false;
        }

        protected void L() {
            if (this.npc == null) {
                super.L();
            }
        }

        public void M() {
            if (this.npc == null) {
                super.M();
            } else {
                NMSImpl.updateAI((EntityLiving)this);
                this.npc.update();
            }
        }
    }

    public static class ParrotNPC
    extends CraftParrot
    implements NPCHolder {
        private final CitizensNPC npc;

        public ParrotNPC(EntityParrotNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityParrot)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

