/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_12_R1.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_12_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_12_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.DamageSource;
import net.minecraft.server.v1_12_R1.EntityIllagerIllusioner;
import net.minecraft.server.v1_12_R1.EntityLiving;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.SoundEffect;
import net.minecraft.server.v1_12_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftIllusioner;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Illusioner;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class IllusionerController
extends MobEntityController {
    public IllusionerController() {
        super(EntityIllusionerNPC.class);
    }

    public Illusioner getBukkitEntity() {
        return (Illusioner)super.getBukkitEntity();
    }

    public static class EntityIllusionerNPC
    extends EntityIllagerIllusioner
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityIllusionerNPC(World world) {
            this(world, null);
        }

        public EntityIllusionerNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
        }

        protected void a(double d0, boolean flag, IBlockData block, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, block, blockposition);
            }
        }

        public void a(net.minecraft.server.v1_12_R1.Entity entity, float strength, double dx, double dz) {
            NPCKnockbackEvent event = new NPCKnockbackEvent(this.npc, strength, dx, dz);
            Bukkit.getPluginManager().callEvent((Event)event);
            Vector kb = event.getKnockbackVector();
            super.a(entity, (float)event.getStrength(), kb.getX(), kb.getZ());
        }

        public void a(float f, float f1, float f2) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(f, f1, f2);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, f, f1, f2);
            }
        }

        protected SoundEffect cf() {
            return NMSImpl.getSoundEffect(this.npc, super.cf(), "death-sound");
        }

        public void collide(net.minecraft.server.v1_12_R1.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        protected SoundEffect d(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.d(damagesource), "hurt-sound");
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void e(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.e(f, f1);
            }
        }

        public void enderTeleportTo(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.enderTeleportTo(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.enderTeleportTo(d0, d1, d2);
            }
        }

        public void f(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.f(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        protected SoundEffect F() {
            return NMSImpl.getSoundEffect(this.npc, super.F(), "ambient-sound");
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new IllusionerNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean isLeashed() {
            if (this.npc == null) {
                return super.isLeashed();
            }
            boolean protectedDefault = this.npc.data().get("protected", Boolean.valueOf(true));
            if (!protectedDefault || !this.npc.data().get("protected-leash", Boolean.valueOf(protectedDefault)).booleanValue()) {
                return super.isLeashed();
            }
            if (super.isLeashed()) {
                this.unleash(true, false);
            }
            return false;
        }

        protected void L() {
            if (this.npc == null) {
                super.L();
            }
        }

        public void M() {
            super.M();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public boolean m_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.m_();
            }
            return false;
        }
    }

    public static class IllusionerNPC
    extends CraftIllusioner
    implements NPCHolder {
        private final CitizensNPC npc;

        public IllusionerNPC(EntityIllusionerNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityIllagerIllusioner)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

