/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_12_R1.entity;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_12_R1.entity.EntityHumanNPC;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.skin.Skin;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_12_R1.PlayerInteractManager;
import net.minecraft.server.v1_12_R1.World;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class HumanController
extends AbstractEntityController {
    @Override
    protected Entity createEntity(Location at, final NPC npc) {
        WorldServer nmsWorld = ((CraftWorld)at.getWorld()).getHandle();
        String coloredName = npc.getFullName();
        String name = coloredName.length() > 16 ? coloredName.substring(0, 16) : coloredName;
        UUID uuid = npc.getUniqueId();
        if (uuid.version() == 4) {
            long msb = uuid.getMostSignificantBits();
            msb &= 0xFFFFFFFFFFFFBFFFL;
            uuid = new UUID(msb |= 0x2000L, uuid.getLeastSignificantBits());
        }
        String teamName = Util.getTeamName(uuid);
        if (npc.requiresNameHologram()) {
            name = teamName;
        }
        if (Settings.Setting.USE_SCOREBOARD_TEAMS.asBoolean()) {
            npc.getOrAddTrait(ScoreboardTrait.class).createTeam(name);
        }
        GameProfile profile = new GameProfile(uuid, name);
        final EntityHumanNPC handle = new EntityHumanNPC(nmsWorld.getServer().getServer(), nmsWorld, profile, new PlayerInteractManager((World)nmsWorld), npc);
        Skin skin = handle.getSkinTracker().getSkin();
        if (skin != null) {
            skin.apply(handle);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (HumanController.this.getBukkitEntity() == null || !HumanController.this.getBukkitEntity().isValid() || HumanController.this.getBukkitEntity() != handle.getBukkitEntity()) {
                    return;
                }
                boolean removeFromPlayerList = npc.data().get("removefromplayerlist", Boolean.valueOf(Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean()));
                NMS.addOrRemoveFromPlayerList((Entity)HumanController.this.getBukkitEntity(), removeFromPlayerList);
            }
        }, 20L);
        handle.getBukkitEntity().setSleepingIgnored(true);
        return handle.getBukkitEntity();
    }

    public Player getBukkitEntity() {
        return (Player)super.getBukkitEntity();
    }
}

