/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_12_R1.entity;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_12_R1.network.EmptyNetHandler;
import net.citizensnpcs.nms.v1_12_R1.network.EmptyNetworkManager;
import net.citizensnpcs.nms.v1_12_R1.network.EmptySocket;
import net.citizensnpcs.nms.v1_12_R1.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_12_R1.util.NMSImpl;
import net.citizensnpcs.nms.v1_12_R1.util.PlayerControllerJump;
import net.citizensnpcs.nms.v1_12_R1.util.PlayerControllerMove;
import net.citizensnpcs.nms.v1_12_R1.util.PlayerNavigation;
import net.citizensnpcs.nms.v1_12_R1.util.PlayerlistTrackerEntry;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_12_R1.AttributeInstance;
import net.minecraft.server.v1_12_R1.AxisAlignedBB;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.ChatComponentText;
import net.minecraft.server.v1_12_R1.DamageSource;
import net.minecraft.server.v1_12_R1.DataWatcher;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.EntityLiving;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import net.minecraft.server.v1_12_R1.EnumGamemode;
import net.minecraft.server.v1_12_R1.EnumItemSlot;
import net.minecraft.server.v1_12_R1.EnumProtocolDirection;
import net.minecraft.server.v1_12_R1.GenericAttributes;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import net.minecraft.server.v1_12_R1.ItemStack;
import net.minecraft.server.v1_12_R1.MinecraftServer;
import net.minecraft.server.v1_12_R1.NavigationAbstract;
import net.minecraft.server.v1_12_R1.Packet;
import net.minecraft.server.v1_12_R1.PacketListener;
import net.minecraft.server.v1_12_R1.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_12_R1.PathType;
import net.minecraft.server.v1_12_R1.PlayerInteractManager;
import net.minecraft.server.v1_12_R1.SoundEffect;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder,
SkinnableEntity {
    private final Map<PathType, Float> bz = Maps.newEnumMap(PathType.class);
    private PlayerControllerJump controllerJump;
    private PlayerControllerMove controllerMove;
    private final Map<EnumItemSlot, ItemStack> equipmentCache = Maps.newEnumMap(EnumItemSlot.class);
    private int jumpTicks = 0;
    private PlayerNavigation navigation;
    private final CitizensNPC npc;
    private final Location packetLocationCache = new Location(null, 0.0, 0.0, 0.0);
    private final SkinPacketTracker skinTracker;
    private PlayerlistTrackerEntry trackerEntry;
    private int updateCounter = 0;
    private static MethodHandle ADVANCEMENT_DATA_PLAYER = NMS.getFinalSetter(EntityPlayer.class, "bY");
    private static final float EPSILON = 0.005f;
    private static final Location LOADED_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer world, GameProfile gameProfile, PlayerInteractManager playerInteractManager, NPC npc) {
        super(minecraftServer, world, gameProfile, playerInteractManager);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.skinTracker = new SkinPacketTracker(this);
            playerInteractManager.setGameMode(EnumGamemode.SURVIVAL);
            this.initialise(minecraftServer);
        } else {
            this.skinTracker = null;
        }
    }

    protected void a(double d0, boolean flag, IBlockData block, BlockPosition blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, block, blockposition);
        }
    }

    public boolean a(EntityPlayer entityplayer) {
        if (this.npc != null && this.trackerEntry == null) {
            return false;
        }
        return super.a(entityplayer);
    }

    public void a(float f, float f1, float f2) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(f, f1, f2);
        } else {
            NMSImpl.flyingMoveLogic((EntityLiving)this, f, f1, f2);
        }
    }

    public float a(PathType pathtype) {
        return this.bz.containsKey(pathtype) ? this.bz.get(pathtype).floatValue() : pathtype.a();
    }

    public void a(PathType pathtype, float f) {
        this.bz.put(pathtype, Float.valueOf(f));
    }

    public void B_() {
        super.B_();
        if (this.npc == null) {
            return;
        }
        this.noclip = this.isSpectator();
        if (this.updateCounter + 1 > Settings.Setting.PACKET_UPDATE_DELAY.asInt()) {
            this.updateEffects = true;
        }
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.bukkitEntity);
        boolean navigating = this.npc.getNavigator().isNavigating() || this.controllerMove.b();
        this.updatePackets(navigating);
        this.npc.update();
    }

    protected SoundEffect cf() {
        return NMSImpl.getSoundEffect(this.npc, super.cf(), "death-sound");
    }

    public void collide(net.minecraft.server.v1_12_R1.Entity entity) {
        super.collide(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    protected SoundEffect d(DamageSource damagesource) {
        return NMSImpl.getSoundEffect(this.npc, super.d(damagesource), "hurt-sound");
    }

    public boolean damageEntity(DamageSource damagesource, float f) {
        boolean damaged = super.damageEntity(damagesource, f);
        if (damaged && this.velocityChanged) {
            this.velocityChanged = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    EntityHumanNPC.this.velocityChanged = true;
                }
            });
        }
        return damaged;
    }

    public void die() {
        super.die();
        this.getAdvancementData().a();
    }

    public void die(DamageSource damagesource) {
        if (this.dead) {
            return;
        }
        super.die(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                EntityHumanNPC.this.world.removeEntity((net.minecraft.server.v1_12_R1.Entity)EntityHumanNPC.this);
            }
        }, 35L);
    }

    public void e(float f, float f1) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.e(f, f1);
        }
    }

    public void enderTeleportTo(double d0, double d1, double d2) {
        if (this.npc == null) {
            super.enderTeleportTo(d0, d1, d2);
            return;
        }
        NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            super.enderTeleportTo(d0, d1, d2);
        }
    }

    public void f(double x, double y, double z) {
        Vector vector = Util.callPushEvent(this.npc, x, y, z);
        if (vector != null) {
            super.f(vector.getX(), vector.getY(), vector.getZ());
        }
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
            this.bukkitEntity = new PlayerNPC(this);
        }
        return super.getBukkitEntity();
    }

    public PlayerControllerJump getControllerJump() {
        return this.controllerJump;
    }

    public PlayerControllerMove getControllerMove() {
        return this.controllerMove;
    }

    public DataWatcher getDataWatcher() {
        if (this.trackerEntry != null && this.trackerEntry.isUpdating()) {
            this.trackerEntry.updateLastPlayer();
        }
        return super.getDataWatcher();
    }

    public NavigationAbstract getNavigation() {
        return this.navigation;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    public IChatBaseComponent getPlayerListName() {
        if (this.npc.data().get("removefromplayerlist", Boolean.valueOf(Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean())).booleanValue()) {
            return new ChatComponentText("");
        }
        return super.getPlayerListName();
    }

    @Override
    public String getSkinName() {
        String skinName = this.npc.getOrAddTrait(SkinTrait.class).getSkinName();
        if (skinName == null) {
            skinName = this.npc.getName();
        }
        return skinName.toLowerCase();
    }

    @Override
    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public boolean inBlock() {
        if (this.npc == null || this.noclip || this.isSleeping()) {
            return super.inBlock();
        }
        return Util.inBlock((Entity)this.getBukkitEntity());
    }

    private void initialise(MinecraftServer minecraftServer) {
        EmptySocket socket = new EmptySocket();
        EmptyNetworkManager conn = null;
        try {
            conn = new EmptyNetworkManager(EnumProtocolDirection.CLIENTBOUND);
            this.playerConnection = new EmptyNetHandler(minecraftServer, conn, this);
            conn.setPacketListener((PacketListener)this.playerConnection);
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AttributeInstance range = this.getAttributeInstance(GenericAttributes.FOLLOW_RANGE);
        if (range == null) {
            range = this.getAttributeMap().b(GenericAttributes.FOLLOW_RANGE);
        }
        range.setValue(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
        this.controllerJump = new PlayerControllerJump(this);
        this.controllerMove = new PlayerControllerMove((EntityLiving)this);
        this.navigation = new PlayerNavigation(this, this.world);
        this.invulnerableTicks = 0;
        NMS.setStepHeight((Entity)this.getBukkitEntity(), 1.0f);
        this.setSkinFlags((byte)-1);
        EmptyAdvancementDataPlayer.clear(this.getAdvancementData());
        try {
            ADVANCEMENT_DATA_PLAYER.invoke(this, new EmptyAdvancementDataPlayer(minecraftServer, CitizensAPI.getDataFolder().getParentFile(), this));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean isCollidable() {
        return this.npc == null ? super.isCollidable() : (this.npc.data().has("collidable") ? (Boolean)this.npc.data().get("collidable") : !this.npc.isProtected());
    }

    public boolean isNavigating() {
        return this.npc.getNavigator().isNavigating();
    }

    public boolean m_() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.m_();
        }
        return false;
    }

    private void moveOnCurrentHeading() {
        if (this.bd) {
            if (this.onGround && this.jumpTicks == 0) {
                this.cu();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.be *= 0.98f;
        this.bg *= 0.98f;
        this.bh *= 0.9f;
        this.moveWithFallDamage(this.be, this.bf, this.bg);
        NMS.setHeadYaw((Entity)this.getBukkitEntity(), this.yaw);
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(float mx, float my, float mz) {
        double y = this.locY;
        this.a(mx, my, mz);
        if (!this.npc.isProtected()) {
            this.a(this.locY - y, this.onGround);
        }
    }

    public void playerTick() {
        if (this.npc == null) {
            super.playerTick();
            return;
        }
        this.Y();
        boolean navigating = this.npc.getNavigator().isNavigating();
        if (!navigating && this.getBukkitEntity() != null && (!this.npc.hasTrait(Gravity.class) || this.npc.getOrAddTrait(Gravity.class).hasGravity()) && Util.isLoaded(this.getBukkitEntity().getLocation(LOADED_LOCATION)) && SpigotUtil.checkYSafe(this.locY, this.getBukkitEntity().getWorld())) {
            this.moveWithFallDamage(0.0f, 0.0f, 0.0f);
        }
        if (Math.abs(this.motX) < (double)0.005f && Math.abs(this.motY) < (double)0.005f && Math.abs(this.motZ) < (double)0.005f) {
            this.motZ = 0.0;
            this.motY = 0.0;
            this.motX = 0.0;
        }
        if (navigating) {
            if (!NMSImpl.isNavigationFinished(this.navigation)) {
                NMSImpl.updateNavigation(this.navigation);
            }
            this.moveOnCurrentHeading();
        }
        NMSImpl.updateAI((EntityLiving)this);
        if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue()) {
            this.cB();
        }
        if (this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(!this.npc.isProtected())).booleanValue()) {
            AxisAlignedBB axisalignedbb = this.isPassenger() && !this.getVehicle().dead ? this.getBoundingBox().b(this.getVehicle().getBoundingBox()).grow(1.0, 0.0, 1.0) : this.getBoundingBox().grow(1.0, 0.5, 1.0);
            for (net.minecraft.server.v1_12_R1.Entity entity : this.world.getEntities((net.minecraft.server.v1_12_R1.Entity)this, axisalignedbb)) {
                if (entity.dead) continue;
                entity.d((EntityHuman)this);
            }
        }
    }

    public void setMoveDestination(double x, double y, double z, double speed) {
        this.controllerMove.a(x, y, z, speed);
    }

    public void setShouldJump() {
        this.controllerJump.a();
    }

    @Override
    public void setSkinFlags(byte flags) {
        this.getDataWatcher().set(EntityHuman.br, (Object)flags);
    }

    @Override
    public void setSkinName(String name) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name);
    }

    @Override
    public void setSkinName(String name, boolean forceUpdate) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name, forceUpdate);
    }

    @Override
    public void setSkinPersistent(String skinName, String signature, String data) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinPersistent(skinName, signature, data);
    }

    public void setTracked(PlayerlistTrackerEntry entry) {
        this.trackerEntry = entry;
    }

    public void updateAI() {
        this.controllerMove.a();
        this.controllerJump.b();
    }

    private void updatePackets(boolean navigating) {
        if (this.updateCounter++ <= this.npc.data().get(NPC.Metadata.PACKET_UPDATE_DELAY, Integer.valueOf(Settings.Setting.PACKET_UPDATE_DELAY.asInt()))) {
            return;
        }
        this.updateCounter = 0;
        boolean itemChanged = false;
        for (EnumItemSlot slot : EnumItemSlot.values()) {
            ItemStack equipment = this.getEquipment(slot);
            ItemStack cache = this.equipmentCache.get(slot);
            if (!(cache == null && equipment == null || !(cache == null ^ equipment == null) && ItemStack.equals((ItemStack)cache, (ItemStack)equipment))) {
                itemChanged = true;
            }
            this.equipmentCache.put(slot, equipment);
        }
        if (!itemChanged) {
            return;
        }
        Location current = this.getBukkitEntity().getLocation(this.packetLocationCache);
        Packet[] packets = new Packet[EnumItemSlot.values().length];
        int i = 0;
        for (EnumItemSlot slot : EnumItemSlot.values()) {
            packets[i++] = new PacketPlayOutEntityEquipment(this.getId(), slot, this.getEquipment(slot));
        }
        NMSImpl.sendPacketsNearby((Player)this.getBukkitEntity(), current, packets);
    }

    public void updatePathfindingRange(float pathfindingRange) {
        this.navigation.setRange(pathfindingRange);
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CraftServer cserver;
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
            this.cserver = (CraftServer)Bukkit.getServer();
            this.npc.getOrAddTrait(Inventory.class);
        }

        @Override
        public Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        @Override
        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        @Override
        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            this.cserver.getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            this.cserver.getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }

        @Override
        public void setSkinFlags(byte flags) {
            ((SkinnableEntity)this.entity).setSkinFlags(flags);
        }

        @Override
        public void setSkinName(String name) {
            ((SkinnableEntity)this.entity).setSkinName(name);
        }

        @Override
        public void setSkinName(String skinName, boolean forceUpdate) {
            ((SkinnableEntity)this.entity).setSkinName(skinName, forceUpdate);
        }

        @Override
        public void setSkinPersistent(String skinName, String signature, String data) {
            ((SkinnableEntity)this.entity).setSkinPersistent(skinName, signature, data);
        }
    }
}

