/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import java.util.List;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.astar.pathfinder.ChunkBlockSource;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.hpastar.HPAGraph;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.LinearWaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Requirements(ownership=true, selected=true)
public class WaypointCommands {
    public WaypointCommands(Citizens plugin) {
    }

    @Command(aliases={"waypoints", "waypoint", "wp"}, usage="add [x] [y] [z] (world) (--index idx)", desc="Adds a waypoint at a point", modifiers={"add"}, min=4, max=5, permission="citizens.waypoints.add")
    public void add(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"index"}) Integer index) throws CommandException {
        World world;
        WaypointProvider provider = npc.getOrAddTrait(Waypoints.class).getCurrentProvider();
        if (!(provider instanceof LinearWaypointProvider)) {
            throw new CommandException();
        }
        List waypoints = (List)((LinearWaypointProvider)provider).waypoints();
        World world2 = world = args.argsLength() > 4 ? Bukkit.getWorld((String)args.getString(4)) : npc.getStoredLocation().getWorld();
        if (world == null) {
            throw new CommandException("citizens.commands.errors.missing-world");
        }
        Location loc = new Location(world, (double)args.getInteger(1), (double)args.getInteger(2), (double)args.getInteger(3));
        int idx = index == null ? waypoints.size() : index.intValue();
        waypoints.add(index, new Waypoint(loc));
        Messaging.sendTr(sender, "citizens.commands.waypoints.add.waypoint-added", Util.prettyPrintLocation(loc), index);
    }

    @Command(aliases={"waypoints", "waypoint", "wp"}, usage="disableteleport", desc="Disables teleportation when stuck", modifiers={"disableteleport", "dt"}, min=1, max=1, permission="citizens.waypoints.disableteleport")
    public void disableTeleporting(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        npc.data().setPersistent("disable-default-stuck-action", (Object)(npc.data().get("disable-default-stuck-action", Boolean.valueOf(false)) == false ? 1 : 0));
        if (npc.data().get("disable-default-stuck-action", Boolean.valueOf(false)).booleanValue()) {
            npc.getNavigator().getDefaultParameters().stuckAction(null);
            Messaging.sendTr(sender, "citizens.commands.waypoints.disableteleporting.disabled", npc.getName());
        } else {
            npc.getNavigator().getDefaultParameters().stuckAction(TeleportStuckAction.INSTANCE);
            Messaging.sendTr(sender, "citizens.commands.waypoints.disableteleporting.enabled", npc.getName());
        }
    }

    @Command(aliases={"waypoints", "waypoint", "wp"}, usage="hpa", desc="Debugging command", modifiers={"hpa"}, min=1, max=1, permission="citizens.waypoints.hpa")
    public void hpa(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (Messaging.isDebugging() && sender.isOp()) {
            HPAGraph graph = new HPAGraph(new ChunkBlockSource(npc.getStoredLocation(), 16.0f), npc.getStoredLocation().getBlockX(), npc.getStoredLocation().getBlockY(), npc.getStoredLocation().getBlockZ());
            graph.addClusters(npc.getStoredLocation().getBlockX(), npc.getStoredLocation().getBlockZ());
            System.out.println(graph.findPath(new Location(npc.getStoredLocation().getWorld(), 8.0, 68.0, -134.0), new Location(npc.getStoredLocation().getWorld(), 11.0, 68.0, -131.0)));
        }
    }

    @Command(aliases={"waypoints", "waypoint", "wp"}, usage="opendoors", desc="Enables opening doors when pathfinding", modifiers={"opendoors", "od"}, min=1, max=1, permission="citizens.waypoints.opendoors")
    public void openDoors(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        boolean opensDoors = npc.data().get("pathfinder-open-doors", Boolean.valueOf(false)) == false;
        npc.data().setPersistent("pathfinder-open-doors", (Object)opensDoors);
        Messaging.sendTr(sender, opensDoors ? "citizens.commands.waypoints.opendoors.enabled" : "citizens.commands.waypoints.opendoors.disabled", npc.getName());
    }

    @Command(aliases={"waypoints", "waypoint", "wp"}, usage="provider [provider name]", desc="Sets the current waypoint provider", modifiers={"provider"}, min=1, max=2, permission="citizens.waypoints.provider")
    public void provider(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        boolean success;
        Waypoints waypoints = npc.getOrAddTrait(Waypoints.class);
        if (args.argsLength() == 1) {
            Messaging.sendTr(sender, "citizens.waypoints.current-provider", waypoints.getCurrentProviderName());
            waypoints.describeProviders(sender);
            return;
        }
        if (sender instanceof Player && Editor.hasEditor((Player)sender)) {
            Editor.leave((Player)sender);
        }
        if (!(success = waypoints.setWaypointProvider(args.getString(1)))) {
            throw new CommandException("Provider not found.");
        }
        Messaging.sendTr(sender, "citizens.waypoints.set-provider", args.getString(1));
    }
}

