/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.ai.tree.StatusMapper;
import net.citizensnpcs.api.command.Arg;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.command.exception.NoPermissionsException;
import net.citizensnpcs.api.command.exception.RequirementMissingException;
import net.citizensnpcs.api.command.exception.ServerCommandException;
import net.citizensnpcs.api.event.CommandSenderCloneNPCEvent;
import net.citizensnpcs.api.event.CommandSenderCreateNPCEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCTeleportEvent;
import net.citizensnpcs.api.event.PlayerCloneNPCEvent;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.gui.InventoryMenu;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.trait.trait.Speech;
import net.citizensnpcs.api.util.Colorizer;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Paginator;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.commands.NPCCommandSelector;
import net.citizensnpcs.commands.gui.NPCConfigurator;
import net.citizensnpcs.commands.history.CommandHistory;
import net.citizensnpcs.commands.history.CreateNPCHistoryItem;
import net.citizensnpcs.commands.history.RemoveNPCHistoryItem;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.NPCSelector;
import net.citizensnpcs.npc.Template;
import net.citizensnpcs.trait.Age;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.ClickRedirectTrait;
import net.citizensnpcs.trait.CommandTrait;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.DropsTrait;
import net.citizensnpcs.trait.EnderCrystalTrait;
import net.citizensnpcs.trait.EndermanTrait;
import net.citizensnpcs.trait.FollowTrait;
import net.citizensnpcs.trait.GameModeTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.MountTrait;
import net.citizensnpcs.trait.OcelotModifiers;
import net.citizensnpcs.trait.Poses;
import net.citizensnpcs.trait.Powered;
import net.citizensnpcs.trait.RabbitType;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.trait.ScriptTrait;
import net.citizensnpcs.trait.SheepTrait;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.trait.SkinLayers;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.trait.SlimeSize;
import net.citizensnpcs.trait.VillagerProfession;
import net.citizensnpcs.trait.WitherTrait;
import net.citizensnpcs.trait.WolfModifiers;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.Anchor;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.StringHelper;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@Requirements(selected=true, ownership=true)
public class NPCCommands {
    private final CommandHistory history;
    private final NPCSelector selector;
    private final NPCRegistry temporaryRegistry;

    public NPCCommands(Citizens plugin) {
        this.selector = plugin.getNPCSelector();
        this.temporaryRegistry = CitizensAPI.createCitizensBackedNPCRegistry(new MemoryNPCDataStore());
        this.history = new CommandHistory(this.selector);
    }

    @Command(aliases={"npc"}, usage="age [age] (-l(ock))", desc="Set the age of a NPC", help="citizens.commands.npc.age.help", flags="l", modifiers={"age"}, min=1, max=2, permission="citizens.npc.age")
    public void age(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.isSpawned() || !(npc.getEntity() instanceof Ageable) && !(npc.getEntity() instanceof Zombie) && !npc.getEntity().getType().name().equals("TADPOLE")) {
            throw new CommandException("citizens.commands.npc.age.cannot-be-aged", npc.getName());
        }
        Age trait = npc.getOrAddTrait(Age.class);
        boolean toggleLock = args.hasFlag('l');
        if (toggleLock) {
            Messaging.sendTr(sender, trait.toggle() ? "citizens.commands.npc.age.locked" : "citizens.commands.npc.age.unlocked", new Object[0]);
        }
        if (args.argsLength() <= 1) {
            if (!toggleLock) {
                trait.describe(sender);
            }
            return;
        }
        int age = 0;
        try {
            age = args.getInteger(1);
            if (age > 0) {
                throw new CommandException("citizens.commands.npc.age.invalid-age");
            }
            Messaging.sendTr(sender, "citizens.commands.npc.age.set-normal", npc.getName(), age);
        }
        catch (NumberFormatException ex) {
            if (args.getString(1).equalsIgnoreCase("baby")) {
                age = -24000;
                Messaging.sendTr(sender, "citizens.commands.npc.age.set-baby", npc.getName());
            }
            if (args.getString(1).equalsIgnoreCase("adult")) {
                age = 0;
                Messaging.sendTr(sender, "citizens.commands.npc.age.set-adult", npc.getName());
            }
            throw new CommandException("citizens.commands.npc.age.invalid-age");
        }
        trait.setAge(age);
    }

    @Command(aliases={"npc"}, usage="ai (true|false)", desc="Sets whether the NPC should use vanilla AI", modifiers={"ai"}, min=1, max=2, permission="citizens.npc.ai")
    public void ai(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Boolean explicit) throws CommandException {
        boolean useAI = explicit == null ? !npc.useMinecraftAI() : explicit;
        npc.setUseMinecraftAI(useAI);
        Messaging.sendTr(sender, useAI ? "citizens.commands.npc.ai.started" : "citizens.commands.npc.ai.stopped", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="anchor (--save [name]|--assume [name]|--remove [name]) (-a) (-c)", desc="Changes/Saves/Lists NPC's location anchor(s)", flags="ac", modifiers={"anchor"}, min=1, max=3, permission="citizens.npc.anchor")
    public void anchor(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"save"}) String save, @Flag(value={"assume"}) String assume, @Flag(value={"remove"}) String remove) throws CommandException {
        Anchors trait = npc.getOrAddTrait(Anchors.class);
        if (save != null) {
            if (save.isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            if (args.getSenderLocation() == null) {
                throw new ServerCommandException();
            }
            if (args.hasFlag('c')) {
                if (!trait.addAnchor(save, args.getSenderTargetBlockLocation())) throw new CommandException("citizens.commands.npc.anchor.already-exists", save);
                Messaging.sendTr(sender, "citizens.commands.npc.anchor.added", new Object[0]);
            } else {
                if (!trait.addAnchor(save, args.getSenderLocation())) throw new CommandException("citizens.commands.npc.anchor.already-exists", save);
                Messaging.sendTr(sender, "citizens.commands.npc.anchor.added", new Object[0]);
            }
        } else if (assume != null) {
            if (assume.isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            Anchor anchor = trait.getAnchor(assume);
            if (anchor == null) {
                throw new CommandException("citizens.commands.npc.anchor.missing", assume);
            }
            npc.teleport(anchor.getLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
        } else if (remove != null) {
            if (remove.isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            if (!trait.removeAnchor(trait.getAnchor(remove))) throw new CommandException("citizens.commands.npc.anchor.missing", remove);
            Messaging.sendTr(sender, "citizens.commands.npc.anchor.removed", new Object[0]);
        } else if (!args.hasFlag('a')) {
            Paginator paginator = new Paginator().header("Anchors").console(sender instanceof ConsoleCommandSender);
            paginator.addLine("Key: [[ID]]  <blue>Name  <red>World  <gray>Location (X,Y,Z)");
            for (int i = 0; i < trait.getAnchors().size(); ++i) {
                if (trait.getAnchors().get(i).isLoaded()) {
                    String line = i + "<blue>  " + trait.getAnchors().get(i).getName() + "<yellow>  " + trait.getAnchors().get(i).getLocation().getWorld().getName() + "<gray>  " + trait.getAnchors().get(i).getLocation().getBlockX() + ", " + trait.getAnchors().get(i).getLocation().getBlockY() + ", " + trait.getAnchors().get(i).getLocation().getBlockZ();
                    paginator.addLine(line);
                    continue;
                }
                String[] parts = trait.getAnchors().get(i).getUnloadedValue();
                String line = i + "<blue>  " + trait.getAnchors().get(i).getName() + "<red>  " + parts[0] + "<gray>  " + parts[1] + ", " + parts[2] + ", " + parts[3] + " <white>(unloaded)";
                paginator.addLine(line);
            }
            int page = args.getInteger(1, 1);
            if (!paginator.sendPage(sender, page)) {
                throw new CommandException("citizens.commands.page-missing", page);
            }
        }
        if (!args.hasFlag('a')) {
            return;
        }
        if (sender instanceof ConsoleCommandSender) {
            throw new ServerCommandException();
        }
        npc.teleport(args.getSenderLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
    }

    @Command(aliases={"npc"}, usage="armorstand --visible [visible] --small [small] --gravity [gravity] --arms [arms] --baseplate [baseplate] --(body|leftarm|leftleg|rightarm|rightleg)pose [angle x,y,z]", desc="Edit armorstand properties", modifiers={"armorstand"}, min=1, max=1, valueFlags={"bodypose", "leftarmpose", "rightarmpose", "leftlegpose", "rightlegpose"}, permission="citizens.npc.armorstand")
    @Requirements(selected=true, ownership=true, types={EntityType.ARMOR_STAND})
    public void armorstand(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"visible"}) Boolean visible, @Flag(value={"small"}) Boolean small, @Flag(value={"gravity"}) Boolean gravity, @Flag(value={"arms"}) Boolean arms, @Flag(value={"baseplate"}) Boolean baseplate) throws CommandException {
        ArmorStandTrait trait = npc.getOrAddTrait(ArmorStandTrait.class);
        if (visible != null) {
            trait.setVisible(visible);
        }
        if (small != null) {
            trait.setSmall(small);
        }
        if (gravity != null) {
            trait.setGravity(gravity);
        }
        if (arms != null) {
            trait.setHasArms(arms);
        }
        if (baseplate != null) {
            trait.setHasBaseplate(baseplate);
        }
        ArmorStand ent = (ArmorStand)npc.getEntity();
        if (args.hasValueFlag("bodypose")) {
            ent.setBodyPose(args.parseEulerAngle(args.getFlag("bodypose")));
        }
        if (args.hasValueFlag("leftarmpose")) {
            ent.setLeftArmPose(args.parseEulerAngle(args.getFlag("leftarmpose")));
        }
        if (args.hasValueFlag("leftlegpose")) {
            ent.setLeftLegPose(args.parseEulerAngle(args.getFlag("leftlegpose")));
        }
        if (args.hasValueFlag("rightarmpose")) {
            ent.setRightArmPose(args.parseEulerAngle(args.getFlag("rightarmpose")));
        }
        if (args.hasValueFlag("rightlegpose")) {
            ent.setRightLegPose(args.parseEulerAngle(args.getFlag("rightlegpose")));
        }
    }

    @Command(aliases={"npc"}, usage="breakblock --location [x,y,z] --radius [radius]", desc="Mine a block at the given location or cursor if not specified", modifiers={"breakblock"}, min=1, max=1, valueFlags={"location"}, permission="citizens.npc.breakblock")
    @Requirements(selected=true, ownership=true, livingEntity=true)
    public void breakblock(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"radius"}) Double radius) throws CommandException {
        BlockBreaker.BlockBreakerConfiguration cfg = new BlockBreaker.BlockBreakerConfiguration();
        if (radius != null) {
            cfg.radius(radius);
        } else if (Settings.Setting.DEFAULT_BLOCK_BREAKER_RADIUS.asDouble() > 0.0) {
            cfg.radius(Settings.Setting.DEFAULT_BLOCK_BREAKER_RADIUS.asDouble());
        }
        BlockBreaker breaker = npc.getBlockBreaker(args.getSenderTargetBlockLocation().getBlock(), cfg);
        npc.getDefaultGoalController().addBehavior(StatusMapper.singleUse(breaker), 1);
    }

    @Command(aliases={"npc"}, usage="chunkload (-t(emporary))", desc="Toggle the NPC forcing chunks to stay loaded", modifiers={"chunkload", "cload"}, min=1, max=1, flags="t", permission="citizens.npc.chunkload")
    @Requirements(selected=true, ownership=true)
    public void chunkload(CommandContext args, CommandSender sender, NPC npc) {
        boolean enabled;
        boolean bl = enabled = npc.data().get("keep-chunk-loaded", Boolean.valueOf(Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean())) == false;
        if (args.hasFlag('t')) {
            npc.data().set("keep-chunk-loaded", (Object)enabled);
        } else {
            npc.data().setPersistent("keep-chunk-loaded", (Object)enabled);
        }
        Messaging.sendTr(sender, enabled ? "citizens.commands.npc.chunkload.set" : "citizens.commands.npc.chunkload.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="collidable", desc="Toggles an NPC's collidability", modifiers={"collidable", "pushable"}, min=1, max=1, permission="citizens.npc.collidable")
    @Requirements(ownership=true, selected=true)
    public void collidable(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        npc.data().setPersistent("collidable", (Object)(npc.data().get("collidable", Boolean.valueOf(false)) == false ? 1 : 0));
        Messaging.sendTr(sender, (Boolean)npc.data().get("collidable") != false ? "citizens.commands.npc.collidable.set" : "citizens.commands.npc.collidable.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="command|cmd (add [command] | remove [id] | permissions [permissions] | sequential | random | clearerror [type] (name|uuid) | errormsg [type] [msg] | (exp|item)cost [cost]) (-l[eft]/-r[ight]) (-p[layer] -o[p]), --cooldown --gcooldown [seconds] --delay [ticks] --permissions [perms] --n [max # of uses]", desc="Controls commands which will be run when clicking on an NPC", help="citizens.commands.npc.command.help", modifiers={"command", "cmd"}, min=1, flags="lrpo", permission="citizens.npc.command")
    public void command(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"permissions"}) String permissions, @Flag(value={"cooldown"}, defValue="0") int cooldown, @Flag(value={"gcooldown"}, defValue="0") int gcooldown, @Flag(value={"n"}, defValue="-1") int n, @Flag(value={"delay"}, defValue="0") int delay, @Arg(value=1, completions={"add", "remove", "permissions", "sequential", "random", "hideerrors", "errormsg", "clearerror", "expcost", "itemcost"}) String action) throws CommandException {
        CommandTrait commands = npc.getOrAddTrait(CommandTrait.class);
        if (args.argsLength() == 1) {
            commands.describe(sender);
        } else if (action.equalsIgnoreCase("add")) {
            if (args.argsLength() == 2) {
                throw new CommandUsageException();
            }
            if (args.hasFlag('o') && !sender.hasPermission("citizens.admin")) {
                throw new NoPermissionsException();
            }
            String command = args.getJoinedStrings(2);
            CommandTrait.Hand hand = args.hasFlag('l') && args.hasFlag('r') ? CommandTrait.Hand.BOTH : (args.hasFlag('l') ? CommandTrait.Hand.LEFT : CommandTrait.Hand.RIGHT);
            ArrayList perms = Lists.newArrayList();
            if (permissions != null) {
                perms.addAll(Arrays.asList(permissions.split(",")));
            }
            try {
                int id = commands.addCommand(new CommandTrait.NPCCommandBuilder(command, hand).addPerms(perms).player(args.hasFlag('p') || args.hasFlag('o')).op(args.hasFlag('o')).cooldown(cooldown).globalCooldown(gcooldown).n(n).delay(delay));
                Messaging.sendTr(sender, "citizens.commands.npc.command.command-added", command, id);
            }
            catch (NumberFormatException ex) {
                throw new CommandException("citizens.commands.invalid-number");
            }
        } else if (action.equalsIgnoreCase("clearerror")) {
            if (args.argsLength() < 3) {
                throw new CommandException("citizens.commands.npc.command.invalid-error-message", Util.listValuesPretty(CommandTrait.CommandTraitError.values()));
            }
            CommandTrait.CommandTraitError which = (CommandTrait.CommandTraitError)Util.matchEnum((Enum[])CommandTrait.CommandTraitError.values(), (String)args.getString(2));
            if (which == null) {
                throw new CommandException("citizens.commands.npc.command.invalid-error-message", Util.listValuesPretty(CommandTrait.CommandTraitError.values()));
            }
            Player player = null;
            if (args.argsLength() > 3 && (player = Bukkit.getPlayerExact((String)args.getString(3))) == null) {
                player = Bukkit.getPlayer((UUID)UUID.fromString(args.getString(3)));
            }
            commands.clearHistory(which, player);
            Messaging.send(sender, "citizens.commands.npc.command.errors-cleared", Util.prettyEnum(which));
        } else if (action.equalsIgnoreCase("sequential")) {
            commands.setExecutionMode(commands.getExecutionMode() == CommandTrait.ExecutionMode.SEQUENTIAL ? CommandTrait.ExecutionMode.LINEAR : CommandTrait.ExecutionMode.SEQUENTIAL);
            Messaging.sendTr(sender, commands.getExecutionMode() == CommandTrait.ExecutionMode.SEQUENTIAL ? "citizens.commands.npc.commands.sequential-set" : "citizens.commands.npc.commands.sequential-unset", new Object[0]);
        } else if (action.equalsIgnoreCase("remove")) {
            if (args.argsLength() == 2) {
                throw new CommandUsageException();
            }
            int id = args.getInteger(2, -1);
            if (!commands.hasCommandId(id)) {
                throw new CommandException("citizens.commands.npc.command.unknown-id", id);
            }
            commands.removeCommandById(id);
            Messaging.sendTr(sender, "citizens.commands.npc.command.command-removed", id);
        } else if (action.equalsIgnoreCase("permissions") || action.equalsIgnoreCase("perms")) {
            if (!sender.hasPermission("citizens.admin")) {
                throw new NoPermissionsException();
            }
            List<String> temporaryPermissions = Arrays.asList(args.getSlice(2));
            commands.setTemporaryPermissions(temporaryPermissions);
            Messaging.sendTr(sender, "citizens.commands.npc.command.temporary-permissions-set", Joiner.on((char)' ').join(temporaryPermissions));
        } else if (action.equalsIgnoreCase("cost")) {
            commands.setCost(args.getDouble(2));
            Messaging.sendTr(sender, "citizens.commands.npc.command.cost-set", args.getDouble(2));
        } else if (action.equalsIgnoreCase("expcost")) {
            commands.setExperienceCost((float)args.getDouble(2));
            Messaging.sendTr(sender, "citizens.commands.npc.command.experience-cost-set", args.getDouble(2));
        } else if (action.equalsIgnoreCase("hideerrors")) {
            commands.setHideErrorMessages(!commands.isHideErrorMessages());
            Messaging.sendTr(sender, commands.isHideErrorMessages() ? "citizens.commands.npc.command.hide-error-messages-set" : "citizens.commands.npc.command.hide-error-messages-unset", new Object[0]);
        } else if (action.equalsIgnoreCase("random")) {
            commands.setExecutionMode(commands.getExecutionMode() == CommandTrait.ExecutionMode.RANDOM ? CommandTrait.ExecutionMode.LINEAR : CommandTrait.ExecutionMode.RANDOM);
            Messaging.sendTr(sender, commands.getExecutionMode() == CommandTrait.ExecutionMode.RANDOM ? "citizens.commands.npc.commands.random-set" : "citizens.commands.npc.commands.random-unset", new Object[0]);
        } else if (action.equalsIgnoreCase("itemcost")) {
            if (!(sender instanceof Player)) {
                throw new CommandException("citizens.commands.requirements.must-be-ingame");
            }
            InventoryMenu.createSelfRegistered(new CommandTrait.ItemRequirementGUI(commands)).present((HumanEntity)((Player)sender));
        } else if (action.equalsIgnoreCase("errormsg")) {
            CommandTrait.CommandTraitError which = (CommandTrait.CommandTraitError)Util.matchEnum((Enum[])CommandTrait.CommandTraitError.values(), (String)args.getString(2));
            if (which == null) {
                throw new CommandException("citizens.commands.npc.command.invalid-error-message", Util.listValuesPretty(CommandTrait.CommandTraitError.values()));
            }
            commands.setCustomErrorMessage(which, args.getString(3));
        } else {
            throw new CommandUsageException();
        }
    }

    @Command(aliases={"npc"}, usage="controllable|control (-m(ount),-y,-n,-o(wner required))", desc="Toggles whether the NPC can be ridden and controlled", modifiers={"controllable", "control"}, min=1, max=1, flags="myno")
    public void controllable(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (npc.isSpawned() && !sender.hasPermission("citizens.npc.controllable." + npc.getEntity().getType().name().toLowerCase().replace("_", "")) || !sender.hasPermission("citizens.npc.controllable")) {
            throw new NoPermissionsException();
        }
        if (!npc.hasTrait(Controllable.class)) {
            npc.addTrait(new Controllable(false));
        }
        Controllable trait = npc.getOrAddTrait(Controllable.class);
        boolean enabled = trait.toggle();
        if (args.hasFlag('y')) {
            enabled = trait.setEnabled(true);
        } else if (args.hasFlag('n')) {
            enabled = trait.setEnabled(false);
        }
        trait.setOwnerRequired(args.hasFlag('o'));
        String key = enabled ? "citizens.commands.npc.controllable.set" : "citizens.commands.npc.controllable.removed";
        Messaging.sendTr(sender, key, npc.getName());
        if (enabled && args.hasFlag('m') && sender instanceof Player) {
            trait.mount((Player)sender);
        }
    }

    @Command(aliases={"npc"}, usage="copy (--name newname)", desc="Copies an NPC", modifiers={"copy"}, min=1, max=1, permission="citizens.npc.copy")
    public void copy(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"name"}) String name) throws CommandException {
        NPC copy;
        if (name == null) {
            name = npc.getFullName();
        }
        if (!(copy = npc.clone()).getFullName().equals(name)) {
            copy.setName(name);
        }
        if (copy.getOrAddTrait(Spawned.class).shouldSpawn() && args.getSenderLocation() != null) {
            Location location = args.getSenderLocation();
            location.getChunk().load();
            copy.teleport(location, PlayerTeleportEvent.TeleportCause.COMMAND);
            copy.getOrAddTrait(CurrentLocation.class).setLocation(location);
        }
        CommandSenderCreateNPCEvent event = sender instanceof Player ? new PlayerCloneNPCEvent((Player)sender, npc, copy) : new CommandSenderCloneNPCEvent(sender, npc, copy);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            event.getNPC().destroy();
            String reason = "Couldn't create NPC.";
            if (!event.getCancelReason().isEmpty()) {
                reason = reason + " Reason: " + event.getCancelReason();
            }
            throw new CommandException(reason);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.copy.copied", npc.getName());
        this.selector.select(sender, copy);
        this.history.add(sender, new CreateNPCHistoryItem(copy));
    }

    @Command(aliases={"npc"}, usage="create [name] ((-b(aby),u(nspawned),s(ilent),t(emporary)) --at [x:y:z:world] --type [type] --trait ['trait1, trait2...'] --registry [registry name])", desc="Create a new NPC", flags="bust", modifiers={"create"}, min=2, permission="citizens.npc.create")
    @Requirements
    public void create(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"at"}) Location at, @Flag(value={"type"}, defValue="PLAYER") EntityType type, @Flag(value={"trait"}) String traits, @Flag(value={"template"}) String templateName, @Flag(value={"registry"}) String registryName) throws CommandException {
        StringBuilder builder;
        Iterable parts;
        String name = Colorizer.parseColors(args.getJoinedStrings(1).trim());
        if (args.hasValueFlag("type")) {
            if (type == null) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.create.invalid-mobtype", args.getFlag("type")));
            }
            if (!EntityControllers.controllerExistsForType(type)) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.create.mobtype-missing", args.getFlag("type")));
            }
        }
        int nameLength = SpigotUtil.getMaxNameLength(type);
        if (name.length() > nameLength && Placeholders.replace(name, sender, npc).length() > nameLength) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.create.npc-name-too-long", nameLength);
            name = name.substring(0, nameLength);
        }
        if (name.length() == 0) {
            throw new CommandException();
        }
        if (!(sender.hasPermission("citizens.npc.create.*") || sender.hasPermission("citizens.npc.createall") || sender.hasPermission("citizens.npc.create." + type.name().toLowerCase().replace("_", "")))) {
            throw new NoPermissionsException();
        }
        NPCRegistry registry = CitizensAPI.getNPCRegistry();
        if (registryName != null && (registry = CitizensAPI.getNamedNPCRegistry(registryName)) == null) {
            registry = CitizensAPI.createNamedNPCRegistry(name, new MemoryNPCDataStore());
            Messaging.send(sender, "An in-memory registry has been created named [[" + name + "]].");
        }
        if (args.hasFlag('t')) {
            registry = this.temporaryRegistry;
        }
        npc = registry.createNPC(type, name);
        String msg = "Created [[" + npc.getName() + "]] (ID [[" + npc.getId() + "]])";
        int age = 0;
        if (args.hasFlag('b')) {
            age = -24000;
            msg = msg + " as a baby";
        }
        if (args.hasFlag('s')) {
            npc.data().set("silent-sounds", (Object)true);
        }
        if (!Settings.Setting.SERVER_OWNS_NPCS.asBoolean()) {
            npc.getOrAddTrait(Owner.class).setOwner(sender);
        }
        npc.getOrAddTrait(MobType.class).setType(type);
        Location spawnLoc = null;
        if (sender instanceof Player) {
            spawnLoc = args.getSenderLocation();
        } else if (sender instanceof BlockCommandSender) {
            spawnLoc = args.getSenderLocation();
        }
        CommandSenderCreateNPCEvent event = sender instanceof Player ? new PlayerCreateNPCEvent((Player)sender, npc) : new CommandSenderCreateNPCEvent(sender, npc);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            npc.destroy();
            String reason = "Couldn't create NPC.";
            if (!event.getCancelReason().isEmpty()) {
                reason = reason + " Reason: " + event.getCancelReason();
            }
            throw new CommandException(reason);
        }
        if (at != null) {
            if (!sender.hasPermission("citizens.npc.create-at-location")) {
                throw new NoPermissionsException();
            }
            spawnLoc = at;
            spawnLoc.getChunk().load();
        }
        if (spawnLoc == null) {
            npc.destroy();
            throw new CommandException("citizens.commands.npc.create.invalid-location");
        }
        if (!args.hasFlag('u')) {
            npc.spawn(spawnLoc, SpawnReason.CREATE);
        }
        if (traits != null) {
            parts = Splitter.on((char)',').trimResults().split((CharSequence)traits);
            builder = new StringBuilder();
            for (String tr : parts) {
                Object trait = CitizensAPI.getTraitFactory().getTrait(tr);
                if (trait == null) continue;
                npc.addTrait((Trait)trait);
                builder.append(StringHelper.wrap(tr) + ", ");
            }
            if (builder.length() > 0) {
                builder.delete(builder.length() - 2, builder.length());
            }
            msg = msg + " with traits " + builder.toString();
        }
        if (templateName != null) {
            parts = Splitter.on((char)',').trimResults().split((CharSequence)templateName);
            builder = new StringBuilder();
            for (String part : parts) {
                Template template = Template.byName(part);
                if (template == null) continue;
                template.apply(npc);
                builder.append(StringHelper.wrap(part) + ", ");
            }
            if (builder.length() > 0) {
                builder.delete(builder.length() - 2, builder.length());
            }
            msg = msg + " with templates " + builder.toString();
        }
        npc.getOrAddTrait(Age.class).setAge(age);
        this.selector.select(sender, npc);
        this.history.add(sender, new CreateNPCHistoryItem(npc));
        Messaging.send(sender, msg + '.');
    }

    @Command(aliases={"npc"}, usage="debug -p(aths) -n(avigation)", desc="Display debugging information", modifiers={"debug"}, min=1, max=1, flags="pn", permission="citizens.npc.debug")
    @Requirements(ownership=true, selected=true)
    public void debug(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (args.hasFlag('p')) {
            npc.getNavigator().getDefaultParameters().debug(!npc.getNavigator().getDefaultParameters().debug());
            Messaging.send(sender, "Path debugging set to " + npc.getNavigator().getDefaultParameters().debug());
        } else if (args.hasFlag('n')) {
            String output = "Use new finder [[" + npc.getNavigator().getDefaultParameters().useNewPathfinder();
            output = output + "]] distance margin [[" + npc.getNavigator().getDefaultParameters().distanceMargin() + "]] (path margin [[" + npc.getNavigator().getDefaultParameters().pathDistanceMargin() + "]])<br>";
            output = output + "Teleport if below " + npc.getNavigator().getDefaultParameters().destinationTeleportMargin() + " blocks<br>";
            output = output + "Range [[" + npc.getNavigator().getDefaultParameters().range() + "]] speed [[" + npc.getNavigator().getDefaultParameters().speed() + "]]<br>";
            output = output + "Stuck action [[" + npc.getNavigator().getDefaultParameters().stuckAction() + "]]<br>";
            Messaging.send(sender, output);
        }
    }

    @Command(aliases={"npc"}, usage="despawn (id)", desc="Despawn a NPC", modifiers={"despawn"}, min=1, max=2, permission="citizens.npc.despawn")
    @Requirements
    public void despawn(final CommandContext args, final CommandSender sender, NPC npc) throws CommandException {
        NPCCommandSelector.Callback callback = new NPCCommandSelector.Callback(){

            @Override
            public void run(NPC npc) throws CommandException {
                if (npc == null) {
                    throw new CommandException("citizens.commands.npc.spawn.missing-npc-id", args.getString(1));
                }
                npc.getOrAddTrait(Spawned.class).setSpawned(false);
                npc.despawn(DespawnReason.REMOVAL);
                Messaging.sendTr(sender, "citizens.commands.npc.despawn.despawned", npc.getName());
            }
        };
        if (npc == null || args.argsLength() == 2) {
            if (args.argsLength() < 2) {
                throw new CommandException("citizens.commands.requirements.must-have-selected");
            }
            NPCCommandSelector.startWithCallback(callback, CitizensAPI.getNPCRegistry(), sender, args, args.getString(1));
        } else {
            callback.run(npc);
        }
    }

    @Command(aliases={"npc"}, usage="drops", desc="Edit an NPC's drops", modifiers={"drops"}, min=1, max=1, permission="citizens.npc.drops")
    @Requirements(ownership=true, selected=true)
    public void drops(CommandContext args, Player sender, NPC npc) throws CommandException {
        DropsTrait trait = npc.getOrAddTrait(DropsTrait.class);
        trait.displayEditor(sender);
    }

    @Command(aliases={"npc"}, usage="endercrystal -b(ottom)", desc="Edit endercrystal modifiers", modifiers={"endercrystal"}, min=1, max=1, flags="b", permission="citizens.npc.endercrystal")
    @Requirements(ownership=true, selected=true, types={EntityType.ENDER_CRYSTAL})
    public void endercrystal(CommandContext args, Player sender, NPC npc) throws CommandException {
        if (args.hasFlag('b')) {
            EnderCrystalTrait trait = npc.getOrAddTrait(EnderCrystalTrait.class);
            boolean showing = !trait.isShowBase();
            trait.setShowBase(showing);
            Messaging.sendTr((CommandSender)sender, showing ? "citizens.commands.npc.endercrystal.showing-bottom" : "citizens.commands.npc.endercrystal.not-showing-bottom", npc.getName());
            return;
        }
        throw new CommandException();
    }

    @Command(aliases={"npc"}, usage="enderman -a(ngry)", desc="Set enderman modifiers", flags="a", modifiers={"enderman"}, min=1, max=2, permission="citizens.npc.enderman")
    public void enderman(CommandContext args, Player sender, NPC npc) throws CommandException {
        if (args.hasFlag('a')) {
            boolean angry = npc.getOrAddTrait(EndermanTrait.class).toggleAngry();
            Messaging.sendTr((CommandSender)sender, angry ? "citizens.commands.npc.enderman.angry-set" : "citizens.commands.npc.enderman.angry-unset", npc.getName());
        }
        throw new CommandUsageException();
    }

    @Command(aliases={"npc"}, usage="flyable (true|false)", desc="Toggles or sets an NPC's flyable status", modifiers={"flyable"}, min=1, max=2, permission="citizens.npc.flyable")
    @Requirements(selected=true, ownership=true, excludedTypes={EntityType.BAT, EntityType.BLAZE, EntityType.ENDER_DRAGON, EntityType.GHAST, EntityType.WITHER})
    public void flyable(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Boolean explicit) throws CommandException {
        boolean flyable = explicit != null ? explicit : !npc.isFlyable();
        npc.setFlyable(flyable);
        flyable = npc.isFlyable();
        Messaging.sendTr(sender, flyable ? "citizens.commands.npc.flyable.set" : "citizens.commands.npc.flyable.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="follow (player name|NPC id) (-p[rotect])", desc="Toggles NPC following you", flags="p", modifiers={"follow"}, min=1, max=2, permission="citizens.npc.follow")
    public void follow(CommandContext args, final Player sender, final NPC npc) throws CommandException {
        OfflinePlayer player;
        final boolean protect = args.hasFlag('p');
        String name = sender.getName();
        if (args.argsLength() > 1) {
            name = args.getString(1);
        }
        if (!(player = Bukkit.getOfflinePlayer((String)name)).hasPlayedBefore() && !player.isOnline()) {
            NPCCommandSelector.Callback callback = new NPCCommandSelector.Callback(){

                @Override
                public void run(NPC followingNPC) throws CommandException {
                    if (followingNPC == null) {
                        throw new CommandException("citizens.commands.requirements.must-have-selected");
                    }
                    if (!(sender instanceof ConsoleCommandSender) && !followingNPC.getOrAddTrait(Owner.class).isOwnedBy((CommandSender)sender)) {
                        throw new CommandException("citizens.commands.requirements.must-be-owner");
                    }
                    if (!(followingNPC.getEntity() instanceof Player)) {
                        throw new CommandException();
                    }
                    boolean following = followingNPC.getOrAddTrait(FollowTrait.class).toggle((OfflinePlayer)((Player)followingNPC.getEntity()), protect);
                    Messaging.sendTr((CommandSender)sender, following ? "citizens.commands.npc.follow.set" : "citizens.commands.npc.follow.unset", npc.getName(), followingNPC.getName());
                }
            };
            NPCCommandSelector.startWithCallback(callback, CitizensAPI.getNPCRegistry(), (CommandSender)sender, args, args.getString(1));
            return;
        }
        boolean following = npc.getOrAddTrait(FollowTrait.class).toggle(player, protect);
        Messaging.sendTr((CommandSender)sender, following ? "citizens.commands.npc.follow.set" : "citizens.commands.npc.follow.unset", npc.getName(), player.getName());
    }

    @Command(aliases={"npc"}, usage="gamemode [gamemode]", desc="Changes the gamemode", modifiers={"gamemode"}, min=1, max=2, permission="citizens.npc.gamemode")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void gamemode(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) GameMode mode) {
        Player player = (Player)npc.getEntity();
        if (args.argsLength() == 1) {
            Messaging.sendTr(sender, "citizens.commands.npc.gamemode.describe", npc.getName(), player.getGameMode().name().toLowerCase());
            return;
        }
        if (mode == null) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.gamemode.invalid", args.getString(1));
            return;
        }
        npc.getOrAddTrait(GameModeTrait.class).setGameMode(mode);
        Messaging.sendTr(sender, "citizens.commands.npc.gamemode.set", Util.prettyEnum(mode));
    }

    @Command(aliases={"npc"}, usage="glowing --color [minecraft chat color]", desc="Toggles an NPC's glowing status", modifiers={"glowing"}, min=1, max=1, permission="citizens.npc.glowing")
    @Requirements(selected=true, ownership=true)
    public void glowing(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"color"}) ChatColor color) throws CommandException {
        if (color != null) {
            npc.getOrAddTrait(ScoreboardTrait.class).setColor(color);
            if (!npc.data().has(NPC.Metadata.GLOWING)) {
                npc.data().setPersistent(NPC.Metadata.GLOWING, (Object)true);
            }
            Messaging.sendTr(sender, "citizens.commands.npc.glowing.color-set", npc.getName(), color + Util.prettyEnum(color));
            return;
        }
        npc.data().setPersistent(NPC.Metadata.GLOWING, (Object)(npc.data().get(NPC.Metadata.GLOWING, Boolean.valueOf(false)) == false ? 1 : 0));
        boolean glowing = (Boolean)npc.data().get(NPC.Metadata.GLOWING);
        Messaging.sendTr(sender, glowing ? "citizens.commands.npc.glowing.set" : "citizens.commands.npc.glowing.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="gravity", desc="Toggles gravity", modifiers={"gravity"}, min=1, max=1, permission="citizens.npc.gravity")
    public void gravity(CommandContext args, CommandSender sender, NPC npc) {
        boolean nogravity = npc.getOrAddTrait(Gravity.class).toggle();
        String key = !nogravity ? "citizens.commands.npc.gravity.enabled" : "citizens.commands.npc.gravity.disabled";
        Messaging.sendTr(sender, key, npc.getName());
    }

    @Command(aliases={"npc"}, usage="gui", desc="Display NPC configuration GUI", modifiers={"gui"}, min=1, max=1, permission="citizens.npc.gui")
    public void gui(CommandContext args, Player sender, NPC npc) {
        InventoryMenu.createSelfRegistered(new NPCConfigurator(npc)).present((HumanEntity)sender);
    }

    @Command(aliases={"npc"}, usage="hologram add [text] | set [line #] [text] | remove [line #] | clear | lineheight [height] | direction [up|down]", desc="Controls NPC hologram text", modifiers={"hologram"}, min=1, max=-1, permission="citizens.npc.hologram")
    public void hologram(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completions={"add", "set", "remove", "clear", "lineheight", "direction"}) String action) throws CommandException {
        HologramTrait trait = npc.getOrAddTrait(HologramTrait.class);
        if (args.argsLength() == 1) {
            String output = Messaging.tr("citizens.commands.npc.hologram.text-describe-header", npc.getName());
            List<String> lines = trait.getLines();
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                output = output + "<br>    [[" + i + "]] - " + line;
            }
            Messaging.send(sender, output);
            return;
        }
        if (action.equalsIgnoreCase("set")) {
            if (args.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            int idx = Math.max(0, args.getInteger(2));
            if (idx >= trait.getLines().size()) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            if (args.argsLength() == 3) {
                throw new CommandException("citizens.commands.npc.hologram.text-missing");
            }
            trait.setLine(idx, args.getJoinedStrings(3));
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.text-set", idx, args.getJoinedStrings(3));
        } else if (action.equalsIgnoreCase("add")) {
            if (args.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.text-missing");
            }
            trait.addLine(args.getJoinedStrings(2));
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.line-add", args.getJoinedStrings(2));
        } else if (action.equalsIgnoreCase("remove")) {
            if (args.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            int idx = Math.max(0, args.getInteger(2));
            if (idx >= trait.getLines().size()) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            trait.removeLine(idx);
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.line-removed", idx);
        } else if (action.equalsIgnoreCase("clear")) {
            trait.clear();
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.cleared", new Object[0]);
        } else if (action.equalsIgnoreCase("lineheight")) {
            trait.setLineHeight(args.getDouble(2));
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.line-height-set", args.getDouble(2));
        } else if (action.equalsIgnoreCase("direction")) {
            HologramTrait.HologramDirection direction = args.getString(2).equalsIgnoreCase("up") ? HologramTrait.HologramDirection.BOTTOM_UP : HologramTrait.HologramDirection.TOP_DOWN;
            trait.setDirection(direction);
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.direction-set", Util.prettyEnum(direction));
        }
    }

    @Command(aliases={"npc"}, usage="horse|donkey|mule (--color color) (--type type) (--style style) (-cb)", desc="Sets horse and horse-like entity modifiers", help="Use the -c flag to make the NPC have a chest, or the -b flag to stop them from having a chest.", modifiers={"horse", "donkey", "mule"}, min=1, max=1, flags="cb", permission="citizens.npc.horse")
    @Requirements(selected=true, ownership=true)
    public void horse(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"color", "colour"}) Horse.Color color, @Flag(value={"style"}) Horse.Style style) throws CommandException {
        EntityType type = npc.getOrAddTrait(MobType.class).getType();
        if (!Util.isHorse(type)) {
            throw new CommandException("citizens.commands.requirements.disallowed-mobtype", Util.prettyEnum(type));
        }
        HorseModifiers horse = npc.getOrAddTrait(HorseModifiers.class);
        String output = "";
        if (args.hasFlag('c')) {
            horse.setCarryingChest(true);
            output = output + Messaging.tr("citizens.commands.npc.horse.chest-set", new Object[0]) + " ";
        } else if (args.hasFlag('b')) {
            horse.setCarryingChest(false);
            output = output + Messaging.tr("citizens.commands.npc.horse.chest-unset", new Object[0]) + " ";
        }
        if (type == EntityType.HORSE && (args.hasValueFlag("color") || args.hasValueFlag("colour"))) {
            if (color == null) {
                String valid = Util.listValuesPretty(Horse.Color.values());
                throw new CommandException("citizens.commands.npc.horse.invalid-color", valid);
            }
            horse.setColor(color);
            output = output + Messaging.tr("citizens.commands.npc.horse.color-set", Util.prettyEnum(color));
        }
        if (type == EntityType.HORSE && args.hasValueFlag("style")) {
            if (style == null) {
                String valid = Util.listValuesPretty(Horse.Style.values());
                throw new CommandException("citizens.commands.npc.horse.invalid-style", valid);
            }
            horse.setStyle(style);
            output = output + Messaging.tr("citizens.commands.npc.horse.style-set", Util.prettyEnum(style));
        }
        if (output.isEmpty()) {
            Messaging.sendTr(sender, "citizens.commands.npc.horse.describe", Util.prettyEnum(horse.getColor()), Util.prettyEnum(type), Util.prettyEnum(horse.getStyle()));
        } else {
            sender.sendMessage(output);
        }
    }

    @Command(aliases={"npc"}, usage="hurt [damage]", desc="Damages the NPC", modifiers={"hurt"}, min=2, max=2, permission="citizens.npc.hurt")
    public void hurt(CommandContext args, CommandSender sender, NPC npc) {
        if (!(npc.getEntity() instanceof Damageable)) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.hurt.not-damageable", Util.prettyEnum(npc.getOrAddTrait(MobType.class).getType()));
            return;
        }
        if (npc.isProtected()) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.hurt.protected", new Object[0]);
            return;
        }
        ((Damageable)npc.getEntity()).damage((double)args.getInteger(1));
    }

    @Command(aliases={"npc"}, usage="id", desc="Sends the selected NPC's ID to the sender", modifiers={"id"}, min=1, max=1, permission="citizens.npc.id")
    public void id(CommandContext args, CommandSender sender, NPC npc) {
        Messaging.send(sender, npc.getId());
    }

    @Command(aliases={"npc"}, usage="inventory", desc="Show's an NPC's inventory", modifiers={"inventory"}, min=1, max=1, permission="citizens.npc.inventory")
    public void inventory(CommandContext args, CommandSender sender, NPC npc) {
        npc.getOrAddTrait(Inventory.class).openInventory((Player)sender);
    }

    @Command(aliases={"npc"}, usage="item [item] (data)", desc="Sets the NPC's item", modifiers={"item"}, min=2, max=3, flags="", permission="citizens.npc.item")
    @Requirements(selected=true, ownership=true, types={EntityType.DROPPED_ITEM, EntityType.ITEM_FRAME, EntityType.FALLING_BLOCK})
    public void item(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Material mat) throws CommandException {
        if (mat == null) {
            throw new CommandException("citizens.commands.npc.item.unknown-material");
        }
        int data = args.getInteger(2, 0);
        npc.data().setPersistent("item-type-id", (Object)mat.name());
        npc.data().setPersistent("item-type-data", (Object)data);
        switch (npc.getEntity().getType()) {
            case DROPPED_ITEM: {
                ((Item)npc.getEntity()).getItemStack().setType(mat);
                break;
            }
            case ITEM_FRAME: {
                ((ItemFrame)npc.getEntity()).setItem(new ItemStack(mat, 1));
                break;
            }
        }
        if (npc.isSpawned()) {
            npc.despawn(DespawnReason.PENDING_RESPAWN);
            npc.spawn(npc.getStoredLocation(), SpawnReason.RESPAWN);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.item.item-set", Util.prettyEnum(mat));
    }

    @Command(aliases={"npc"}, usage="jump", desc="Makes the NPC jump", modifiers={"jump"}, min=1, max=1, permission="citizens.npc.jump")
    public void jump(CommandContext args, CommandSender sender, NPC npc) {
        NMS.setShouldJump(npc.getEntity());
    }

    @Command(aliases={"npc"}, usage="leashable", desc="Toggles leashability", modifiers={"leashable"}, min=1, max=1, flags="t", permission="citizens.npc.leashable")
    public void leashable(CommandContext args, CommandSender sender, NPC npc) {
        boolean vulnerable;
        boolean bl = vulnerable = npc.data().get("protected-leash", Boolean.valueOf(true)) == false;
        if (args.hasFlag('t')) {
            npc.data().set("protected-leash", (Object)vulnerable);
        } else {
            npc.data().setPersistent("protected-leash", (Object)vulnerable);
        }
        String key = vulnerable ? "citizens.commands.npc.leashable.stopped" : "citizens.commands.npc.leashable.set";
        Messaging.sendTr(sender, key, npc.getName());
    }

    @Command(aliases={"npc"}, usage="list (page) ((-a) --owner (owner) --type (type) --char (char) --registry (name))", desc="List NPCs", flags="a", modifiers={"list"}, min=1, max=2, permission="citizens.npc.list")
    @Requirements
    public void list(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"owner"}) String owner, @Flag(value={"type"}) EntityType type, @Flag(value={"page"}) Integer page, @Flag(value={"registry"}) String registry) throws CommandException {
        int op;
        NPCRegistry source;
        NPCRegistry nPCRegistry = source = registry != null ? CitizensAPI.getNamedNPCRegistry(registry) : CitizensAPI.getNPCRegistry();
        if (source == null) {
            throw new CommandException();
        }
        ArrayList<NPC> npcs = new ArrayList<NPC>();
        if (args.hasFlag('a')) {
            for (NPC add : source.sorted()) {
                npcs.add(add);
            }
        } else if (owner != null) {
            for (NPC add : source.sorted()) {
                if (npcs.contains(add) || !add.getOrAddTrait(Owner.class).isOwnedBy(owner)) continue;
                npcs.add(add);
            }
        } else if (sender instanceof Player) {
            for (NPC add : source.sorted()) {
                if (npcs.contains(add) || !add.getOrAddTrait(Owner.class).isOwnedBy(sender)) continue;
                npcs.add(add);
            }
        }
        if (args.hasValueFlag("type")) {
            if (type == null) {
                throw new CommandException("citizens.commands.invalid-mobtype", type);
            }
            Iterator iterator = npcs.iterator();
            while (iterator.hasNext()) {
                if (((NPC)iterator.next()).getOrAddTrait(MobType.class).getType() == type) continue;
                iterator.remove();
            }
        }
        Paginator paginator = new Paginator().header("NPCs").console(sender instanceof ConsoleCommandSender).enablePageSwitcher('/' + args.getRawCommand() + " --page $page");
        for (int i = 0; i < npcs.size(); ++i) {
            int id = ((NPC)npcs.get(i)).getId();
            String line = StringHelper.wrap(id) + " " + ((NPC)npcs.get(i)).getName() + " (<click:run_command:/npc tp --id " + id + "><hover:show_text:Teleport to this NPC>[[tp]]</hover></click>) (<click:run_command:/npc tph --id " + id + "><hover:show_text:Teleport NPC to me>[[summon]]</hover></click>) (<click:run_command:/npc remove " + id + "><hover:show_text:Remove this NPC><red>-</red></hover></click>)";
            paginator.addLine(line);
        }
        int n = op = page == null ? args.getInteger(1, 1) : page.intValue();
        if (!paginator.sendPage(sender, op)) {
            throw new CommandException("citizens.commands.page-missing", op);
        }
    }

    @Command(aliases={"npc"}, usage="lookclose --range [range] -r[ealistic looking] --randomlook [true|false] --randomswitchtargets [true|false] --randompitchrange [min,max] --randomyawrange [min,max] --disablewhennavigating [true|false]", desc="Toggle whether a NPC will look when a player is near", modifiers={"lookclose", "look", "rotate"}, min=1, max=1, flags="r", permission="citizens.npc.lookclose")
    public void lookClose(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"randomlook", "rlook"}) Boolean randomlook, @Flag(value={"range"}) Double range, @Flag(value={"randomlookdelay"}) Integer randomLookDelay, @Flag(value={"randomyawrange"}) String randomYaw, @Flag(value={"randompitchrange"}) String randomPitch, @Flag(value={"randomswitchtargets"}) Boolean randomSwitchTargets, @Flag(value={"disablewhennavigating"}) Boolean disableWhenNavigating) throws CommandException {
        float max;
        float min;
        String[] parts;
        boolean toggle = true;
        LookClose trait = npc.getOrAddTrait(LookClose.class);
        if (randomlook != null) {
            trait.setRandomLook(randomlook);
            Messaging.sendTr(sender, randomlook != false ? "citizens.commands.npc.lookclose.random-set" : "citizens.commands.npc.lookclose.random-stopped", npc.getName());
            toggle = false;
        }
        if (randomSwitchTargets != null) {
            trait.setRandomlySwitchTargets(randomSwitchTargets);
            Messaging.sendTr(sender, randomSwitchTargets != false ? "citizens.commands.npc.lookclose.random-target-switch-enabled" : "citizens.commands.npc.lookclose.random-target-switch-disabled", npc.getName());
            toggle = false;
        }
        if (disableWhenNavigating != null) {
            trait.setDisableWhileNavigating(disableWhenNavigating);
            Messaging.sendTr(sender, disableWhenNavigating != false ? "citizens.commands.npc.lookclose.disable-when-navigating" : "citizens.commands.npc.lookclose.enable-when-navigating", npc.getName());
            toggle = false;
        }
        if (range != null) {
            trait.setRange(range);
            Messaging.sendTr(sender, "citizens.commands.npc.lookclose.range-set", range);
            toggle = false;
        }
        if (args.hasFlag('r')) {
            trait.setRealisticLooking(!trait.useRealisticLooking());
            Messaging.sendTr(sender, trait.useRealisticLooking() ? "citizens.commands.npc.lookclose.rl-set" : "citizens.commands.npc.lookclose.rl-unset", npc.getName());
            toggle = false;
        }
        if (randomLookDelay != null) {
            trait.setRandomLookDelay(Math.max(1, randomLookDelay));
            Messaging.sendTr(sender, "citizens.commands.npc.lookclose.random-look-delay-set", npc.getName(), randomLookDelay);
            toggle = false;
        }
        if (randomPitch != null) {
            try {
                parts = randomPitch.split(",");
                min = Float.parseFloat(parts[0]);
                max = Float.parseFloat(parts[1]);
                if (min > max) {
                    throw new IllegalArgumentException();
                }
                trait.setRandomLookPitchRange(min, max);
            }
            catch (Exception e) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.lookclose.error-random-range", randomPitch));
            }
            Messaging.sendTr(sender, "citizens.commands.npc.lookclose.random-pitch-range-set", npc.getName(), randomPitch);
            toggle = false;
        }
        if (randomYaw != null) {
            try {
                parts = randomYaw.split(",");
                min = Float.parseFloat(parts[0]);
                max = Float.parseFloat(parts[1]);
                if (min > max) {
                    throw new IllegalArgumentException();
                }
                trait.setRandomLookYawRange(min, max);
            }
            catch (Exception e) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.lookclose.error-random-range", randomYaw));
            }
            Messaging.sendTr(sender, "citizens.commands.npc.lookclose.random-yaw-range-set", npc.getName(), randomYaw);
            toggle = false;
        }
        if (toggle) {
            Messaging.sendTr(sender, trait.toggle() ? "citizens.commands.npc.lookclose.set" : "citizens.commands.npc.lookclose.stopped", npc.getName());
        }
    }

    @Command(aliases={"npc"}, usage="metadata set|get|remove [key] (value) (-t(emporary))", desc="Manages NPC metadata", modifiers={"metadata"}, flags="t", min=3, max=4, permission="citizens.npc.metadata")
    @Requirements(selected=true, ownership=true)
    public void metadata(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completions={"set", "get", "remove"}) String command) throws CommandException {
        String key = args.getString(2);
        try {
            key = NPC.Metadata.valueOf(key.toUpperCase()).getKey();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (command.equals("set")) {
            if (args.argsLength() != 4) {
                throw new CommandException();
            }
            Object metadata = args.getString(3);
            if (metadata.equals("false") || metadata.equals("true")) {
                metadata = Boolean.parseBoolean(args.getString(3));
            }
            try {
                metadata = Integer.parseInt(args.getString(3));
            }
            catch (NumberFormatException nfe) {
                try {
                    metadata = Double.parseDouble(args.getString(3));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (args.hasFlag('t')) {
                npc.data().set(key, metadata);
            } else {
                npc.data().setPersistent(key, metadata);
            }
            Messaging.sendTr(sender, "citizens.commands.npc.metadata.set", key, args.getString(3));
        } else if (command.equals("get")) {
            if (args.argsLength() != 3) {
                throw new CommandException();
            }
            sender.sendMessage(npc.data().get(key, "null"));
        } else if (command.equals("remove")) {
            if (args.argsLength() != 3) {
                throw new CommandException();
            }
            npc.data().remove(key);
            Messaging.sendTr(sender, "citizens.commands.npc.metadata.unset", key, npc.getName());
        } else {
            throw new CommandUsageException();
        }
    }

    @Command(aliases={"npc"}, usage="minecart (--item item_name(:data)) (--offset offset)", desc="Sets minecart item", modifiers={"minecart"}, min=1, max=1, flags="", permission="citizens.npc.minecart")
    @Requirements(selected=true, ownership=true, types={EntityType.MINECART, EntityType.MINECART_CHEST, EntityType.MINECART_COMMAND, EntityType.MINECART_FURNACE, EntityType.MINECART_HOPPER, EntityType.MINECART_MOB_SPAWNER, EntityType.MINECART_TNT})
    public void minecart(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"item"}) String item) throws CommandException {
        if (item != null) {
            Material material;
            int data = 0;
            if (item.contains(":")) {
                int dataIndex = item.indexOf(58);
                data = Integer.parseInt(item.substring(dataIndex + 1));
                item = item.substring(0, dataIndex);
            }
            if ((material = Material.matchMaterial((String)item)) == null) {
                throw new CommandException();
            }
            npc.data().setPersistent("minecart-item-name", (Object)material.name());
            npc.data().setPersistent("minecart-item-data", (Object)data);
        }
        if (args.hasValueFlag("offset")) {
            npc.data().setPersistent("minecart-item-offset", (Object)args.getFlagInteger("offset"));
        }
        Messaging.sendTr(sender, "citizens.commands.npc.minecart.set", npc.data().get("minecart-item-name", ""), npc.data().get("minecart-item-data", Integer.valueOf(0)), npc.data().get("minecart-item-offset", Integer.valueOf(0)));
    }

    @Command(aliases={"npc"}, usage="mount (--onnpc <npc id>) (-c (ancel))", desc="Mounts a controllable NPC", modifiers={"mount"}, min=1, max=1, flags="c", permission="citizens.npc.mount")
    public void mount(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"onnpc"}) String onnpc) throws CommandException {
        boolean enabled;
        if (onnpc != null) {
            NPC mount;
            try {
                UUID uuid = UUID.fromString(onnpc);
                mount = CitizensAPI.getNPCRegistry().getByUniqueId(uuid);
            }
            catch (IllegalArgumentException ex) {
                mount = CitizensAPI.getNPCRegistry().getById(args.getFlagInteger("onnpc"));
            }
            if (mount == null || !mount.isSpawned()) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.mount.must-be-spawned", onnpc));
            }
            if (mount.equals(npc)) {
                throw new CommandException("citizens.commands.npc.mount.mount-on-itself");
            }
            NMS.mount(mount.getEntity(), npc.getEntity());
            return;
        }
        if (args.hasFlag('c')) {
            npc.getOrAddTrait(MountTrait.class).unmount();
            return;
        }
        boolean bl = enabled = npc.hasTrait(Controllable.class) && npc.getOrAddTrait(Controllable.class).isEnabled();
        if (!enabled) {
            Messaging.sendTr(sender, "citizens.commands.npc.controllable.not-controllable", npc.getName());
            return;
        }
        if (!(sender instanceof Player)) {
            throw new CommandException("citizens.commands.requirements.must-be-ingame");
        }
        Player player = (Player)sender;
        boolean success = npc.getOrAddTrait(Controllable.class).mount(player);
        if (!success) {
            Messaging.sendTr((CommandSender)player, "citizens.commands.npc.mount.failed", npc.getName());
        }
    }

    @Command(aliases={"npc"}, usage="moveto x:y:z:world | x y z world", desc="Teleports a NPC to a given location", modifiers={"moveto"}, min=1, valueFlags={"x", "y", "z", "yaw", "pitch", "world"}, permission="citizens.npc.moveto")
    public void moveto(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Location to;
        if (!npc.isSpawned()) {
            npc.spawn(npc.getOrAddTrait(CurrentLocation.class).getLocation(), SpawnReason.COMMAND);
        }
        if (!npc.isSpawned()) {
            throw new CommandException("NPC could not be spawned.");
        }
        Location current = npc.getEntity().getLocation();
        if (args.argsLength() > 1) {
            World world;
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').split((CharSequence)args.getJoinedStrings(1, ':')), String.class);
            if (parts.length != 4 && parts.length != 3) {
                throw new CommandException("citizens.commands.npc.moveto.format");
            }
            double x = Double.parseDouble(parts[0]);
            double y = Double.parseDouble(parts[1]);
            double z = Double.parseDouble(parts[2]);
            World world2 = world = parts.length == 4 ? Bukkit.getWorld((String)parts[3]) : current.getWorld();
            if (world == null) {
                throw new CommandException("citizens.commands.errors.missing-world");
            }
            to = new Location(world, x, y, z, current.getYaw(), current.getPitch());
        } else {
            to = current.clone();
            if (args.hasValueFlag("x")) {
                to.setX(args.getFlagDouble("x"));
            }
            if (args.hasValueFlag("y")) {
                to.setY(args.getFlagDouble("y"));
            }
            if (args.hasValueFlag("z")) {
                to.setZ(args.getFlagDouble("z"));
            }
            if (args.hasValueFlag("yaw")) {
                to.setYaw((float)args.getFlagDouble("yaw"));
            }
            if (args.hasValueFlag("pitch")) {
                to.setPitch((float)args.getFlagDouble("pitch"));
            }
            if (args.hasValueFlag("world")) {
                World world = Bukkit.getWorld((String)args.getFlag("world"));
                if (world == null) {
                    throw new CommandException("citizens.commands.errors.missing-world");
                }
                to.setWorld(world);
            }
        }
        npc.teleport(to, PlayerTeleportEvent.TeleportCause.COMMAND);
        NMS.look(npc.getEntity(), to.getYaw(), to.getPitch());
        Messaging.sendTr(sender, "citizens.commands.npc.moveto.teleported", npc.getName(), Util.prettyPrintLocation(to));
    }

    @Command(aliases={"npc"}, modifiers={"name", "hidename"}, usage="name (-h(over))", desc="Toggle nameplate visibility, or only show names on hover", min=1, max=1, flags="h", permission="citizens.npc.name")
    @Requirements(selected=true, ownership=true)
    public void name(CommandContext args, CommandSender sender, NPC npc) {
        String old = ((Object)npc.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString();
        old = args.hasFlag('h') ? "hover" : (old.equals("hover") ? "true" : "" + !Boolean.parseBoolean(old));
        npc.data().setPersistent(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)old);
        Messaging.sendTr(sender, "citizens.commands.npc.nameplate.set", old);
    }

    @Command(aliases={"npc"}, desc="Show basic NPC information", max=0, permission="citizens.npc.info")
    public void npc(CommandContext args, CommandSender sender, NPC npc) {
        Messaging.send(sender, StringHelper.wrapHeader(npc.getName()));
        Messaging.send(sender, "    ID: [[" + npc.getId());
        EntityType type = npc.getOrAddTrait(MobType.class).getType();
        Messaging.send(sender, "    UUID: [[" + npc.getUniqueId() + (npc.isSpawned() && type == EntityType.PLAYER ? "(v4)" : ""));
        Messaging.send(sender, "    Type: [[" + type);
        if (npc.isSpawned()) {
            Location loc = npc.getEntity().getLocation();
            String format = "    Spawned at [[%d, %d, %d]] in world [[%s";
            Messaging.send(sender, String.format(format, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), loc.getWorld().getName()));
        }
        Messaging.send(sender, "    Traits");
        for (Trait trait : npc.getTraits()) {
            if (CitizensAPI.getTraitFactory().isInternalTrait(trait)) continue;
            String message = "     [[- ]]" + trait.getName();
            Messaging.send(sender, message);
        }
    }

    @Command(aliases={"npc"}, usage="ocelot (--type type) (-s(itting), -n(ot sitting))", desc="Set the ocelot type of an NPC and whether it is sitting", modifiers={"ocelot"}, min=1, max=1, requiresFlags=true, flags="sn", permission="citizens.npc.ocelot")
    @Requirements(selected=true, ownership=true, types={EntityType.OCELOT})
    public void ocelot(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"type"}) Ocelot.Type type) throws CommandException {
        OcelotModifiers trait = npc.getOrAddTrait(OcelotModifiers.class);
        if (args.hasFlag('s')) {
            trait.setSitting(true);
        } else if (args.hasFlag('n')) {
            trait.setSitting(false);
        }
        if (args.hasValueFlag("type")) {
            if (type == null) {
                String valid = Util.listValuesPretty(Ocelot.Type.values());
                throw new CommandException("citizens.commands.npc.ocelot.invalid-type", valid);
            }
            trait.setType(type);
            if (!trait.supportsOcelotType()) {
                Messaging.sendErrorTr(sender, "citizens.commands.npc.ocelot.deprecated", new Object[0]);
            }
        }
    }

    @Command(aliases={"npc"}, usage="owner [uuid|SERVER]", desc="Set the owner of an NPC", modifiers={"owner"}, min=1, max=2, permission="citizens.npc.owner")
    public void owner(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        OfflinePlayer p;
        Owner ownerTrait = npc.getOrAddTrait(Owner.class);
        if (args.argsLength() == 1) {
            Messaging.sendTr(sender, "citizens.commands.npc.owner.owner", npc.getName(), ownerTrait.getOwnerId());
            return;
        }
        UUID uuid = args.getString(1).equalsIgnoreCase("SERVER") ? null : ((p = Bukkit.getOfflinePlayer((String)args.getString(1))).hasPlayedBefore() || p.isOnline() ? p.getUniqueId() : UUID.fromString(args.getString(1)));
        if (ownerTrait.isOwnedBy(uuid)) {
            throw new CommandException("citizens.commands.npc.owner.already-owner", uuid, npc.getName());
        }
        ownerTrait.setOwner(uuid);
        boolean serverOwner = uuid == null;
        Messaging.sendTr(sender, serverOwner ? "citizens.commands.npc.owner.set-server" : "citizens.commands.npc.owner.set", npc.getName(), uuid);
    }

    @Command(aliases={"npc"}, usage="passive (--set [true|false])", desc="Sets whether an NPC damages other entities or not", modifiers={"passive"}, min=1, max=1, permission="citizens.npc.passive")
    public void passive(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"set"}) Boolean set) throws CommandException {
        boolean passive = set != null ? set : npc.data().get("damage-others", Boolean.valueOf(true)) == false;
        npc.data().setPersistent("damage-others", (Object)passive);
        Messaging.sendTr(sender, passive ? "citizens.commands.npc.passive.set" : "citizens.commands.npc.passive.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="pathopt --avoid-water|aw [true|false] --stationary-ticks [ticks] --attack-range [range] --distance-margin [margin] --path-distance-margin [margin] --use-new-finder [true|false]", desc="Sets an NPC's pathfinding options", modifiers={"pathopt", "po", "patho"}, min=1, max=1, permission="citizens.npc.pathfindingoptions")
    public void pathfindingOptions(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"avoid-water"}) Boolean avoidwater, @Flag(value={"stationary-ticks"}) Integer stationaryTicks, @Flag(value={"distance-margin"}) Double distanceMargin, @Flag(value={"path-distance-margin"}) Double pathDistanceMargin, @Flag(value={"attack-range"}) Double attackRange, @Flag(value={"use-new-finder"}) Boolean useNewFinder) throws CommandException {
        String output = "";
        if (avoidwater != null) {
            npc.getNavigator().getDefaultParameters().avoidWater(avoidwater);
            output = output + Messaging.tr(avoidwater != false ? "citizens.commands.npc.pathopt.avoid-water-set" : "citizens.commands.npc.pathopt.avoid-water-unset", npc.getName());
        }
        if (stationaryTicks != null) {
            if (stationaryTicks < 0) {
                throw new CommandUsageException();
            }
            npc.getNavigator().getDefaultParameters().stationaryTicks(stationaryTicks);
            output = output + Messaging.tr("citizens.commands.npc.pathopt.stationary-ticks-set", npc.getName(), stationaryTicks);
        }
        if (distanceMargin != null) {
            if (distanceMargin < 0.0) {
                throw new CommandUsageException();
            }
            npc.getNavigator().getDefaultParameters().distanceMargin(distanceMargin);
            output = output + Messaging.tr("citizens.commands.npc.pathopt.distance-margin-set", npc.getName(), distanceMargin);
        }
        if (pathDistanceMargin != null) {
            if (pathDistanceMargin < 0.0) {
                throw new CommandUsageException();
            }
            npc.getNavigator().getDefaultParameters().pathDistanceMargin(pathDistanceMargin);
            output = output + Messaging.tr("citizens.commands.npc.pathopt.path-distance-margin-set", npc.getName(), pathDistanceMargin);
        }
        if (attackRange != null) {
            if (attackRange < 0.0) {
                throw new CommandUsageException();
            }
            npc.getNavigator().getDefaultParameters().attackRange(attackRange);
            output = output + Messaging.tr("citizens.commands.npc.pathopt.attack-range-set", npc.getName(), attackRange);
        }
        if (useNewFinder != null) {
            npc.getNavigator().getDefaultParameters().useNewPathfinder(useNewFinder);
            output = output + Messaging.tr("citizens.commands.npc.pathopt.use-new-finder", npc.getName(), useNewFinder);
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(sender, output);
    }

    @Command(aliases={"npc"}, usage="pathrange [range]", desc="Sets an NPC's pathfinding range", modifiers={"pathrange", "pathfindingrange", "prange"}, min=2, max=2, permission="citizens.npc.pathfindingrange")
    public void pathfindingRange(CommandContext args, CommandSender sender, NPC npc) {
        double range = Math.max(1.0, args.getDouble(1));
        npc.getNavigator().getDefaultParameters().range((float)range);
        Messaging.sendTr(sender, "citizens.commands.npc.pathfindingrange.set", range);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="pathto me | here | cursor | [x] [y] [z]", desc="Starts pathfinding to a certain location", modifiers={"pathto"}, min=2, max=4, permission="citizens.npc.pathto")
    public void pathto(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completions={"me", "here", "cursor"}) String option) throws CommandException {
        Location loc = npc.getStoredLocation();
        if (args.argsLength() == 2) {
            if (option.equalsIgnoreCase("me") || option.equalsIgnoreCase("here")) {
                loc = args.getSenderLocation();
            } else {
                if (!option.equalsIgnoreCase("cursor")) throw new CommandUsageException();
                loc = ((Player)sender).getTargetBlockExact(32).getLocation();
            }
        } else {
            loc.setX(args.getDouble(1));
            loc.setY(args.getDouble(2));
            loc.setZ(args.getDouble(3));
        }
        npc.getNavigator().setTarget(loc);
    }

    @Command(aliases={"npc"}, usage="pickupitems (--set [true|false])", desc="Allow NPC to pick up items", modifiers={"pickupitems"}, min=1, max=1, permission="citizens.npc.pickupitems")
    public void pickupitems(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"set"}) Boolean set) throws CommandException {
        boolean pickup = set == null ? !npc.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(!npc.isProtected())).booleanValue() : set;
        npc.data().setPersistent(NPC.Metadata.PICKUP_ITEMS, (Object)pickup);
        Messaging.sendTr(sender, pickup ? "citizens.commands.npc.pickupitems.set" : "citizens.commands.npc.pickupitems.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="panimate [animation]", desc="Plays a player animation", modifiers={"panimate"}, min=2, max=2, permission="citizens.npc.panimate")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void playerAnimate(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) PlayerAnimation animation) throws CommandException {
        if (animation == null) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.panimate.unknown-animation", Util.listValuesPretty(PlayerAnimation.values()));
            return;
        }
        animation.play((Player)npc.getEntity(), 64);
    }

    @Command(aliases={"npc"}, usage="playerlist (-a,r)", desc="Sets whether the NPC is put in the playerlist", modifiers={"playerlist"}, min=1, max=1, flags="ar", permission="citizens.npc.playerlist")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void playerlist(CommandContext args, CommandSender sender, NPC npc) {
        boolean remove;
        boolean bl = remove = npc.data().get("removefromplayerlist", Boolean.valueOf(Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean())) == false;
        if (args.hasFlag('a')) {
            remove = false;
        } else if (args.hasFlag('r')) {
            remove = true;
        }
        npc.data().setPersistent("removefromplayerlist", (Object)remove);
        if (npc.isSpawned()) {
            npc.despawn(DespawnReason.PENDING_RESPAWN);
            npc.spawn(npc.getOrAddTrait(CurrentLocation.class).getLocation(), SpawnReason.RESPAWN);
            NMS.addOrRemoveFromPlayerList(npc.getEntity(), remove);
        }
        Messaging.sendTr(sender, remove ? "citizens.commands.npc.playerlist.removed" : "citizens.commands.npc.playerlist.added", npc.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="pose (--save [name] (-d) | --mirror [name] (-d) | --assume [name] | --remove [name] | --default [name]) (-a)", desc="Manage NPC poses", flags="ad", modifiers={"pose"}, min=1, max=2, permission="citizens.npc.pose")
    public void pose(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"save"}) String save, @Flag(value={"mirror"}) String mirror, @Flag(value={"assume"}) String assume, @Flag(value={"remove"}) String remove, @Flag(value={"default"}) String defaultPose) throws CommandException {
        Poses trait = npc.getOrAddTrait(Poses.class);
        if (save != null) {
            if (save.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (args.getSenderLocation() == null) {
                throw new ServerCommandException();
            }
            if (!trait.addPose(save, npc.getStoredLocation(), args.hasFlag('d'))) throw new CommandException("citizens.commands.npc.pose.already-exists", save);
            Messaging.sendTr(sender, "citizens.commands.npc.pose.added", new Object[0]);
        } else if (mirror != null) {
            if (mirror.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (args.getSenderLocation() == null) {
                throw new ServerCommandException();
            }
            if (!trait.addPose(mirror, npc.getStoredLocation(), args.hasFlag('d'))) throw new CommandException("citizens.commands.npc.pose.already-exists", mirror);
            Messaging.sendTr(sender, "citizens.commands.npc.pose.added", new Object[0]);
        } else if (defaultPose != null) {
            if (!trait.hasPose(defaultPose)) {
                throw new CommandException("citizens.commands.npc.pose.missing", defaultPose);
            }
            trait.setDefaultPose(defaultPose);
            Messaging.sendTr(sender, "citizens.commands.npc.pose.default-pose-set", defaultPose);
        } else if (assume != null) {
            if (assume.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (!trait.hasPose(assume)) {
                throw new CommandException("citizens.commands.npc.pose.missing", assume);
            }
            trait.assumePose(assume);
        } else if (remove != null) {
            if (remove.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (!trait.removePose(remove)) throw new CommandException("citizens.commands.npc.pose.missing", remove);
            Messaging.sendTr(sender, "citizens.commands.npc.pose.removed", new Object[0]);
        } else if (!args.hasFlag('a')) {
            trait.describe(sender, args.getInteger(1, 1));
        }
        if (!args.hasFlag('a')) {
            return;
        }
        if (args.getSenderLocation() == null) {
            throw new ServerCommandException();
        }
        trait.assumePose(args.getSenderLocation());
    }

    @Command(aliases={"npc"}, usage="power", desc="Toggle a creeper NPC as powered", modifiers={"power"}, min=1, max=1, permission="citizens.npc.power")
    @Requirements(selected=true, ownership=true, types={EntityType.CREEPER})
    public void power(CommandContext args, CommandSender sender, NPC npc) {
        Messaging.sendTr(sender, npc.getOrAddTrait(Powered.class).toggle() ? "citizens.commands.npc.powered.set" : "citizens.commands.npc.powered.stopped", new Object[0]);
    }

    @Command(aliases={"npc"}, usage="profession|prof [profession]", desc="Set a NPC's profession", modifiers={"profession", "prof"}, min=2, max=2, permission="citizens.npc.profession")
    @Requirements(selected=true, ownership=true)
    public void profession(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Villager.Profession parsed) throws CommandException {
        EntityType type = npc.getOrAddTrait(MobType.class).getType();
        if (type != EntityType.VILLAGER && !type.name().equals("ZOMBIE_VILLAGER")) {
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.disallowed-mobtype", type.name().toLowerCase().replace('_', ' ')));
        }
        if (parsed == null) {
            throw new CommandException("citizens.commands.npc.profession.invalid-profession", args.getString(1), Util.listValuesPretty(Villager.Profession.values()));
        }
        npc.getOrAddTrait(VillagerProfession.class).setProfession(parsed);
        Messaging.sendTr(sender, "citizens.commands.npc.profession.set", npc.getName(), Util.prettyEnum(parsed));
    }

    @Command(aliases={"npc"}, usage="rabbittype [type]", desc="Set the Type of a Rabbit NPC", modifiers={"rabbittype", "rbtype"}, min=2, permission="citizens.npc.rabbittype")
    @Requirements(selected=true, ownership=true, types={EntityType.RABBIT})
    public void rabbitType(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Rabbit.Type type) throws CommandException {
        if (type == null) {
            throw new CommandException("citizens.commands.npc.rabbittype.invalid-type", Util.listValuesPretty(Rabbit.Type.values()));
        }
        npc.getOrAddTrait(RabbitType.class).setType(type);
        Messaging.sendTr(sender, "citizens.commands.npc.rabbittype.type-set", npc.getName(), type.name());
    }

    @Command(aliases={"npc"}, usage="remove|rem (all|id|name| --owner [owner] | --eid [entity uuid] | --world [world])", desc="Remove a NPC", modifiers={"remove", "rem"}, min=1, max=2)
    @Requirements
    public void remove(CommandContext args, final CommandSender sender, NPC npc, @Flag(value={"owner"}) String owner, @Flag(value={"eid"}) UUID eid, @Flag(value={"world"}) String world, @Arg(value=1, completions={"all"}) String action) throws CommandException {
        if (owner != null) {
            Player playerOwner = Bukkit.getPlayerExact((String)owner);
            for (NPC rem : Lists.newArrayList((Iterable)CitizensAPI.getNPCRegistry())) {
                if (!rem.getOrAddTrait(Owner.class).isOwnedBy(sender)) continue;
                if (playerOwner != null && rem.getOrAddTrait(Owner.class).isOwnedBy((CommandSender)playerOwner)) {
                    this.history.add(sender, new RemoveNPCHistoryItem(rem));
                    rem.destroy(sender);
                    continue;
                }
                if (!rem.getOrAddTrait(Owner.class).isOwnedBy(owner)) continue;
                this.history.add(sender, new RemoveNPCHistoryItem(rem));
                rem.destroy(sender);
            }
            Messaging.sendTr(sender, "citizens.commands.npc.remove.npcs-removed", new Object[0]);
            return;
        }
        if (world != null) {
            for (NPC rem : Lists.newArrayList((Iterable)CitizensAPI.getNPCRegistry())) {
                Location loc = rem.getStoredLocation();
                if (loc == null || !rem.getOrAddTrait(Owner.class).isOwnedBy(sender) || loc.getWorld() == null || !loc.getWorld().getUID().toString().equals(world) && !loc.getWorld().getName().equalsIgnoreCase(world)) continue;
                this.history.add(sender, new RemoveNPCHistoryItem(rem));
                rem.destroy(sender);
            }
            Messaging.sendTr(sender, "citizens.commands.npc.remove.npcs-removed", new Object[0]);
            return;
        }
        if (eid != null) {
            Entity entity = Bukkit.getServer().getEntity(eid);
            if (entity != null && (npc = CitizensAPI.getNPCRegistry().getNPC(entity)) != null && npc.getOrAddTrait(Owner.class).isOwnedBy(sender)) {
                this.history.add(sender, new RemoveNPCHistoryItem(npc));
                npc.destroy(sender);
                Messaging.sendTr(sender, "citizens.commands.npc.remove.removed", npc.getName(), npc.getId());
                return;
            }
            Messaging.sendErrorTr(sender, "citizens.notifications.npc-not-found", new Object[0]);
            return;
        }
        if (args.argsLength() == 2) {
            if ("all".equalsIgnoreCase(action)) {
                if (!sender.hasPermission("citizens.admin.remove.all") && !sender.hasPermission("citizens.admin")) {
                    throw new NoPermissionsException();
                }
                for (NPC rem : CitizensAPI.getNPCRegistry()) {
                    this.history.add(sender, new RemoveNPCHistoryItem(rem));
                }
                CitizensAPI.getNPCRegistry().deregisterAll();
                Messaging.sendTr(sender, "citizens.commands.npc.remove.removed-all", new Object[0]);
                return;
            }
            NPCCommandSelector.Callback callback = new NPCCommandSelector.Callback(){

                @Override
                public void run(NPC npc) throws CommandException {
                    if (npc == null) {
                        throw new CommandException("citizens.commands.requirements.must-have-selected");
                    }
                    if (!(sender instanceof ConsoleCommandSender) && !npc.getOrAddTrait(Owner.class).isOwnedBy(sender)) {
                        throw new CommandException("citizens.commands.requirements.must-be-owner");
                    }
                    if (!sender.hasPermission("citizens.npc.remove") && !sender.hasPermission("citizens.admin")) {
                        throw new NoPermissionsException();
                    }
                    NPCCommands.this.history.add(sender, new RemoveNPCHistoryItem(npc));
                    npc.destroy(sender);
                    Messaging.sendTr(sender, "citizens.commands.npc.remove.removed", npc.getName(), npc.getId());
                }
            };
            NPCCommandSelector.startWithCallback(callback, CitizensAPI.getNPCRegistry(), sender, args, args.getString(1));
            return;
        }
        if (npc == null) {
            throw new CommandException("citizens.commands.requirements.must-have-selected");
        }
        if (!(sender instanceof ConsoleCommandSender) && !npc.getOrAddTrait(Owner.class).isOwnedBy(sender)) {
            throw new CommandException("citizens.commands.requirements.must-be-owner");
        }
        if (!sender.hasPermission("citizens.npc.remove") && !sender.hasPermission("citizens.admin")) {
            throw new NoPermissionsException();
        }
        this.history.add(sender, new RemoveNPCHistoryItem(npc));
        npc.destroy(sender);
        Messaging.sendTr(sender, "citizens.commands.npc.remove.removed", npc.getName(), npc.getId());
    }

    @Command(aliases={"npc"}, usage="rename [name]", desc="Rename a NPC", modifiers={"rename"}, min=2, permission="citizens.npc.rename")
    public void rename(CommandContext args, CommandSender sender, NPC npc) {
        String oldName = npc.getName();
        String newName = Colorizer.parseColors(args.getJoinedStrings(1));
        int nameLength = SpigotUtil.getMaxNameLength(npc.getOrAddTrait(MobType.class).getType());
        if (newName.length() > nameLength && Placeholders.replace(newName, sender, npc).length() > nameLength) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.create.npc-name-too-long", nameLength);
            newName = newName.substring(0, nameLength);
        }
        npc.setName(newName);
        Messaging.sendTr(sender, "citizens.commands.npc.rename.renamed", oldName, newName);
    }

    @Command(aliases={"npc"}, usage="respawn [delay]", desc="Sets an NPC's respawn delay", modifiers={"respawn"}, min=1, max=2, permission="citizens.npc.respawn")
    public void respawn(CommandContext args, CommandSender sender, NPC npc) {
        if (args.argsLength() > 1) {
            int delay = args.getTicks(1);
            npc.data().setPersistent("respawn-delay", (Object)delay);
            Messaging.sendTr(sender, "citizens.commands.npc.respawn.delay-set", delay);
        } else {
            Messaging.sendTr(sender, "citizens.commands.npc.respawn.describe", npc.data().get("respawn-delay", Integer.valueOf(-1)));
        }
    }

    @Command(aliases={"npc"}, usage="scoreboard --addtag [tags] --removetag [tags]", desc="Controls an NPC's scoreboard", modifiers={"scoreboard"}, min=1, max=1, permission="citizens.npc.scoreboard")
    public void scoreboard(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"addtag"}) String addTag, @Flag(value={"removetag"}) String removeTag) {
        ScoreboardTrait trait = npc.getOrAddTrait(ScoreboardTrait.class);
        String output = "";
        if (addTag != null) {
            for (String tag : addTag.split(",")) {
                trait.addTag(tag);
            }
            output = output + " " + Messaging.tr("citizens.commands.npc.scoreboard.added-tags", addTag);
        }
        if (removeTag != null) {
            for (String tag : removeTag.split(",")) {
                trait.removeTag(tag);
            }
            output = output + " " + Messaging.tr("citizens.commands.npc.scoreboard.removed-tags", removeTag);
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output.trim());
        }
    }

    @Command(aliases={"npc"}, usage="script --add [files] --remove [files]", desc="Controls an NPC's scripts", modifiers={"script"}, min=1, max=1, permission="citizens.npc.script")
    public void script(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"add"}) String add, @Flag(value={"remove"}) String remove) {
        ScriptTrait trait = npc.getOrAddTrait(ScriptTrait.class);
        if (add != null) {
            ArrayList<String> files = new ArrayList<String>();
            for (String file : add.split(",")) {
                if (!trait.validateFile(file)) {
                    Messaging.sendErrorTr(sender, "citizens.commands.npc.script.invalid-file", file);
                    return;
                }
                files.add(file);
            }
            trait.addScripts(files);
        }
        if (remove != null) {
            trait.removeScripts(Arrays.asList(remove.split(",")));
        }
        Messaging.sendTr(sender, "citizens.commands.npc.script.current-scripts", npc.getName(), Joiner.on((String)"]],[[ ").join(trait.getScripts()));
    }

    @Command(aliases={"npc"}, usage="select|sel [id|name] (--r range) (--registry [name])", desc="Select a NPC with the given ID or name", modifiers={"select", "sel"}, min=1, max=2, permission="citizens.npc.select")
    @Requirements
    public void select(CommandContext args, final CommandSender sender, final NPC npc, @Flag(value={"range"}, defValue="10") double range, @Flag(value={"registry"}) String registryName) throws CommandException {
        NPCRegistry registry;
        NPCCommandSelector.Callback callback = new NPCCommandSelector.Callback(){

            @Override
            public void run(NPC toSelect) throws CommandException {
                if (toSelect == null) {
                    throw new CommandException("citizens.notifications.npc-not-found");
                }
                if (npc != null && toSelect.getId() == npc.getId()) {
                    throw new CommandException("citizens.commands.npc.select.already-selected");
                }
                NPCCommands.this.selector.select(sender, toSelect);
                Messaging.sendWithNPC(sender, Settings.Setting.SELECTION_MESSAGE.asString(), toSelect);
            }
        };
        NPCRegistry nPCRegistry = registry = registryName != null ? CitizensAPI.getNamedNPCRegistry(registryName) : CitizensAPI.getNPCRegistry();
        if (registry == null) {
            throw new CommandException("citizens.commands.errors.unknown-registry", args.getFlag("registry"));
        }
        if (args.argsLength() <= 1) {
            if (!(sender instanceof Player)) {
                throw new ServerCommandException();
            }
            Player player = (Player)sender;
            final Location location = args.getSenderLocation();
            List search = player.getNearbyEntities(range, range, range);
            Collections.sort(search, new Comparator<Entity>(){

                @Override
                public int compare(Entity o1, Entity o2) {
                    double d = o1.getLocation().distanceSquared(location) - o2.getLocation().distanceSquared(location);
                    return d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
                }
            });
            for (Entity possibleNPC : search) {
                NPC test = registry.getNPC(possibleNPC);
                if (test == null) continue;
                if (test.hasTrait(ClickRedirectTrait.class)) {
                    test = test.getTraitNullable(ClickRedirectTrait.class).getRedirectNPC();
                }
                callback.run(test);
                break;
            }
        } else {
            NPCCommandSelector.startWithCallback(callback, registry, sender, args, args.getString(1));
        }
    }

    @Command(aliases={"npc"}, usage="sheep (--color [color]) (--sheared [sheared])", desc="Sets sheep modifiers", modifiers={"sheep"}, min=1, max=1, permission="citizens.npc.sheep")
    @Requirements(selected=true, ownership=true, types={EntityType.SHEEP})
    public void sheep(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"color"}) DyeColor color, @Flag(value={"sheared"}) Boolean sheared) throws CommandException {
        SheepTrait trait = npc.getOrAddTrait(SheepTrait.class);
        boolean hasArg = false;
        if (sheared != null) {
            trait.setSheared(sheared);
            hasArg = true;
        }
        if (args.hasValueFlag("color")) {
            if (color != null) {
                trait.setColor(color);
                Messaging.sendTr(sender, "citizens.commands.npc.sheep.color-set", color.toString().toLowerCase());
            } else {
                Messaging.sendErrorTr(sender, "citizens.commands.npc.sheep.invalid-color", Util.listValuesPretty(DyeColor.values()));
            }
            hasArg = true;
        }
        if (!hasArg) {
            throw new CommandException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="shop (edit|show) (name)", desc="NPC shop edit/show", modifiers={"shop"}, min=1, max=3, permission="citizens.npc.shop")
    public void shop(CommandContext args, Player sender, NPC npc, @Arg(value=1, completions={"edit", "show"}) String action) throws CommandException {
        ShopTrait trait = npc.getOrAddTrait(ShopTrait.class);
        ShopTrait.NPCShop shop = trait.getDefaultShop();
        if (args.argsLength() > 1) {
            if (args.argsLength() == 3) {
                if (action.equalsIgnoreCase("edit") && !sender.hasPermission("citizens.npc.shop.edit." + args.getString(2).toLowerCase())) {
                    throw new NoPermissionsException();
                }
                shop = trait.getShop(args.getString(2).toLowerCase());
            }
            if (action.equalsIgnoreCase("edit")) {
                if (!sender.hasPermission("citizens.npc.shop.edit")) {
                    throw new NoPermissionsException();
                }
                shop.displayEditor(sender);
                return;
            } else {
                if (!action.equalsIgnoreCase("show")) throw new CommandUsageException();
                shop.display(sender);
            }
            return;
        } else {
            shop.display(sender);
        }
    }

    @Command(aliases={"npc"}, usage="skin (-c(lear) -l(atest)) [name] (or --url [url] or -t [uuid/name] [data] [signature])", desc="Sets an NPC's skin name. Use -l to set the skin to always update to the latest", modifiers={"skin"}, min=1, max=4, flags="ctl", permission="citizens.npc.skin")
    @Requirements(types={EntityType.PLAYER}, selected=true, ownership=true)
    public void skin(CommandContext args, final CommandSender sender, final NPC npc, final @Flag(value={"url"}) String url) throws CommandException {
        String skinName = npc.getName();
        final SkinTrait trait = npc.getOrAddTrait(SkinTrait.class);
        if (args.hasFlag('c')) {
            trait.clearTexture();
        } else {
            if (url != null) {
                Bukkit.getScheduler().runTaskAsynchronously(CitizensAPI.getPlugin(), new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        FilterOutputStream out = null;
                        BufferedReader reader = null;
                        try {
                            URL target = new URL("https://api.mineskin.org/generate/url");
                            HttpURLConnection con = (HttpURLConnection)target.openConnection();
                            con.setRequestMethod("POST");
                            con.setDoOutput(true);
                            con.setConnectTimeout(1000);
                            con.setReadTimeout(30000);
                            out = new DataOutputStream(con.getOutputStream());
                            ((DataOutputStream)out).writeBytes("url=" + URLEncoder.encode(url, "UTF-8"));
                            out.close();
                            reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                            JSONObject output = (JSONObject)new JSONParser().parse((Reader)reader);
                            JSONObject data = (JSONObject)output.get((Object)"data");
                            final String uuid = (String)data.get((Object)"uuid");
                            JSONObject texture = (JSONObject)data.get((Object)"texture");
                            final String textureEncoded = (String)texture.get((Object)"value");
                            final String signature = (String)texture.get((Object)"signature");
                            con.disconnect();
                            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        trait.setSkinPersistent(uuid, signature, textureEncoded);
                                        Messaging.sendTr(sender, "citizens.commands.npc.skin.skin-url-set", npc.getName(), url);
                                    }
                                    catch (IllegalArgumentException e) {
                                        Messaging.sendErrorTr(sender, "citizens.commands.npc.skin.error-setting-url", url);
                                    }
                                }
                            });
                        }
                        catch (Throwable t) {
                            if (Messaging.isDebugging()) {
                                t.printStackTrace();
                            }
                            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), new Runnable(){

                                @Override
                                public void run() {
                                    Messaging.sendErrorTr(sender, "citizens.commands.npc.skin.error-setting-url", url);
                                }
                            });
                        }
                        finally {
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException target) {}
                            }
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException target) {}
                            }
                        }
                    }
                });
                return;
            }
            if (args.hasFlag('t')) {
                if (args.argsLength() != 4) {
                    throw new CommandException("citizens.commands.npc.skin.missing-skin");
                }
                trait.setSkinPersistent(args.getString(1), args.getString(3), args.getString(2));
                Messaging.sendTr(sender, "citizens.commands.npc.skin.set", npc.getName(), args.getString(1));
                return;
            }
            if (args.argsLength() != 2) {
                throw new CommandException("citizens.commands.npc.skin.missing-skin");
            }
            if (args.hasFlag('l')) {
                trait.setShouldUpdateSkins(true);
            }
            skinName = args.getString(1);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.skin.set", npc.getName(), skinName);
        trait.setSkinName(skinName, true);
    }

    @Command(aliases={"npc"}, usage="skinlayers (--cape [true|false]) (--hat [true|false]) (--jacket [true|false]) (--sleeves [true|false]) (--pants [true|false])", desc="Sets an NPC's skin layers visibility.", modifiers={"skinlayers"}, min=1, max=5, permission="citizens.npc.skinlayers")
    @Requirements(types={EntityType.PLAYER}, selected=true, ownership=true)
    public void skinLayers(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"cape"}) Boolean cape, @Flag(value={"hat"}) Boolean hat, @Flag(value={"jacket"}) Boolean jacket, @Flag(value={"sleeves"}) Boolean sleeves, @Flag(value={"pants"}) Boolean pants) throws CommandException {
        SkinLayers trait = npc.getOrAddTrait(SkinLayers.class);
        if (cape != null) {
            trait.setVisible(SkinLayers.Layer.CAPE, cape);
        }
        if (hat != null) {
            trait.setVisible(SkinLayers.Layer.HAT, hat);
        }
        if (jacket != null) {
            trait.setVisible(SkinLayers.Layer.JACKET, jacket);
        }
        if (sleeves != null) {
            trait.setVisible(SkinLayers.Layer.LEFT_SLEEVE, sleeves);
            trait.setVisible(SkinLayers.Layer.RIGHT_SLEEVE, sleeves);
        }
        if (pants != null) {
            trait.setVisible(SkinLayers.Layer.LEFT_PANTS, pants);
            trait.setVisible(SkinLayers.Layer.RIGHT_PANTS, pants);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.skin.layers-set", npc.getName(), trait.isVisible(SkinLayers.Layer.CAPE), trait.isVisible(SkinLayers.Layer.HAT), trait.isVisible(SkinLayers.Layer.JACKET), trait.isVisible(SkinLayers.Layer.LEFT_SLEEVE) || trait.isVisible(SkinLayers.Layer.RIGHT_SLEEVE), trait.isVisible(SkinLayers.Layer.LEFT_PANTS) || trait.isVisible(SkinLayers.Layer.RIGHT_PANTS));
    }

    @Command(aliases={"npc"}, usage="size [size]", desc="Sets the NPC's size", modifiers={"size"}, min=1, max=2, permission="citizens.npc.size")
    @Requirements(selected=true, ownership=true, types={EntityType.MAGMA_CUBE, EntityType.SLIME})
    public void slimeSize(CommandContext args, CommandSender sender, NPC npc) {
        SlimeSize trait = npc.getOrAddTrait(SlimeSize.class);
        if (args.argsLength() <= 1) {
            trait.describe(sender);
            return;
        }
        int size = Math.max(-2, args.getInteger(1));
        trait.setSize(size);
        Messaging.sendTr(sender, "citizens.commands.npc.size.set", npc.getName(), size);
    }

    @Command(aliases={"npc"}, usage="sound (--death [death sound|d]) (--ambient [ambient sound|d]) (--hurt [hurt sound|d]) (-n(one)/-s(ilent)) (-d(efault))", desc="Sets an NPC's played sounds", modifiers={"sound"}, flags="dns", min=1, max=1, permission="citizens.npc.sound")
    @Requirements(selected=true, ownership=true, livingEntity=true)
    public void sound(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"death"}) String death, @Flag(value={"ambient"}) String ambient, @Flag(value={"hurt"}) String hurt) throws CommandException {
        String ambientSound = (String)npc.data().get("ambient-sound");
        String deathSound = (String)npc.data().get("death-sound");
        String hurtSound = (String)npc.data().get("hurt-sound");
        if (args.getValueFlags().size() == 0 && args.getFlags().size() == 0) {
            Messaging.sendTr(sender, "citizens.commands.npc.sound.info", npc.getName(), ambientSound, hurtSound, deathSound);
            return;
        }
        if (args.hasFlag('n')) {
            hurtSound = "";
            deathSound = "";
            ambientSound = "";
            npc.data().setPersistent("silent-sounds", (Object)true);
        }
        if (args.hasFlag('s')) {
            npc.data().setPersistent("silent-sounds", (Object)(npc.data().get("silent-sounds", Boolean.valueOf(false)) == false ? 1 : 0));
        }
        if (args.hasFlag('d')) {
            hurtSound = null;
            deathSound = null;
            ambientSound = null;
            npc.data().setPersistent("silent-sounds", (Object)false);
        } else {
            if (death != null) {
                String string = deathSound = death.equals("d") ? null : NMS.getSound(death);
            }
            if (ambient != null) {
                String string = ambientSound = ambient.equals("d") ? null : NMS.getSound(ambient);
            }
            if (hurt != null) {
                String string = hurtSound = hurt.equals("d") ? null : NMS.getSound(hurt);
            }
        }
        if (deathSound == null) {
            npc.data().remove("death-sound");
        } else {
            npc.data().setPersistent("death-sound", (Object)deathSound);
        }
        if (hurtSound == null) {
            npc.data().remove("hurt-sound");
        } else {
            npc.data().setPersistent("hurt-sound", (Object)hurtSound);
        }
        if (ambientSound == null) {
            npc.data().remove("ambient-sound");
        } else {
            npc.data().setPersistent("ambient-sound", (Object)ambientSound);
        }
        if (ambientSound != null && ambientSound.isEmpty()) {
            ambientSound = "none";
        }
        if (hurtSound != null && hurtSound.isEmpty()) {
            hurtSound = "none";
        }
        if (deathSound != null && deathSound.isEmpty()) {
            deathSound = "none";
        }
        if (!Strings.isNullOrEmpty((String)ambientSound) && !ambientSound.equals("none") || !Strings.isNullOrEmpty((String)deathSound) && !deathSound.equals("none") || !Strings.isNullOrEmpty((String)hurtSound) && !hurtSound.equals("none")) {
            npc.data().setPersistent("silent-sounds", (Object)false);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.sound.set", npc.getName(), ambientSound, hurtSound, deathSound);
    }

    @Command(aliases={"npc"}, usage="spawn (id|name) -l(oad chunks)", desc="Spawn an existing NPC", modifiers={"spawn"}, min=1, max=2, flags="l", permission="citizens.npc.spawn")
    @Requirements(ownership=true)
    public void spawn(final CommandContext args, final CommandSender sender, NPC npc) throws CommandException {
        NPCCommandSelector.Callback callback = new NPCCommandSelector.Callback(){

            @Override
            public void run(NPC respawn) throws CommandException {
                if (respawn == null) {
                    if (args.argsLength() > 1) {
                        throw new CommandException("citizens.commands.npc.spawn.missing-npc-id", args.getString(1));
                    }
                    throw new CommandException("citizens.commands.requirements.must-have-selected");
                }
                if (respawn.isSpawned()) {
                    throw new CommandException("citizens.commands.npc.spawn.already-spawned", respawn.getName());
                }
                Location location = respawn.getOrAddTrait(CurrentLocation.class).getLocation();
                if (location == null || args.hasValueFlag("location")) {
                    if (args.getSenderLocation() == null) {
                        throw new CommandException("citizens.commands.npc.spawn.no-location");
                    }
                    location = args.getSenderLocation();
                }
                if (args.hasFlag('l') && !Util.isLoaded(location)) {
                    location.getChunk().load();
                }
                if (respawn.spawn(location, SpawnReason.COMMAND)) {
                    NPCCommands.this.selector.select(sender, respawn);
                    Messaging.sendTr(sender, "citizens.commands.npc.spawn.spawned", respawn.getName());
                }
            }
        };
        if (args.argsLength() > 1) {
            NPCCommandSelector.startWithCallback(callback, CitizensAPI.getNPCRegistry(), sender, args, args.getString(1));
        } else {
            callback.run(npc);
        }
    }

    @Command(aliases={"npc"}, usage="speak [message] --target [npcid|player name] --range (range to look for entities to speak to in blocks) (--type vocal_type)", desc="Says a message from the NPC", modifiers={"speak"}, min=2, permission="citizens.npc.speak")
    public void speak(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"type"}) String type, @Flag(value={"target"}) String target, @Flag(value={"range"}) Float range) throws CommandException {
        String message = Colorizer.parseColors(args.getJoinedStrings(1));
        if (message.length() <= 0) {
            Messaging.send(sender, "Default Vocal Chord for " + npc.getName() + ": " + npc.getOrAddTrait(Speech.class).getDefaultVocalChord());
            return;
        }
        SpeechContext context = new SpeechContext(message);
        if (target != null) {
            if (target.matches("\\d+")) {
                NPC targetNPC = CitizensAPI.getNPCRegistry().getById(Integer.valueOf(args.getFlag("target")));
                if (targetNPC != null) {
                    context.addRecipient(targetNPC.getEntity());
                }
            } else {
                Player player = Bukkit.getPlayerExact((String)target);
                if (player != null) {
                    context.addRecipient((Entity)player);
                }
            }
        }
        if (range != null) {
            npc.getEntity().getNearbyEntities((double)(range.floatValue() / 2.0f), (double)range.floatValue(), (double)(range.floatValue() / 2.0f)).forEach(e -> {
                if (!CitizensAPI.getNPCRegistry().isNPC((Entity)e)) {
                    context.addRecipient((Entity)e);
                }
            });
        }
        if (type == null || !CitizensAPI.getSpeechFactory().isRegistered(type)) {
            type = npc.getOrAddTrait(Speech.class).getDefaultVocalChord();
        }
        npc.getDefaultSpeechController().speak(context, type);
    }

    @Command(aliases={"npc"}, usage="speed [speed]", desc="Sets the movement speed of an NPC as a percentage", modifiers={"speed"}, min=2, max=2, permission="citizens.npc.speed")
    public void speed(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        float newSpeed = (float)Math.abs(args.getDouble(1));
        if ((double)newSpeed >= Settings.Setting.MAX_SPEED.asDouble()) {
            throw new CommandException("citizens.commands.npc.speed.modifier-above-limit");
        }
        npc.getNavigator().getDefaultParameters().speedModifier(newSpeed);
        Messaging.sendTr(sender, "citizens.commands.npc.speed.set", Float.valueOf(newSpeed));
    }

    @Command(aliases={"npc"}, usage="swim (--set [true|false])", desc="Sets an NPC to swim or not", modifiers={"swim"}, min=1, max=1, permission="citizens.npc.swim")
    public void swim(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"set"}) Boolean set) throws CommandException {
        boolean swim = set != null ? set : npc.data().get(NPC.Metadata.SWIMMING, Boolean.valueOf(true)) == false;
        npc.data().setPersistent(NPC.Metadata.SWIMMING, (Object)swim);
        Messaging.sendTr(sender, swim ? "citizens.commands.npc.swim.set" : "citizens.commands.npc.swim.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="target [name|UUID] (-a[ggressive]) (-c[ancel])", desc="Target a given entity", modifiers={"target"}, flags="ac", min=1, max=2, permission="citizens.npc.target")
    public void target(CommandContext args, Player sender, NPC npc) {
        Player toTarget;
        if (args.hasFlag('c')) {
            npc.getNavigator().cancelNavigation();
            return;
        }
        Player player = toTarget = args.argsLength() < 2 ? sender : Bukkit.getPlayer((String)args.getString(1));
        if (toTarget == null) {
            toTarget = Bukkit.getEntity((UUID)UUID.fromString(args.getString(1)));
        }
        if (toTarget != null) {
            npc.getNavigator().setTarget((Entity)toTarget, args.hasFlag('a'));
        }
    }

    @Command(aliases={"npc"}, usage="targetable (-t(emporary))", desc="Toggles an NPC's targetability", modifiers={"targetable"}, min=1, max=1, flags="t", permission="citizens.npc.targetable")
    public void targetable(CommandContext args, CommandSender sender, NPC npc) {
        boolean targetable;
        boolean bl = targetable = npc.data().get("protected-target", Boolean.valueOf(npc.isProtected())) == false;
        if (args.hasFlag('t')) {
            npc.data().set("protected-target", (Object)targetable);
        } else {
            npc.data().setPersistent("protected-target", (Object)targetable);
        }
        Messaging.sendTr(sender, targetable ? "citizens.commands.npc.targetable.set" : "citizens.commands.npc.targetable.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="tp (-e(xact))", desc="Teleport in front of an NPC", modifiers={"tp", "teleport"}, min=1, max=1, flags="e", permission="citizens.npc.tp")
    public void tp(CommandContext args, Player player, NPC npc) {
        Location to = npc.getOrAddTrait(CurrentLocation.class).getLocation();
        if (to == null) {
            Messaging.sendError((CommandSender)player, "citizens.commands.npc.tp.location-not-found");
            return;
        }
        if (!args.hasFlag('e')) {
            to = to.clone().add(to.getDirection().setY(0));
            to.setDirection(to.getDirection().multiply(-1)).setPitch(0.0f);
        }
        player.teleport(to, PlayerTeleportEvent.TeleportCause.COMMAND);
        Messaging.sendTr((CommandSender)player, "citizens.commands.npc.tp.teleported", npc.getName());
    }

    @Command(aliases={"npc"}, usage="tphere (cursor) (-c(enter))", desc="Teleport a NPC to your location", flags="c", modifiers={"tphere", "tph", "move"}, min=1, max=2, permission="citizens.npc.tphere")
    public void tphere(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Location to = args.getSenderLocation();
        if (to == null) {
            throw new ServerCommandException();
        }
        if (args.argsLength() > 1 && args.getString(1).equalsIgnoreCase("cursor")) {
            if (!(sender instanceof Player)) {
                throw new ServerCommandException();
            }
            Block target = ((Player)sender).getTargetBlock(null, 64);
            if (target == null) {
                throw new CommandException("citizens.commands.npc.tphere.missing-cursor-block");
            }
            to = target.getRelative(BlockFace.UP).getLocation();
        }
        if (!sender.hasPermission("citizens.npc.tphere.multiworld") && npc.getStoredLocation().getWorld() != args.getSenderLocation().getWorld()) {
            throw new CommandException("citizens.commands.npc.tphere.multiworld-not-allowed");
        }
        if (args.hasFlag('c')) {
            to = to.getBlock().getLocation();
            to.setX(to.getX() + 0.5);
            to.setZ(to.getZ() + 0.5);
        }
        if (!npc.isSpawned()) {
            NPCTeleportEvent event = new NPCTeleportEvent(npc, to);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            npc.spawn(to, SpawnReason.COMMAND);
        } else {
            npc.teleport(to, PlayerTeleportEvent.TeleportCause.COMMAND);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.tphere.teleported", npc.getName(), Util.prettyPrintLocation(args.getSenderLocation()));
    }

    @Command(aliases={"npc"}, usage="tpto [player name|npc id] [player name|npc id]", desc="Teleport an NPC or player to another NPC or player", modifiers={"tpto"}, min=2, max=3, permission="citizens.npc.tpto")
    @Requirements
    public void tpto(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Player to;
        Entity from;
        block14: {
            int id;
            from = null;
            to = null;
            boolean firstWasPlayer = false;
            if (npc != null) {
                from = npc.getEntity();
            }
            try {
                id = args.getInteger(1);
                NPC fromNPC = CitizensAPI.getNPCRegistry().getById(id);
                if (fromNPC != null) {
                    if (args.argsLength() == 2) {
                        to = fromNPC.getEntity();
                    } else {
                        from = fromNPC.getEntity();
                    }
                }
            }
            catch (NumberFormatException e) {
                if (args.argsLength() == 2) {
                    to = Bukkit.getPlayerExact((String)args.getString(1));
                } else {
                    from = Bukkit.getPlayerExact((String)args.getString(1));
                }
                firstWasPlayer = true;
            }
            if (args.argsLength() == 3) {
                try {
                    id = args.getInteger(2);
                    NPC toNPC = CitizensAPI.getNPCRegistry().getById(id);
                    if (toNPC != null) {
                        to = toNPC.getEntity();
                    }
                }
                catch (NumberFormatException e) {
                    if (firstWasPlayer) break block14;
                    to = Bukkit.getPlayerExact((String)args.getString(2));
                }
            }
        }
        if (from == null) {
            throw new CommandException("citizens.commands.npc.tpto.from-not-found");
        }
        if (to == null) {
            throw new CommandException("citizens.commands.npc.tpto.to-not-found");
        }
        from.teleport((Entity)to);
        Messaging.sendTr(sender, "citizens.commands.npc.tpto.success", new Object[0]);
    }

    @Command(aliases={"npc"}, usage="type [type]", desc="Sets an NPC's entity type", modifiers={"type"}, min=2, max=2, permission="citizens.npc.type")
    public void type(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) EntityType type) throws CommandException {
        if (type == null) {
            throw new CommandException("citizens.commands.npc.type.invalid", args.getString(1));
        }
        npc.setBukkitEntityType(type);
        Messaging.sendTr(sender, "citizens.commands.npc.type.set", npc.getName(), args.getString(1));
    }

    @Command(aliases={"npc"}, usage="undo (all)", desc="Undoes the last action (currently only create/remove supported)", modifiers={"undo"}, min=1, max=2, permission="citizens.npc.undo")
    @Requirements
    public void undo(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completions={"all"}) String action) throws CommandException {
        if ("all".equalsIgnoreCase(action)) {
            while (this.history.undo(sender)) {
            }
        } else if (this.history.undo(sender)) {
            Messaging.sendTr(sender, "citizens.commands.npc.undo.successful", new Object[0]);
        } else {
            Messaging.sendTr(sender, "citizens.commands.npc.undo.unsuccessful", new Object[0]);
        }
    }

    @Command(aliases={"npc"}, usage="useitem (-o(ffhand))", desc="Sets an NPC to  be using their held items", modifiers={"useitem"}, min=1, max=1, flags="o", permission="citizens.npc.useitem")
    public void useitem(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        boolean offhand = args.hasFlag('o');
        if (offhand) {
            npc.data().setPersistent(NPC.Metadata.USING_OFFHAND_ITEM, (Object)(npc.data().get(NPC.Metadata.USING_OFFHAND_ITEM, Boolean.valueOf(false)) == false ? 1 : 0));
            Messaging.sendTr(sender, "citizens.commands.npc.useitem.offhand-item-toggled", Boolean.toString((Boolean)npc.data().get(NPC.Metadata.USING_OFFHAND_ITEM)));
        } else {
            npc.data().setPersistent(NPC.Metadata.USING_HELD_ITEM, (Object)(npc.data().get(NPC.Metadata.USING_HELD_ITEM, Boolean.valueOf(false)) == false ? 1 : 0));
            Messaging.sendTr(sender, "citizens.commands.npc.useitem.held-item-toggled", Boolean.toString((Boolean)npc.data().get(NPC.Metadata.USING_HELD_ITEM)));
        }
    }

    @Command(aliases={"npc"}, usage="vulnerable (-t(emporary))", desc="Toggles an NPC's vulnerability", modifiers={"vulnerable"}, min=1, max=1, flags="t", permission="citizens.npc.vulnerable")
    public void vulnerable(CommandContext args, CommandSender sender, NPC npc) {
        boolean vulnerable;
        boolean bl = vulnerable = !npc.isProtected();
        if (args.hasFlag('t')) {
            npc.data().set("protected", (Object)vulnerable);
        } else {
            npc.data().setPersistent("protected", (Object)vulnerable);
        }
        String key = vulnerable ? "citizens.commands.npc.vulnerable.stopped" : "citizens.commands.npc.vulnerable.set";
        Messaging.sendTr(sender, key, npc.getName());
    }

    @Command(aliases={"npc"}, usage="wander", desc="Sets the NPC to wander around", modifiers={"wander"}, min=1, max=1, permission="citizens.npc.wander")
    public void wander(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Waypoints trait;
        trait.setWaypointProvider((trait = npc.getOrAddTrait(Waypoints.class)).getCurrentProviderName().equals("wander") ? "linear" : "wander");
        Messaging.sendTr(sender, "citizens.waypoints.set-provider", trait.getCurrentProviderName());
    }

    @Command(aliases={"npc"}, usage="wither (--invulnerable [true|false]) (--arrow-shield [true|false])", desc="Sets wither modifiers", modifiers={"wither"}, min=1, requiresFlags=true, max=1, permission="citizens.npc.wither")
    @Requirements(selected=true, ownership=true, types={EntityType.WITHER})
    public void wither(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"invulnerable"}) Boolean invulnerable, @Flag(value={"arrow-shield"}) Boolean arrows) throws CommandException {
        WitherTrait trait = npc.getOrAddTrait(WitherTrait.class);
        if (invulnerable != null) {
            trait.setInvulnerable(invulnerable);
        }
        if (arrows != null) {
            trait.setBlocksArrows(arrows);
        }
    }

    @Command(aliases={"npc"}, usage="wolf (-s(itting) a(ngry) t(amed) i(nfo)) --collar [hex rgb color|name]", desc="Sets wolf modifiers", modifiers={"wolf"}, min=1, max=1, requiresFlags=true, flags="sati", permission="citizens.npc.wolf")
    @Requirements(selected=true, ownership=true, types={EntityType.WOLF})
    public void wolf(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"collar"}) String collar) throws CommandException {
        WolfModifiers trait = npc.getOrAddTrait(WolfModifiers.class);
        if (args.hasFlag('a')) {
            trait.setAngry(!trait.isAngry());
        }
        if (args.hasFlag('s')) {
            trait.setSitting(!trait.isSitting());
        }
        if (args.hasFlag('t')) {
            trait.setTamed(!trait.isTamed());
        }
        if (collar != null) {
            String unparsed = collar;
            DyeColor color = null;
            try {
                color = DyeColor.valueOf((String)unparsed.toUpperCase().replace(' ', '_'));
            }
            catch (IllegalArgumentException e) {
                try {
                    int rgb = Integer.parseInt(unparsed.replace("#", ""), 16);
                    color = DyeColor.getByColor((Color)Color.fromRGB((int)rgb));
                }
                catch (NumberFormatException ex) {
                    throw new CommandException("citizens.commands.npc.wolf.unknown-collar-color", unparsed);
                }
            }
            if (color == null) {
                throw new CommandException("citizens.commands.npc.wolf.collar-color-unsupported", unparsed);
            }
            trait.setCollarColor(color);
        }
        Messaging.sendTr(sender, "citizens.commands.wolf.traits-updated", npc.getName(), trait.isAngry(), trait.isSitting(), trait.isTamed(), trait.getCollarColor().name());
    }
}

