/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import java.util.Map;
import java.util.WeakHashMap;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.command.CommandSender;

@Requirements
public class AdminCommands {
    private final Citizens plugin;
    private final Map<CommandSender, Long> reloadTimeouts = new WeakHashMap<CommandSender, Long>();

    public AdminCommands(Citizens plugin) {
        this.plugin = plugin;
    }

    @Command(aliases={"citizens"}, desc="Show basic plugin information", max=0, permission="citizens.admin")
    public void citizens(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Messaging.send(sender, StringHelper.wrapHeader("<green>Citizens v" + this.plugin.getDescription().getVersion()));
        Messaging.send(sender, "     <yellow>-- <green>Author: fullwall");
        Messaging.send(sender, "     <yellow>-- <green>Website: " + this.plugin.getDescription().getWebsite());
        Messaging.send(sender, "     <yellow>-- <green>Support: https://discord.gg/Q6pZGSR");
    }

    @Command(aliases={"citizens"}, usage="reload", desc="Load Citizens fresh from disk, without saving first", modifiers={"reload", "load"}, min=1, max=1, permission="citizens.admin")
    public void reload(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Long timeout;
        if (Settings.Setting.WARN_ON_RELOAD.asBoolean() && ((timeout = this.reloadTimeouts.get(sender)) == null || System.currentTimeMillis() > timeout)) {
            Messaging.sendErrorTr(sender, "citizens.notifications.reload-warning", new Object[0]);
            this.reloadTimeouts.put(sender, System.currentTimeMillis() + 5000L);
            return;
        }
        Messaging.sendTr(sender, "citizens.notifications.reloading", new Object[0]);
        try {
            this.plugin.reload();
            Messaging.sendTr(sender, "citizens.notifications.reloaded", new Object[0]);
        }
        catch (NPCLoadException ex) {
            ex.printStackTrace();
            throw new CommandException("citizens.notifications.error-reloading");
        }
    }

    @Command(aliases={"citizens"}, usage="save (-a)", desc="Save NPCs", help="citizens.commands.citizens.save.help", modifiers={"save"}, min=1, max=1, flags="a", permission="citizens.admin")
    public void save(CommandContext args, CommandSender sender, NPC npc) {
        Messaging.sendTr(sender, "citizens.notifications.saving", new Object[0]);
        this.plugin.storeNPCs(args.hasFlag('a'));
        Messaging.sendTr(sender, "citizens.notifications.saved", new Object[0]);
    }
}

