/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.EventListenChunk;
import net.citizensnpcs.NPCNeedsRespawnEvent;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.event.CitizensDeserialiseMetaEvent;
import net.citizensnpcs.api.event.CitizensPreReloadEvent;
import net.citizensnpcs.api.event.CitizensSerialiseMetaEvent;
import net.citizensnpcs.api.event.CommandSenderCreateNPCEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.EntityTargetNPCEvent;
import net.citizensnpcs.api.event.NPCCombustByBlockEvent;
import net.citizensnpcs.api.event.NPCCombustByEntityEvent;
import net.citizensnpcs.api.event.NPCCombustEvent;
import net.citizensnpcs.api.event.NPCDamageByBlockEvent;
import net.citizensnpcs.api.event.NPCDamageByEntityEvent;
import net.citizensnpcs.api.event.NPCDamageEntityEvent;
import net.citizensnpcs.api.event.NPCDamageEvent;
import net.citizensnpcs.api.event.NPCDeathEvent;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.event.NPCVehicleDamageEvent;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.skin.SkinUpdateTracker;
import net.citizensnpcs.trait.ClickRedirectTrait;
import net.citizensnpcs.trait.CommandTrait;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.util.ChunkCoord;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.world.ChunkEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.scheduler.BukkitRunnable;

public class EventListen
implements Listener {
    private EventListenChunk chunkEventListener;
    private final Map<String, NPCRegistry> registries;
    private final SkinUpdateTracker skinUpdateTracker;
    private final ListMultimap<ChunkCoord, NPC> toRespawn = ArrayListMultimap.create((int)64, (int)4);
    private static boolean SUPPORT_STOP_USE_ITEM = true;

    EventListen(Map<String, NPCRegistry> registries) {
        this.registries = registries;
        this.skinUpdateTracker = new SkinUpdateTracker(registries);
        try {
            this.chunkEventListener = new EventListenChunk(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.chunkEventListener, CitizensAPI.getPlugin());
        }
        catch (Throwable ex) {
            this.chunkEventListener = null;
        }
        try {
            Class.forName("org.bukkit.event.entity.EntityTransformEvent");
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onEntityTransform(EntityTransformEvent event) {
                    NPC npc = CitizensAPI.getNPCRegistry().getNPC(event.getEntity());
                    if (npc == null) {
                        return;
                    }
                    if (npc.isProtected()) {
                        event.setCancelled(true);
                    }
                }
            }, CitizensAPI.getPlugin());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void checkCreationEvent(CommandSenderCreateNPCEvent event) {
        int maxChecks;
        if (event.getCreator().hasPermission("citizens.admin.avoid-limits")) {
            return;
        }
        int limit = Settings.Setting.DEFAULT_NPC_LIMIT.asInt();
        for (int i = maxChecks = Settings.Setting.MAX_NPC_LIMIT_CHECKS.asInt(); i >= 0; --i) {
            if (!event.getCreator().hasPermission("citizens.npc.limit." + i)) continue;
            limit = i;
            break;
        }
        if (limit < 0) {
            return;
        }
        int owned = 0;
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            if (event.getNPC().equals(npc) || !npc.hasTrait(Owner.class) || !npc.getTraitNullable(Owner.class).isOwnedBy(event.getCreator())) continue;
            ++owned;
        }
        int wouldOwn = owned + 1;
        if (wouldOwn > limit) {
            event.setCancelled(true);
            event.setCancelReason(Messaging.tr("citizens.limits.over-npc-limit", limit));
        }
    }

    private Iterable<NPC> getAllNPCs() {
        return Iterables.filter((Iterable)Iterables.concat((Iterable)CitizensAPI.getNPCRegistry(), (Iterable)Iterables.concat(this.registries.values())), (Predicate)Predicates.notNull());
    }

    void loadNPCs(final ChunkEvent event) {
        final ChunkCoord coord = new ChunkCoord(event.getChunk());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EventListen.this.respawnAllFromCoord(coord, (Event)event);
            }
        };
        if (Messaging.isDebugging() && Settings.Setting.DEBUG_CHUNK_LOADS.asBoolean() && this.toRespawn.containsKey((Object)coord)) {
            new Exception("CITIZENS CHUNK LOAD DEBUG " + coord).printStackTrace();
        }
        if (event instanceof Cancellable) {
            runnable.run();
        } else {
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), runnable);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent event) {
        if (this.chunkEventListener != null) {
            return;
        }
        this.loadNPCs((ChunkEvent)event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (this.chunkEventListener != null) {
            return;
        }
        this.unloadNPCs((ChunkEvent)event, Arrays.asList(event.getChunk().getEntities()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCitizensReload(CitizensPreReloadEvent event) {
        this.skinUpdateTracker.reset();
        this.toRespawn.clear();
    }

    @EventHandler(ignoreCancelled=true)
    public void onCommandSenderCreateNPC(CommandSenderCreateNPCEvent event) {
        this.checkCreationEvent(event);
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        NPC npc = CitizensAPI.getNPCRegistry().getNPC(event.getEntity());
        if (npc == null) {
            return;
        }
        event.setCancelled(npc.isProtected());
        if (event instanceof EntityCombustByEntityEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustByEntityEvent((EntityCombustByEntityEvent)event, npc));
        } else if (event instanceof EntityCombustByBlockEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustByBlockEvent((EntityCombustByBlockEvent)event, npc));
        } else {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustEvent(event, npc));
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        NPC npc = CitizensAPI.getNPCRegistry().getNPC(event.getEntity());
        if (npc == null) {
            if (event instanceof EntityDamageByEntityEvent) {
                npc = CitizensAPI.getNPCRegistry().getNPC(((EntityDamageByEntityEvent)event).getDamager());
                if (npc == null) {
                    return;
                }
                event.setCancelled(npc.data().get("damage-others", Boolean.valueOf(true)) == false);
                NPCDamageEntityEvent damageEvent = new NPCDamageEntityEvent(npc, (EntityDamageByEntityEvent)event);
                Bukkit.getPluginManager().callEvent((Event)damageEvent);
            }
            return;
        }
        event.setCancelled(npc.isProtected());
        if (event instanceof EntityDamageByEntityEvent) {
            NPCDamageByEntityEvent damageEvent = new NPCDamageByEntityEvent(npc, (EntityDamageByEntityEvent)event);
            Bukkit.getPluginManager().callEvent((Event)damageEvent);
            if (!damageEvent.isCancelled() || !(damageEvent.getDamager() instanceof Player)) {
                return;
            }
            Player damager = (Player)damageEvent.getDamager();
            if (npc.hasTrait(ClickRedirectTrait.class) && (npc = npc.getTraitNullable(ClickRedirectTrait.class).getRedirectNPC()) == null) {
                return;
            }
            NPCLeftClickEvent leftClickEvent = new NPCLeftClickEvent(npc, damager);
            Bukkit.getPluginManager().callEvent((Event)leftClickEvent);
            if (npc.hasTrait(CommandTrait.class)) {
                npc.getTraitNullable(CommandTrait.class).dispatch(damager, CommandTrait.Hand.LEFT);
            }
        } else if (event instanceof EntityDamageByBlockEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCDamageByBlockEvent(npc, (EntityDamageByBlockEvent)event));
        } else {
            Bukkit.getPluginManager().callEvent((Event)new NPCDamageEvent(npc, event));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        final NPC npc = CitizensAPI.getNPCRegistry().getNPC((Entity)event.getEntity());
        if (npc == null) {
            return;
        }
        if (!npc.data().get("drops-items", Boolean.valueOf(false)).booleanValue()) {
            event.getDrops().clear();
        }
        final Location location = npc.getStoredLocation();
        Bukkit.getPluginManager().callEvent((Event)new NPCDeathEvent(npc, event));
        npc.despawn(DespawnReason.DEATH);
        int delay = npc.data().get("respawn-delay", Integer.valueOf(-1));
        if (delay < 0) {
            return;
        }
        int deathAnimationTicks = event.getEntity() instanceof LivingEntity ? 20 : 2;
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (!npc.isSpawned() && npc.getOwningRegistry().getByUniqueId(npc.getUniqueId()) == npc) {
                    npc.spawn(location, SpawnReason.TIMED_RESPAWN);
                }
            }
        }, (long)(delay + deathAnimationTicks));
    }

    @EventHandler
    public void onEntityPortal(EntityPortalEvent event) {
        NPC npc = CitizensAPI.getNPCRegistry().getNPC(event.getEntity());
        if (npc == null || npc.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        event.setCancelled(true);
        npc.despawn(DespawnReason.PENDING_RESPAWN);
        event.getTo().getChunk();
        npc.spawn(event.getTo(), SpawnReason.RESPAWN);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        if (event.isCancelled() && CitizensAPI.getNPCRegistry().isNPC((Entity)event.getEntity())) {
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent event) {
        NPC npc = CitizensAPI.getNPCRegistry().getNPC(event.getTarget());
        if (npc == null) {
            return;
        }
        event.setCancelled(npc.data().get("protected-target", Boolean.valueOf(!npc.isProtected())) == false);
        Bukkit.getPluginManager().callEvent((Event)new EntityTargetNPCEvent(event, npc));
    }

    @EventHandler
    public void onMetaDeserialise(CitizensDeserialiseMetaEvent event) {
        if (event.getKey().keyExists("skull")) {
            UUID uuid;
            String owner = event.getKey().getString("skull.owner", "");
            UUID uUID = uuid = event.getKey().keyExists("skull.uuid") ? UUID.fromString(event.getKey().getString("skull.uuid")) : null;
            if (owner.isEmpty() && uuid == null) {
                return;
            }
            GameProfile profile = new GameProfile(uuid, owner);
            for (DataKey sub : event.getKey().getRelative("skull.properties").getSubKeys()) {
                String propertyName = sub.name();
                for (DataKey property : sub.getIntegerSubKeys()) {
                    profile.getProperties().put((Object)propertyName, (Object)new Property(property.getString("name"), property.getString("value"), property.keyExists("signature") ? property.getString("signature") : null));
                }
            }
            Material mat = SpigotUtil.isUsing1_13API() ? Material.SKELETON_SKULL : Material.valueOf((String)"SKULL_ITEM");
            SkullMeta meta = (SkullMeta)Bukkit.getItemFactory().getItemMeta(mat);
            NMS.setProfile(meta, profile);
            event.getItemStack().setItemMeta((ItemMeta)meta);
        }
    }

    @EventHandler
    public void onMetaSerialise(CitizensSerialiseMetaEvent event) {
        if (!(event.getMeta() instanceof SkullMeta)) {
            return;
        }
        SkullMeta meta = (SkullMeta)event.getMeta();
        GameProfile profile = NMS.getProfile(meta);
        if (profile == null) {
            return;
        }
        if (profile.getName() != null) {
            event.getKey().setString("skull.owner", profile.getName());
        }
        if (profile.getId() != null) {
            event.getKey().setString("skull.uuid", profile.getId().toString());
        }
        if (profile.getProperties() != null) {
            for (Map.Entry entry : profile.getProperties().asMap().entrySet()) {
                DataKey relative = event.getKey().getRelative("skull.properties." + (String)entry.getKey());
                int i = 0;
                for (Property value : (Collection)entry.getValue()) {
                    relative.getRelative(i).setString("name", value.getName());
                    if (value.getSignature() != null) {
                        relative.getRelative(i).setString("signature", value.getSignature());
                    }
                    relative.getRelative(i).setString("value", value.getValue());
                    ++i;
                }
            }
        }
    }

    @EventHandler
    public void onNavigationBegin(NavigationBeginEvent event) {
        this.skinUpdateTracker.onNPCNavigationBegin(event.getNPC());
    }

    @EventHandler
    public void onNavigationComplete(NavigationCompleteEvent event) {
        this.skinUpdateTracker.onNPCNavigationComplete(event.getNPC());
    }

    @EventHandler
    public void onNeedsRespawn(NPCNeedsRespawnEvent event) {
        ChunkCoord coord = new ChunkCoord(event.getSpawnLocation());
        if (this.toRespawn.containsEntry((Object)coord, (Object)event.getNPC())) {
            return;
        }
        Messaging.debug("Stored", event.getNPC(), "for respawn from NPCNeedsRespawnEvent");
        this.toRespawn.put((Object)coord, (Object)event.getNPC());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNPCDespawn(NPCDespawnEvent event) {
        if (event.getReason() == DespawnReason.PLUGIN || event.getReason() == DespawnReason.REMOVAL || event.getReason() == DespawnReason.RELOAD) {
            if (Messaging.isDebugging()) {
                Messaging.debug("Preventing further respawns of", event.getNPC(), "due to DespawnReason." + (Object)((Object)event.getReason()));
            }
            this.toRespawn.values().remove(event.getNPC());
        } else if (Messaging.isDebugging()) {
            Messaging.debug("Removing", event.getNPC(), "from skin tracker due to DespawnReason." + event.getReason().name());
        }
        this.skinUpdateTracker.onNPCDespawn(event.getNPC());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNPCRemove(NPCRemoveEvent event) {
        this.toRespawn.values().remove(event.getNPC());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNPCSpawn(NPCSpawnEvent event) {
        this.skinUpdateTracker.onNPCSpawn(event.getNPC());
        if (Messaging.isDebugging()) {
            Messaging.debug("Removing respawns of", event.getNPC(), "due to SpawnReason." + (Object)((Object)event.getReason()));
        }
        this.toRespawn.values().remove(event.getNPC());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        if (CitizensAPI.getNPCRegistry().getNPC((Entity)event.getPlayer()) == null) {
            return;
        }
        NMS.removeFromServerPlayerList(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        this.skinUpdateTracker.updatePlayer(event.getPlayer(), 20L, true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCreateNPC(PlayerCreateNPCEvent event) {
        this.checkCreationEvent(event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerFish(PlayerFishEvent event) {
        if (CitizensAPI.getNPCRegistry().isNPC(event.getCaught()) && CitizensAPI.getNPCRegistry().getNPC(event.getCaught()).isProtected()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        NPC npc = CitizensAPI.getNPCRegistry().getNPC(event.getRightClicked());
        if (npc == null || Util.isOffHand(event)) {
            return;
        }
        if (npc.hasTrait(ClickRedirectTrait.class) && (npc = npc.getTraitNullable(ClickRedirectTrait.class).getRedirectNPC()) == null) {
            return;
        }
        Player player = event.getPlayer();
        NPCRightClickEvent rightClickEvent = new NPCRightClickEvent(npc, player);
        Bukkit.getPluginManager().callEvent((Event)rightClickEvent);
        if (rightClickEvent.isCancelled()) {
            event.setCancelled(true);
            return;
        }
        if (SUPPORT_STOP_USE_ITEM) {
            try {
                PlayerAnimation.STOP_USE_ITEM.play(player);
            }
            catch (UnsupportedOperationException e) {
                SUPPORT_STOP_USE_ITEM = false;
            }
        }
        if (npc.hasTrait(CommandTrait.class)) {
            npc.getTraitNullable(CommandTrait.class).dispatch(player, CommandTrait.Hand.RIGHT);
        }
        if (npc.hasTrait(ShopTrait.class)) {
            npc.getTraitNullable(ShopTrait.class).onRightClick(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.skinUpdateTracker.updatePlayer(event.getPlayer(), Settings.Setting.INITIAL_PLAYER_JOIN_SKIN_PACKET_DELAY_TICKS.asInt(), true);
        ScoreboardTrait.onPlayerJoin(event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerLeashEntity(PlayerLeashEntityEvent event) {
        NPC npc = CitizensAPI.getNPCRegistry().getNPC(event.getEntity());
        if (npc == null) {
            return;
        }
        boolean leashProtected = npc.isProtected();
        if (npc.data().get("protected-leash", Boolean.valueOf(leashProtected)).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        this.skinUpdateTracker.onPlayerMove(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        NPC npc;
        Editor.leave(event.getPlayer());
        if (event.getPlayer().isInsideVehicle() && (npc = CitizensAPI.getNPCRegistry().getNPC(event.getPlayer().getVehicle())) != null) {
            event.getPlayer().leaveVehicle();
        }
        this.skinUpdateTracker.removePlayer(event.getPlayer().getUniqueId());
        ScoreboardTrait.onPlayerQuit(event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        this.skinUpdateTracker.updatePlayer(event.getPlayer(), 15L, true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerTeleport(final PlayerTeleportEvent event) {
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN && !event.getPlayer().hasMetadata("citizens-force-teleporting") && CitizensAPI.getNPCRegistry().getNPC((Entity)event.getPlayer()) != null && Settings.Setting.TELEPORT_DELAY.asInt() > 0) {
            event.setCancelled(true);
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    event.getPlayer().setMetadata("citizens-force-teleporting", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
                    event.getPlayer().teleport(event.getTo());
                    event.getPlayer().removeMetadata("citizens-force-teleporting", CitizensAPI.getPlugin());
                }
            }, (long)Settings.Setting.TELEPORT_DELAY.asInt());
        }
        this.skinUpdateTracker.updatePlayer(event.getPlayer(), 15L, true);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        PluginDescriptionFile file = event.getPlugin().getDescription();
        for (String plugin : Iterables.concat((Iterable)file.getDepend(), (Iterable)file.getSoftDepend())) {
            if (!plugin.equalsIgnoreCase("citizens") || !CitizensAPI.hasImplementation()) continue;
            ((Citizens)CitizensAPI.getPlugin()).onDependentPluginDisable();
            break;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPotionSplashEvent(PotionSplashEvent event) {
        for (LivingEntity entity : event.getAffectedEntities()) {
            NPC npc = CitizensAPI.getNPCRegistry().getNPC((Entity)entity);
            if (npc == null || !npc.isProtected()) continue;
            event.setIntensity(entity, 0.0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileHit(final ProjectileHitEvent event) {
        if (!(event.getEntity() instanceof FishHook)) {
            return;
        }
        NMS.removeHookIfNecessary(CitizensAPI.getNPCRegistry(), (FishHook)event.getEntity());
        new BukkitRunnable(){
            int n = 0;

            public void run() {
                if (this.n++ > 5) {
                    this.cancel();
                }
                NMS.removeHookIfNecessary(CitizensAPI.getNPCRegistry(), (FishHook)event.getEntity());
            }
        }.runTaskTimer(CitizensAPI.getPlugin(), 0L, 1L);
    }

    @EventHandler
    public void onVehicleDamage(VehicleDamageEvent event) {
        NPC npc = CitizensAPI.getNPCRegistry().getNPC((Entity)event.getVehicle());
        if (npc == null) {
            return;
        }
        event.setCancelled(npc.isProtected());
        NPCVehicleDamageEvent damageEvent = new NPCVehicleDamageEvent(npc, event);
        Bukkit.getPluginManager().callEvent((Event)damageEvent);
        if (!damageEvent.isCancelled() || !(damageEvent.getDamager() instanceof Player)) {
            return;
        }
        Player damager = (Player)damageEvent.getDamager();
        NPCLeftClickEvent leftClickEvent = new NPCLeftClickEvent(npc, damager);
        Bukkit.getPluginManager().callEvent((Event)leftClickEvent);
        if (npc.hasTrait(CommandTrait.class)) {
            npc.getTraitNullable(CommandTrait.class).dispatch(damager, CommandTrait.Hand.LEFT);
        }
    }

    @EventHandler
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        NPC npc = CitizensAPI.getNPCRegistry().getNPC((Entity)event.getVehicle());
        if (npc == null) {
            return;
        }
        event.setCancelled(npc.isProtected());
    }

    @EventHandler(ignoreCancelled=true)
    public void onVehicleEnter(VehicleEnterEvent event) {
        NPC npc = CitizensAPI.getNPCRegistry().getNPC((Entity)event.getVehicle());
        NPC rider = CitizensAPI.getNPCRegistry().getNPC(event.getEntered());
        if (npc == null) {
            if (rider != null && rider.isProtected() && (event.getVehicle().getType().name().contains("BOAT") || event.getVehicle() instanceof Minecart)) {
                event.setCancelled(true);
            }
            return;
        }
        if (!(!(npc.getEntity() instanceof Vehicle) || npc.hasTrait(Controllable.class) && npc.getTraitNullable(Controllable.class).isEnabled())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onWorldLoad(WorldLoadEvent event) {
        for (ChunkCoord chunk : this.toRespawn.keySet()) {
            if (!chunk.worldUUID.equals(event.getWorld().getUID()) || !event.getWorld().isChunkLoaded(chunk.x, chunk.z)) continue;
            this.respawnAllFromCoord(chunk, (Event)event);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent event) {
        System.out.println(event.getWorld());
        for (NPC npc : this.getAllNPCs()) {
            if (npc == null || !npc.isSpawned() || !npc.getEntity().getWorld().equals(event.getWorld())) continue;
            boolean despawned = npc.despawn(DespawnReason.WORLD_UNLOAD);
            if (event.isCancelled() || !despawned) {
                for (ChunkCoord coord : this.toRespawn.keySet()) {
                    if (!event.getWorld().getUID().equals(coord.worldUUID)) continue;
                    this.respawnAllFromCoord(coord, (Event)event);
                }
                event.setCancelled(true);
                return;
            }
            if (!npc.isSpawned()) continue;
            this.toRespawn.put((Object)new ChunkCoord(npc.getEntity().getLocation()), (Object)npc);
            Messaging.debug("Despawned", npc, "due to world unload at", event.getWorld().getName());
        }
    }

    private void respawnAllFromCoord(ChunkCoord coord, Event event) {
        ArrayList ids = Lists.newArrayList((Iterable)this.toRespawn.get((Object)coord));
        if (ids.size() > 0) {
            Messaging.debug("Respawning all NPCs at", coord, "due to", event);
        }
        for (int i = 0; i < ids.size(); ++i) {
            NPC npc = (NPC)ids.get(i);
            if (npc.getOwningRegistry().getById(npc.getId()) != npc) {
                if (!Messaging.isDebugging()) continue;
                Messaging.debug("Prevented deregistered NPC from respawning", npc);
                continue;
            }
            if (npc.isSpawned()) {
                if (!Messaging.isDebugging()) continue;
                Messaging.debug("Can't respawn NPC", npc, ": already spawned");
                continue;
            }
            boolean success = this.spawn(npc);
            if (!success) {
                ids.remove(i--);
                if (!Messaging.isDebugging()) continue;
                Messaging.debug("Couldn't respawn", npc, "during", event, "at", coord);
                continue;
            }
            if (!Messaging.isDebugging()) continue;
            Messaging.debug("Spawned", npc, "during", event, "at", coord);
        }
        for (NPC npc : ids) {
            this.toRespawn.remove((Object)coord, (Object)npc);
        }
    }

    private boolean spawn(NPC npc) {
        Location spawn = npc.getOrAddTrait(CurrentLocation.class).getLocation();
        if (spawn == null) {
            if (Messaging.isDebugging()) {
                Messaging.debug("Couldn't find a spawn location for despawned NPC", npc);
            }
            return false;
        }
        return npc.spawn(spawn, SpawnReason.CHUNK_LOAD);
    }

    void unloadNPCs(final ChunkEvent event, List<Entity> entities) {
        ArrayList toDespawn = Lists.newArrayList();
        for (Entity entity : entities) {
            NPC npc = CitizensAPI.getNPCRegistry().getNPC(entity);
            if (npc == null || npc.getEntity() == null) continue;
            toDespawn.add(npc);
        }
        if (toDespawn.isEmpty()) {
            return;
        }
        ChunkCoord coord = new ChunkCoord(event.getChunk());
        boolean loadChunk = false;
        for (NPC npc : toDespawn) {
            if (!npc.despawn(DespawnReason.CHUNK_UNLOAD)) {
                if (!(event instanceof Cancellable)) {
                    if (Messaging.isDebugging()) {
                        Messaging.debug("Reloading chunk because", npc, "couldn't despawn");
                    }
                    loadChunk = true;
                    this.toRespawn.put((Object)coord, (Object)npc);
                    continue;
                }
                ((Cancellable)event).setCancelled(true);
                Messaging.debug("Cancelled chunk unload at", coord);
                this.respawnAllFromCoord(coord, (Event)event);
                return;
            }
            this.toRespawn.put((Object)coord, (Object)npc);
            if (!Messaging.isDebugging()) continue;
            Messaging.debug("Despawned", npc, "due to chunk unload at", coord);
        }
        if (Messaging.isDebugging() && Settings.Setting.DEBUG_CHUNK_LOADS.asBoolean()) {
            new Exception("CITIZENS CHUNK UNLOAD DEBUG " + coord).printStackTrace();
        }
        if (loadChunk) {
            if (Messaging.isDebugging()) {
                Messaging.debug("Loading chunk in 10 ticks due to forced chunk load at", coord);
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    if (!event.getChunk().isLoaded()) {
                        event.getChunk().load();
                    }
                }
            }, 10L);
        }
    }
}

