/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import clib.net.byteflux.libby.BukkitLibraryManager;
import clib.net.byteflux.libby.Library;
import clib.net.byteflux.libby.logging.LogLevel;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import net.citizensnpcs.CitizensPlaceholders;
import net.citizensnpcs.EventListen;
import net.citizensnpcs.Metrics;
import net.citizensnpcs.PaymentListener;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.InventoryHelper;
import net.citizensnpcs.api.SkullMetaProvider;
import net.citizensnpcs.api.ai.speech.SpeechFactory;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.Injector;
import net.citizensnpcs.api.event.CitizensDisableEvent;
import net.citizensnpcs.api.event.CitizensEnableEvent;
import net.citizensnpcs.api.event.CitizensPreReloadEvent;
import net.citizensnpcs.api.event.CitizensReloadEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.npc.SimpleNPCDataStore;
import net.citizensnpcs.api.scripting.EventRegistrar;
import net.citizensnpcs.api.scripting.ObjectProvider;
import net.citizensnpcs.api.scripting.ScriptCompiler;
import net.citizensnpcs.api.trait.TraitFactory;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.NBTStorage;
import net.citizensnpcs.api.util.Storage;
import net.citizensnpcs.api.util.Translator;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.commands.AdminCommands;
import net.citizensnpcs.commands.EditorCommands;
import net.citizensnpcs.commands.NPCCommands;
import net.citizensnpcs.commands.TemplateCommands;
import net.citizensnpcs.commands.TraitCommands;
import net.citizensnpcs.commands.WaypointCommands;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.CitizensNPCRegistry;
import net.citizensnpcs.npc.CitizensTraitFactory;
import net.citizensnpcs.npc.NPCSelector;
import net.citizensnpcs.npc.ai.speech.CitizensSpeechFactory;
import net.citizensnpcs.npc.profile.ProfileFetcher;
import net.citizensnpcs.npc.skin.Skin;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerUpdateTask;
import net.citizensnpcs.util.Util;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Citizens
extends JavaPlugin
implements CitizensPlugin {
    private final List<NPCRegistry> anonymousRegistries = Lists.newArrayList();
    private final List<NPCRegistry> citizensBackedRegistries = Lists.newArrayList();
    private final CommandManager commands = new CommandManager();
    private Settings config;
    private boolean enabled;
    private final InventoryHelper inventoryHelper = new InventoryHelper(){

        @Override
        public InventoryView openAnvilInventory(Player player, Inventory inventory, String title) {
            return NMS.openAnvilInventory(player, inventory, title);
        }

        @Override
        public void updateInventoryTitle(Player player, InventoryView view, String newTitle) {
            if (view.getTopInventory().getType() == InventoryType.CRAFTING || view.getTopInventory().getType() == InventoryType.CREATIVE || view.getTopInventory().getType() == InventoryType.PLAYER) {
                return;
            }
            NMS.updateInventoryTitle(player, view, newTitle);
        }
    };
    private CitizensNPCRegistry npcRegistry;
    private boolean saveOnDisable = true;
    private NPCDataStore saves;
    private NPCSelector selector;
    private Storage shops;
    private final SkullMetaProvider skullMetaProvider = new SkullMetaProvider(){

        @Override
        public String getTexture(SkullMeta meta) {
            if (NMS.getProfile(meta) == null) {
                return null;
            }
            return ((Property)Iterables.getFirst((Iterable)NMS.getProfile(meta).getProperties().get((Object)"textures"), (Object)new Property("", ""))).getValue();
        }

        @Override
        public void setTexture(String string, SkullMeta meta) {
            UUID uuid = meta.getOwningPlayer() == null ? UUID.randomUUID() : meta.getOwningPlayer().getUniqueId();
            NMS.setProfile(meta, new GameProfile(uuid, string));
        }
    };
    private CitizensSpeechFactory speechFactory;
    private final Map<String, NPCRegistry> storedRegistries = Maps.newHashMap();
    private CitizensTraitFactory traitFactory;

    @Override
    public NPCRegistry createAnonymousNPCRegistry(NPCDataStore store) {
        CitizensNPCRegistry anon = new CitizensNPCRegistry(store, "anonymous-" + UUID.randomUUID().toString());
        this.anonymousRegistries.add(anon);
        return anon;
    }

    @Override
    public NPCRegistry createCitizensBackedNPCRegistry(NPCDataStore store) {
        CitizensNPCRegistry anon = new CitizensNPCRegistry(store, "anonymous-citizens-" + UUID.randomUUID().toString());
        this.citizensBackedRegistries.add(anon);
        return anon;
    }

    @Override
    public NPCRegistry createNamedNPCRegistry(String name, NPCDataStore store) {
        CitizensNPCRegistry created = new CitizensNPCRegistry(store, name);
        this.storedRegistries.put(name, created);
        return created;
    }

    private NPCDataStore createStorage(File folder) {
        Storage saves = null;
        String type = Settings.Setting.STORAGE_TYPE.asString();
        if (type.equalsIgnoreCase("nbt")) {
            saves = new NBTStorage(new File(folder + File.separator + Settings.Setting.STORAGE_FILE.asString()), "Citizens NPC Storage");
        }
        if (saves == null) {
            saves = new YamlStorage(new File(folder, Settings.Setting.STORAGE_FILE.asString()), "Citizens NPC Storage");
        }
        if (!saves.load()) {
            return null;
        }
        return SimpleNPCDataStore.create(saves);
    }

    private void despawnNPCs(boolean save) {
        for (NPCRegistry registry : Iterables.concat(Arrays.asList(this.npcRegistry), this.citizensBackedRegistries)) {
            if (registry == null) continue;
            if (save) {
                registry.saveToStore();
            }
            registry.despawnNPCs(DespawnReason.RELOAD);
        }
    }

    private void enableSubPlugins() {
        File[] files;
        File root = new File(this.getDataFolder(), Settings.Setting.SUBPLUGIN_FOLDER.asString());
        if (!root.exists() || !root.isDirectory()) {
            return;
        }
        for (File file : files = root.listFiles()) {
            Plugin plugin;
            try {
                plugin = Bukkit.getPluginManager().loadPlugin(file);
            }
            catch (Exception e) {
                continue;
            }
            if (plugin == null) continue;
            try {
                Messaging.logTr("citizens.sub-plugins.load", plugin.getDescription().getFullName());
                plugin.onLoad();
            }
            catch (Throwable ex) {
                Messaging.severeTr("citizens.sub-plugins.error-on-load", ex.getMessage(), plugin.getDescription().getFullName());
                ex.printStackTrace();
            }
        }
        NMS.loadPlugins();
    }

    @Override
    public CommandManager getCommandManager() {
        return this.commands;
    }

    @Override
    public net.citizensnpcs.api.npc.NPCSelector getDefaultNPCSelector() {
        return this.selector;
    }

    @Override
    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    @Override
    public NPCRegistry getNamedNPCRegistry(String name) {
        if (name.equals(this.npcRegistry.getName())) {
            return this.npcRegistry;
        }
        return this.storedRegistries.get(name);
    }

    @Override
    public Iterable<NPCRegistry> getNPCRegistries() {
        return new Iterable<NPCRegistry>(){

            @Override
            public Iterator<NPCRegistry> iterator() {
                return new Iterator<NPCRegistry>(){
                    Iterator<NPCRegistry> stored;

                    @Override
                    public boolean hasNext() {
                        return this.stored == null ? true : this.stored.hasNext();
                    }

                    @Override
                    public NPCRegistry next() {
                        if (this.stored == null) {
                            this.stored = Iterables.concat(Citizens.this.storedRegistries.values(), (Iterable)Citizens.this.anonymousRegistries, (Iterable)Citizens.this.citizensBackedRegistries).iterator();
                            return Citizens.this.npcRegistry;
                        }
                        return this.stored.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public NPCRegistry getNPCRegistry() {
        return this.npcRegistry;
    }

    public NPCSelector getNPCSelector() {
        return this.selector;
    }

    @Override
    public ClassLoader getOwningClassLoader() {
        return this.getClassLoader();
    }

    @Override
    public File getScriptFolder() {
        return new File(this.getDataFolder(), "scripts");
    }

    @Override
    public SkullMetaProvider getSkullMetaProvider() {
        return this.skullMetaProvider;
    }

    @Override
    public SpeechFactory getSpeechFactory() {
        return this.speechFactory;
    }

    @Override
    public TraitFactory getTraitFactory() {
        return this.traitFactory;
    }

    private void loadMavenLibraries() {
        this.getLogger().info("Loading external libraries...");
        BukkitLibraryManager lib = new BukkitLibraryManager(this);
        lib.addMavenCentral();
        lib.setLogLevel(LogLevel.WARN);
        lib.loadLibrary(Library.builder().groupId("ch{}ethz{}globis{}phtree").artifactId("phtree").version("2.5.0").relocate("ch{}ethz{}globis{}phtree", "clib{}phtree").build());
        lib.loadLibrary(Library.builder().groupId("net{}sf{}trove4j").artifactId("trove4j").version("3.0.3").relocate("gnu{}trove", "clib{}trove").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-minimessage").version("4.11.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-platform-bukkit").version("4.1.2").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-platform-api").version("4.1.2").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-platform-facet").version("4.1.2").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-platform-viaversion").version("4.1.2").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-api").version("4.11.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-bungeecord").version("4.1.2").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-legacy").version("4.11.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-gson").version("4.11.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-text-serializer-gson-legacy-impl").version("4.11.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-nbt").version("4.11.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("adventure-key").version("4.11.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("examination-api").version("1.3.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        lib.loadLibrary(Library.builder().groupId("net{}kyori").artifactId("examination-string").version("1.3.0").relocate("net{}kyori", "clib{}net{}kyori").build());
        this.getLogger().info("Loaded.");
    }

    public boolean onCommand(CommandSender sender, Command command, String cmdName, String[] args) {
        Object[] methodArgs = new Object[]{sender, this.selector == null ? null : this.selector.getSelected(sender)};
        return this.commands.executeSafe(command, args, sender, methodArgs);
    }

    public void onDependentPluginDisable() {
        this.storeNPCs(false);
        this.saveOnDisable = false;
    }

    public void onDisable() {
        if (!this.enabled) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new CitizensDisableEvent());
        Editor.leaveAll();
        this.despawnNPCs(this.saveOnDisable);
        HandlerList.unregisterAll((Plugin)this);
        this.npcRegistry = null;
        this.enabled = false;
        this.saveOnDisable = true;
        NMS.shutdown();
        CitizensAPI.shutdown();
    }

    public void onEnable() {
        this.loadMavenLibraries();
        CitizensAPI.setImplementation(this);
        this.config = new Settings(this.getDataFolder());
        this.setupTranslator();
        String mcVersion = Util.getMinecraftRevision();
        try {
            NMS.loadBridge(mcVersion);
        }
        catch (Exception e) {
            if (Messaging.isDebugging()) {
                e.printStackTrace();
            }
            Messaging.severeTr("citizens.notifications.incompatible-version", this.getDescription().getVersion(), mcVersion);
            this.enabled = true;
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerScriptHelpers();
        this.saves = this.createStorage(this.getDataFolder());
        this.shops = new YamlStorage(new File(this.getDataFolder(), "shops.yml"));
        if (this.saves == null || !this.shops.load()) {
            Messaging.severeTr("citizens.saves.load-failed", new Object[0]);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.speechFactory = new CitizensSpeechFactory();
        this.npcRegistry = new CitizensNPCRegistry(this.saves, "citizens");
        this.traitFactory = new CitizensTraitFactory();
        this.selector = new NPCSelector(this);
        Bukkit.getPluginManager().registerEvents((Listener)new EventListen(this.storedRegistries), (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new CitizensPlaceholders(this.selector).register();
        }
        this.setupEconomy();
        this.registerCommands();
        this.enableSubPlugins();
        NMS.load(this.commands);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.commands.registerTabCompletion(this);
        if (this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)new CitizensLoadTask(), 1L) == -1) {
            Messaging.severeTr("citizens.load-task-error", new Object[0]);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    @Override
    public void onImplementationChanged() {
        Messaging.severeTr("citizens.changed-implementation", new Object[0]);
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    public void registerCommandClass(Class<?> clazz) {
        try {
            this.commands.register(clazz);
        }
        catch (Throwable ex) {
            Messaging.logTr("citizens.commands.invalid.class", new Object[0]);
            ex.printStackTrace();
        }
    }

    private void registerCommands() {
        this.commands.setInjector(new Injector(this));
        this.commands.register(AdminCommands.class);
        this.commands.register(EditorCommands.class);
        this.commands.register(NPCCommands.class);
        this.commands.register(TemplateCommands.class);
        this.commands.register(TraitCommands.class);
        this.commands.register(WaypointCommands.class);
    }

    private void registerScriptHelpers() {
        ScriptCompiler compiler = CitizensAPI.getScriptCompiler();
        compiler.registerGlobalContextProvider(new EventRegistrar(this));
        compiler.registerGlobalContextProvider(new ObjectProvider("plugin", this));
    }

    public void reload() throws NPCLoadException {
        Editor.leaveAll();
        this.config.reload();
        this.despawnNPCs(false);
        ProfileFetcher.reset();
        Skin.clearCache();
        this.getServer().getPluginManager().callEvent((Event)new CitizensPreReloadEvent());
        this.saves.reloadFromSource();
        this.saves.loadInto(this.npcRegistry);
        this.shops.load();
        ShopTrait.loadShops(this.shops.getKey(""));
        this.getServer().getPluginManager().callEvent((Event)new CitizensReloadEvent());
    }

    @Override
    public void removeNamedNPCRegistry(String name) {
        this.storedRegistries.remove(name);
    }

    private void scheduleSaveTask(int delay) {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new CitizensSaveTask(), (long)delay, (long)delay);
    }

    @Override
    public void setDefaultNPCDataStore(NPCDataStore store) {
        if (store == null) {
            throw new IllegalArgumentException("must be non-null");
        }
        this.despawnNPCs(true);
        this.saves = store;
        this.npcRegistry = new CitizensNPCRegistry(this.saves, "citizens-global-" + UUID.randomUUID().toString());
        this.saves.loadInto(this.npcRegistry);
    }

    private void setupEconomy() {
        try {
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
            if (provider != null && provider.getProvider() != null) {
                Economy economy = (Economy)provider.getProvider();
                Bukkit.getPluginManager().registerEvents((Listener)new PaymentListener(economy), (Plugin)this);
            }
            Messaging.logTr("citizens.economy.loaded", new Object[0]);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private void setupTranslator() {
        Locale locale = Locale.getDefault();
        String setting = Settings.Setting.LOCALE.asString();
        if (!setting.isEmpty()) {
            String[] parts = setting.split("[\\._]");
            switch (parts.length) {
                case 1: {
                    locale = new Locale(parts[0]);
                    break;
                }
                case 2: {
                    locale = new Locale(parts[0], parts[1]);
                    break;
                }
                case 3: {
                    locale = new Locale(parts[0], parts[1], parts[2]);
                    break;
                }
            }
        }
        Translator.setInstance(new File(this.getDataFolder(), "lang"), locale);
    }

    private void startMetrics() {
        try {
            Metrics metrics = new Metrics(this, 2463);
            metrics.addCustomChart(new Metrics.SingleLineChart("total_npcs", new Callable<Integer>(){

                @Override
                public Integer call() {
                    if (Citizens.this.npcRegistry == null) {
                        return 0;
                    }
                    return Iterables.size((Iterable)Citizens.this.npcRegistry);
                }
            }));
        }
        catch (Exception e) {
            Messaging.logTr("citizens.notifications.metrics-load-error", e.getMessage());
        }
    }

    public void storeNPCs() {
        this.storeNPCs(false);
    }

    public void storeNPCs(boolean async) {
        if (this.saves == null) {
            return;
        }
        this.saves.storeAll(this.npcRegistry);
        ShopTrait.saveShops(this.shops.getKey(""));
        if (async) {
            this.saves.saveToDisk();
            new Thread(() -> this.shops.save()).start();
        } else {
            this.shops.save();
            this.saves.saveToDiskImmediate();
        }
    }

    private class CitizensLoadTask
    implements Runnable {
        private CitizensLoadTask() {
        }

        @Override
        public void run() {
            Citizens.this.saves.loadInto(Citizens.this.npcRegistry);
            ShopTrait.loadShops(Citizens.this.shops.getKey(""));
            Messaging.logTr("citizens.notifications.npcs-loaded", Iterables.size((Iterable)Citizens.this.npcRegistry), "?");
            Citizens.this.startMetrics();
            Citizens.this.scheduleSaveTask(Settings.Setting.SAVE_TASK_DELAY.asInt());
            Bukkit.getPluginManager().callEvent((Event)new CitizensEnableEvent());
            new PlayerUpdateTask().runTaskTimer(Citizens.this, 0L, 1L);
            Citizens.this.enabled = true;
        }
    }

    private class CitizensSaveTask
    implements Runnable {
        private CitizensSaveTask() {
        }

        @Override
        public void run() {
            Citizens.this.storeNPCs(false);
        }
    }
}

