/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.version;

import io.lumine.mythic.lib.UtilityMethods;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.bukkit.Sound;
import org.jetbrains.annotations.NotNull;

public class Sounds {
    public static final Sound ENTITY_ENDERMAN_HURT = Sounds.fromName("ENTITY_ENDERMAN_HURT", "ENTITY_ENDERMEN_HURT");
    public static final Sound ENTITY_ENDERMAN_DEATH = Sounds.fromName("ENTITY_ENDERMAN_DEATH", "ENTITY_ENDERMEN_DEATH");
    public static final Sound ENTITY_ENDERMAN_TELEPORT = Sounds.fromName("ENTITY_ENDERMAN_TELEPORT", "ENTITY_ENDERMEN_TELEPORT");
    public static final Sound ENTITY_FIREWORK_ROCKET_LARGE_BLAST = Sounds.fromName("ENTITY_FIREWORK_ROCKET_LARGE_BLAST", "ENTITY_FIREWORK_LARGE_BLAST");
    public static final Sound ENTITY_FIREWORK_ROCKET_TWINKLE = Sounds.fromName("ENTITY_FIREWORK_ROCKET_TWINKLE", "ENTITY_FIREWORK_TWINKLE");
    public static final Sound ENTITY_FIREWORK_ROCKET_BLAST = Sounds.fromName("ENTITY_FIREWORK_ROCKET_BLAST", "ENTITY_FIREWORK_BLAST");
    public static final Sound ENTITY_ZOMBIE_PIGMAN_ANGRY = Sounds.fromName("ENTITY_ZOMBIE_PIGMAN_ANGRY", "ENTITY_ZOMBIFIED_PIGLIN_ANGRY", "ENTITY_ZOMBIE_PIG_ANGRY");
    public static final Sound BLOCK_NOTE_BLOCK_HAT = Sounds.fromName("BLOCK_NOTE_BLOCK_HAT", "BLOCK_NOTE_HAT");
    public static final Sound BLOCK_NOTE_BLOCK_PLING = Sounds.fromName("BLOCK_NOTE_BLOCK_PLING", "BLOCK_NOTE_PLING");
    public static final Sound BLOCK_NOTE_BLOCK_BELL = Sounds.fromName("BLOCK_NOTE_BLOCK_BELL", "BLOCK_NOTE_BELL");
    public static final Sound ENTITY_ZOMBIE_ATTACK_WOODEN_DOOR = Sounds.fromName("ENTITY_ZOMBIE_ATTACK_WOODEN_DOOR", "ENTITY_ZOMBIE_ATTACK_DOOR_WOOD");
    public static final Sound ENTITY_ENDER_DRAGON_GROWL = Sounds.fromName("ENTITY_ENDER_DRAGON_GROWL", "ENTITY_ENDERDRAGON_GROWL");
    public static final Sound ENTITY_ENDER_DRAGON_FLAP = Sounds.fromName("ENTITY_ENDER_DRAGON_FLAP", "ENTITY_ENDERDRAGON_FLAP");
    public static final Sound ENTITY_ZOMBIE_ATTACK_IRON_DOOR = Sounds.fromName("ENTITY_ZOMBIE_ATTACK_IRON_DOOR");
    public static final Sound ENTITY_PLAYER_ATTACK_CRIT = Sounds.fromName("ENTITY_PLAYER_ATTACK_CRIT");
    public static final Sound BLOCK_END_PORTAL_FRAME_FILL = Sounds.fromName("BLOCK_END_PORTAL_FRAME_FILL");
    public static final Sound ENTITY_SNOWBALL_THROW = Sounds.fromName("ENTITY_SNOWBALL_THROW");
    public static final Sound BLOCK_BREWING_STAND_BREW = Sounds.fromName("BLOCK_BREWING_STAND_BREW");
    public static final Sound BLOCK_GLASS_BREAK = Sounds.fromName("BLOCK_GLASS_BREAK");
    public static final Sound ENTITY_GENERIC_EXPLODE = Sounds.fromName("ENTITY_GENERIC_EXPLODE");
    public static final Sound ENTITY_EXPERIENCE_ORB_PICKUP = Sounds.fromName("ENTITY_EXPERIENCE_ORB_PICKUP");
    public static final Sound ENTITY_WITCH_DRINK = Sounds.fromName("ENTITY_WITCH_DRINK");
    public static final Sound BLOCK_FIRE_AMBIENT = Sounds.fromName("BLOCK_FIRE_AMBIENT");
    public static final Sound ENTITY_CHICKEN_EGG = Sounds.fromName("ENTITY_CHICKEN_EGG");
    public static final Sound ENTITY_PLAYER_ATTACK_SWEEP = Sounds.fromName("ENTITY_PLAYER_ATTACK_SWEEP");
    public static final Sound ENTITY_BLAZE_HURT = Sounds.fromName("ENTITY_BLAZE_HURT");
    public static final Sound BLOCK_FIRE_EXTINGUISH = Sounds.fromName("BLOCK_FIRE_EXTINGUISH");
    public static final Sound BLOCK_SNOW_BREAK = Sounds.fromName("BLOCK_SNOW_BREAK");
    public static final Sound ENTITY_PLAYER_LEVELUP = Sounds.fromName("ENTITY_PLAYER_LEVELUP");
    public static final Sound BLOCK_GRAVEL_BREAK = Sounds.fromName("BLOCK_GRAVEL_BREAK");
    public static final Sound ENTITY_ZOMBIE_HURT = Sounds.fromName("ENTITY_ZOMBIE_HURT");
    public static final Sound ENTITY_COW_HURT = Sounds.fromName("ENTITY_COW_HURT");
    public static final Sound ENTITY_PLAYER_ATTACK_KNOCKBACK = Sounds.fromName("ENTITY_PLAYER_ATTACK_KNOCKBACK");
    public static final Sound ENTITY_SHEEP_DEATH = Sounds.fromName("ENTITY_SHEEP_DEATH");
    public static final Sound ENTITY_BLAZE_AMBIENT = Sounds.fromName("ENTITY_BLAZE_AMBIENT");
    public static final Sound ENTITY_LLAMA_ANGRY = Sounds.fromName("ENTITY_LLAMA_ANGRY");
    public static final Sound ENTITY_WITHER_SHOOT = Sounds.fromName("ENTITY_WITHER_SHOOT");
    public static final Sound BLOCK_ANVIL_LAND = Sounds.fromName("BLOCK_ANVIL_LAND");
    public static final Sound ENTITY_CHICKEN_HURT = Sounds.fromName("ENTITY_CHICKEN_HURT");
    public static final Sound ENTITY_VILLAGER_NO = Sounds.fromName("ENTITY_VILLAGER_NO");
    public static final Sound ENTITY_ITEM_BREAK = Sounds.fromName("ENTITY_ITEM_BREAK");
    public static final Sound UI_BUTTON_CLICK = Sounds.fromName("UI_BUTTON_CLICK");
    public static final Sound ENTITY_GENERIC_EAT = Sounds.fromName("ENTITY_GENERIC_EAT");
    public static final Sound BLOCK_IRON_DOOR_OPEN = Sounds.fromName("BLOCK_IRON_DOOR_OPEN");
    private static Function<String, Sound> RESOLVER;

    @NotNull
    public static Sound fromName(String ... candidates) {
        return UtilityMethods.resolveField(Sounds.getResolver(), candidates);
    }

    private static Function<String, Sound> getResolver() {
        if (RESOLVER == null) {
            try {
                Method method = Sound.class.getDeclaredMethod("valueOf", String.class);
                RESOLVER = str -> {
                    try {
                        return (Sound)method.invoke(null, str);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                };
            }
            catch (Exception exception) {
                throw new RuntimeException("Reflection error: " + exception.getMessage());
            }
        }
        return RESOLVER;
    }
}

