/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.version;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.attribute.Attribute;
import org.jetbrains.annotations.NotNull;

public class Attributes {
    private static final Map<String, Attribute> BY_SPIGOT_ID = new HashMap<String, Attribute>();
    private static final Map<Attribute, String> ATTRIBUTE_NAMES = new HashMap<Attribute, String>();
    private static Function<String, Attribute> RESOLVER;
    public static final Attribute ARMOR;
    public static final Attribute ARMOR_TOUGHNESS;
    public static final Attribute ATTACK_DAMAGE;
    public static final Attribute ATTACK_SPEED;
    public static final Attribute KNOCKBACK_RESISTANCE;
    public static final Attribute LUCK;
    public static final Attribute MAX_HEALTH;
    public static final Attribute MOVEMENT_SPEED;
    public static final Attribute FOLLOW_RANGE;

    @NotNull
    public static Attribute fromName(String ... candidates) {
        return UtilityMethods.resolveField(Attributes.getResolver(), candidates);
    }

    @NotNull
    public static String name(@NotNull Attribute attribute) {
        return ATTRIBUTE_NAMES.get(attribute);
    }

    private static Function<String, Attribute> getResolver() {
        if (RESOLVER == null) {
            try {
                Method method = Attribute.class.getDeclaredMethod("valueOf", String.class);
                RESOLVER = str -> {
                    try {
                        return (Attribute)method.invoke(null, str);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                };
            }
            catch (Exception exception) {
                throw new RuntimeException("Reflection error: " + exception.getMessage());
            }
        }
        return RESOLVER;
    }

    @NotNull
    public static Attribute adapt(@NotNull String id) {
        return Attributes.fromName(id, "GENERIC_" + id, "PLAYER_" + id);
    }

    @NotNull
    public static Collection<Attribute> getAll() {
        return BY_SPIGOT_ID.values();
    }

    static {
        if (MythicLib.plugin.getVersion().isUnder(1, 21, 2)) {
            try {
                for (Field field : Attribute.class.getDeclaredFields()) {
                    if (field.getType() != Attribute.class) continue;
                    Attribute attr = (Attribute)field.get(null);
                    BY_SPIGOT_ID.put(field.getName(), attr);
                    ATTRIBUTE_NAMES.put(attr, field.getName());
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Reflection error", exception);
            }
        } else {
            for (Attribute attribute : Attribute.values()) {
                String name = attribute.getKey().getKey().toUpperCase();
                BY_SPIGOT_ID.put(name, attribute);
                ATTRIBUTE_NAMES.put(attribute, name);
            }
        }
        ARMOR = Attributes.fromName("ARMOR", "GENERIC_ARMOR");
        ARMOR_TOUGHNESS = Attributes.fromName("ARMOR_TOUGHNESS", "GENERIC_ARMOR_TOUGHNESS");
        ATTACK_DAMAGE = Attributes.fromName("ATTACK_DAMAGE", "GENERIC_ATTACK_DAMAGE");
        ATTACK_SPEED = Attributes.fromName("ATTACK_SPEED", "GENERIC_ATTACK_SPEED");
        KNOCKBACK_RESISTANCE = Attributes.fromName("KNOCKBACK_RESISTANCE", "GENERIC_KNOCKBACK_RESISTANCE");
        LUCK = Attributes.fromName("LUCK", "GENERIC_LUCK");
        MAX_HEALTH = Attributes.fromName("MAX_HEALTH", "GENERIC_MAX_HEALTH");
        MOVEMENT_SPEED = Attributes.fromName("MOVEMENT_SPEED", "GENERIC_MOVEMENT_SPEED");
        FOLLOW_RANGE = Attributes.fromName("FOLLOW_RANGE", "GENERIC_FOLLOW_RANGE");
    }
}

