/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util.gson;

import io.lumine.mythic.lib.gson.JsonDeserializationContext;
import io.lumine.mythic.lib.gson.JsonDeserializer;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParseException;
import io.lumine.mythic.lib.gson.JsonSerializationContext;
import io.lumine.mythic.lib.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectAdapter
implements JsonSerializer<PotionEffect>,
JsonDeserializer<PotionEffect> {
    @Override
    public JsonElement serialize(PotionEffect effect, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject object = new JsonObject();
        object.addProperty("Type", effect.getType().getName());
        object.addProperty("Duration", effect.getDuration());
        object.addProperty("Amplifier", effect.getAmplifier());
        object.addProperty("Ambient", effect.isAmbient());
        object.addProperty("Particles", effect.hasParticles());
        object.addProperty("Icon", effect.hasIcon());
        return object;
    }

    @Override
    public PotionEffect deserialize(JsonElement element, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject object = element.getAsJsonObject();
        return new PotionEffect(PotionEffectType.getByName((String)object.get("Type").getAsString()), object.get("Duration").getAsInt(), object.get("Amplifier").getAsInt(), object.get("Ambient").getAsBoolean(), object.get("Particles").getAsBoolean(), object.get("Icon").getAsBoolean());
    }
}

