/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util.gson;

import io.lumine.mythic.lib.gson.JsonDeserializationContext;
import io.lumine.mythic.lib.gson.JsonDeserializer;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParseException;
import io.lumine.mythic.lib.gson.JsonSerializationContext;
import io.lumine.mythic.lib.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class LocationAdapter
implements JsonSerializer<Location>,
JsonDeserializer<Location> {
    @Override
    public Location deserialize(JsonElement element, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject object = element.getAsJsonObject();
        return new Location(Bukkit.getWorld((String)object.get("World").getAsString()), object.get("X").getAsDouble(), object.get("Y").getAsDouble(), object.get("Z").getAsDouble(), object.get("Yaw").getAsFloat(), object.get("Pitch").getAsFloat());
    }

    @Override
    public JsonElement serialize(Location location, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject object = new JsonObject();
        object.addProperty("World", location.getWorld().getName());
        object.addProperty("X", location.getX());
        object.addProperty("Y", location.getY());
        object.addProperty("Z", location.getZ());
        object.addProperty("Yaw", Float.valueOf(location.getYaw()));
        object.addProperty("Pitch", Float.valueOf(location.getPitch()));
        return object;
    }
}

