/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util.gson;

import io.lumine.mythic.lib.gson.JsonDeserializationContext;
import io.lumine.mythic.lib.gson.JsonDeserializer;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParseException;
import io.lumine.mythic.lib.gson.JsonSerializationContext;
import io.lumine.mythic.lib.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.UUID;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;

public class LegacyAttributeModifierAdapter
implements JsonSerializer<AttributeModifier>,
JsonDeserializer<AttributeModifier> {
    @Override
    public AttributeModifier deserialize(JsonElement element, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject object = element.getAsJsonObject();
        return new AttributeModifier(UUID.fromString(object.get("UUID").getAsString()), object.get("Name").getAsString(), object.get("Amount").getAsDouble(), AttributeModifier.Operation.valueOf((String)object.get("Operation").getAsString()), object.has("Slot") ? EquipmentSlot.valueOf((String)object.get("Slot").getAsString()) : null);
    }

    @Override
    public JsonElement serialize(AttributeModifier modifier, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject object = new JsonObject();
        object.addProperty("UUID", modifier.getUniqueId().toString());
        object.addProperty("Name", modifier.getName());
        object.addProperty("Amount", modifier.getAmount());
        object.addProperty("Operation", modifier.getOperation().name());
        if (modifier.getSlot() != null) {
            object.addProperty("Slot", modifier.getSlot().name());
        }
        return object;
    }
}

