/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util.configobject;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.script.Script;
import io.lumine.mythic.lib.script.targeter.EntityTargeter;
import io.lumine.mythic.lib.script.targeter.LocationTargeter;
import io.lumine.mythic.lib.util.DoubleFormula;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ConfigObject {
    public String getString(String var1);

    public String getString(String var1, String var2);

    public double getDouble(String var1);

    public double getDouble(String var1, double var2);

    public int getInt(String var1);

    public int getInt(String var1, int var2);

    public boolean getBoolean(String var1);

    public boolean getBoolean(String var1, boolean var2);

    default public DoubleFormula getDoubleFormula(String key) {
        return new DoubleFormula(this.getString(key));
    }

    default public DoubleFormula getDoubleFormula(String key, DoubleFormula defaultValue) {
        return this.contains(key) ? this.getDoubleFormula(key) : Objects.requireNonNull(defaultValue, "Default value cannot be null");
    }

    @Nullable
    default public Script getScriptOrNull(String key) {
        return this.contains(key) ? MythicLib.plugin.getSkills().getScriptOrThrow(this.getString(key)) : null;
    }

    @NotNull
    default public Script getScript(String key) {
        return MythicLib.plugin.getSkills().getScriptOrThrow(this.getString(key));
    }

    @NotNull
    default public EntityTargeter getEntityTargeter(String key) {
        return MythicLib.plugin.getSkills().loadEntityTargeter(this.adaptObject(key));
    }

    @NotNull
    default public LocationTargeter getLocationTargeter(String key) {
        return MythicLib.plugin.getSkills().loadLocationTargeter(this.adaptObject(key));
    }

    @NotNull
    public ConfigObject getObject(String var1);

    @NotNull
    public ConfigObject adaptObject(String var1);

    public boolean contains(String var1);

    @NotNull
    public Set<String> getKeys();

    @Nullable
    public String getKey();

    default public boolean hasKey() {
        return this.getKey() != null;
    }

    default public void validateKeys(String ... keys) {
        for (String key : keys) {
            Validate.isTrue(this.contains(key), "Could not find key '" + key + "' in config", new Object[0]);
        }
    }

    default public void validateArgs(int count) {
        Validate.isTrue(this.getKeys().size() >= count, "Config must have at least " + count + " parameters", new Object[0]);
    }
}

