/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util;

import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.util.lang3.Validate;
import io.lumine.mythic.lib.version.VParticle;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Consumer;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class RayTrace {
    private final LivingEntity hitEntity;
    private final double distanceTraveled;
    private final Location initialLocation;
    private final Vector initialDirection;
    private static final FluidCollisionMode FLUID_COLLISION_MODE = FluidCollisionMode.NEVER;
    private static final boolean IGNORE_PASSABLE_BLOCKS = true;
    private static final double RAY_SIZE = 0.2;

    public RayTrace(Player player, double range, Predicate<Entity> filter) {
        this(player.getEyeLocation(), player.getEyeLocation().getDirection(), range, filter);
    }

    public RayTrace(Player player, Vector direction, double range, Predicate<Entity> filter) {
        this(player.getEyeLocation(), direction, range, filter);
    }

    public RayTrace(Player player, EquipmentSlot hand, double range, Predicate<Entity> filter) {
        Validate.isTrue(hand.isHand(), "Not a hand equipment slot", new Object[0]);
        double a = Math.toRadians(player.getEyeLocation().getYaw() + 90.0f + (float)(45 * (hand == EquipmentSlot.MAIN_HAND ? 1 : -1)));
        this.initialLocation = player.getLocation().add(Math.cos(a) * 0.5, 1.5, Math.sin(a) * 0.5);
        this.initialDirection = player.getEyeLocation().getDirection();
        RayTraceResult result = this.initialLocation.getWorld().rayTrace(this.initialLocation, this.initialDirection, range, FLUID_COLLISION_MODE, true, 0.2, filter);
        this.hitEntity = result == null || result.getHitEntity() == null ? null : (LivingEntity)result.getHitEntity();
        this.distanceTraveled = result == null ? range : result.getHitPosition().distance(this.initialLocation.toVector());
    }

    public RayTrace(Location loc, Vector direction, double range, Predicate<Entity> filter) {
        RayTraceResult result = loc.getWorld().rayTrace(loc, direction, range, FLUID_COLLISION_MODE, true, 0.2, filter);
        this.hitEntity = result == null || result.getHitEntity() == null ? null : (LivingEntity)result.getHitEntity();
        this.distanceTraveled = result == null ? range : result.getHitPosition().distance(loc.toVector());
        this.initialDirection = direction;
        this.initialLocation = loc;
    }

    public boolean hasHit() {
        return this.hitEntity != null;
    }

    @Nullable
    public LivingEntity getHit() {
        return this.hitEntity;
    }

    public double getDistanceTraveled() {
        return this.distanceTraveled;
    }

    public void draw(double step, Color color) {
        this.draw(step, (Consumer<Location>)((Consumer)loc -> loc.getWorld().spawnParticle(VParticle.REDSTONE.get(), loc, 0, (Object)new Particle.DustOptions(color, 1.0f))));
    }

    public void draw(double step, Consumer<Location> tick) {
        for (double d = 0.0; d < this.distanceTraveled; d += step) {
            tick.accept((Object)this.initialLocation.clone().add(this.initialDirection.clone().multiply(d)));
        }
    }
}

