/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util;

import io.lumine.mythic.lib.util.PostLoadException;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostLoadAction {
    @Nullable
    private ConfigurationSection config;
    @Nullable
    private Consumer<ConfigurationSection> action;
    private final boolean persistent;

    public PostLoadAction(@NotNull Consumer<ConfigurationSection> action) {
        this(false, action);
    }

    public PostLoadAction(boolean persistent, @NotNull Consumer<ConfigurationSection> action) {
        this.persistent = persistent;
        this.action = Objects.requireNonNull(action, "Action cannot be null");
    }

    public void cacheConfig(@Nullable ConfigurationSection config) {
        if (this.action == null) {
            throw new PostLoadException("Object already post loaded");
        }
        Validate.isTrue(this.config == null, "Config already cached", new Object[0]);
        if (config != null) {
            this.config = config;
        }
    }

    @Nullable
    public ConfigurationSection getCachedConfig() {
        if (this.action == null) {
            throw new PostLoadException("Object already post loaded");
        }
        return this.config;
    }

    public void performAction() {
        if (this.action == null) {
            throw new PostLoadException("Object already post loaded");
        }
        Consumer<ConfigurationSection> action = this.action;
        if (!this.persistent) {
            this.action = null;
        }
        if (this.config != null) {
            ConfigurationSection config = this.config;
            this.config = null;
            action.accept(config);
        }
    }
}

