/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util;

import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class Lazy<T>
implements Supplier<T> {
    private final boolean persistent;
    @Nullable
    private Supplier<T> expression;
    private boolean evaluated;
    @Nullable
    private T value;

    private Lazy(@Nullable Supplier<T> expression, boolean persistent) {
        this.expression = expression;
        this.persistent = persistent;
    }

    public void flush() {
        Validate.isTrue(this.persistent, "Non persistent lazy value", new Object[0]);
        this.value = null;
        this.evaluated = false;
    }

    public static <T> Lazy<T> persistent(Supplier<T> expression) {
        return new Lazy<T>(expression, true);
    }

    public static <T> Lazy<T> of(Supplier<T> expression) {
        return new Lazy<T>(expression, true);
    }

    @Override
    public T get() {
        if (this.evaluated) {
            return this.value;
        }
        Validate.notNull(this.expression, "Non persistent lazy value", new Object[0]);
        this.value = this.expression.get();
        this.evaluated = true;
        if (!this.persistent) {
            this.expression = null;
        }
        return this.value;
    }
}

