/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.util.Closeable;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiPredicate;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class FlushableRegistry<K, V>
implements Closeable,
Listener {
    private final Map<K, V> registry = new HashMap();
    private final BiPredicate<K, V> condition;
    private final long period;
    private final BukkitRunnable flushRunnable = new BukkitRunnable(){

        public void run() {
            Iterator iterator = FlushableRegistry.this.registry.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (!FlushableRegistry.this.condition.test(next.getKey(), next.getValue())) continue;
                iterator.remove();
            }
        }
    };
    private boolean open = true;

    public FlushableRegistry(BiPredicate<K, V> condition, long period) {
        this.condition = condition;
        this.period = period;
        this.flushRunnable.runTaskTimer((Plugin)MythicLib.plugin, period, period);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)MythicLib.plugin);
    }

    @NotNull
    public Map<K, V> getRegistry() {
        return this.registry;
    }

    public boolean isOpen() {
        return this.open;
    }

    public long getPeriod() {
        return this.period;
    }

    @Override
    public void close() {
        Validate.isTrue(this.open, "Registry already closed", new Object[0]);
        this.open = false;
        this.flushRunnable.cancel();
        this.registry.clear();
        HandlerList.unregisterAll((Listener)this);
    }
}

