/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtils {
    public static <T> void iterateConfigSectionList(@NotNull ConfigurationSection config, @NotNull List<T> list, @NotNull Function<ConfigurationSection, T> subconfigHandler, @NotNull Function<Integer, T> fill, @NotNull BiConsumer<String, RuntimeException> errorHandler) {
        int expectedOrdinal = 1;
        for (String key : config.getKeys(false)) {
            try {
                int index = Integer.parseInt(key);
                ConfigurationSection subconfig = config.getConfigurationSection(key);
                Validate.notNull(subconfig, "Not a configuration section", new Object[0]);
                if (index < expectedOrdinal) {
                    list.set(index, subconfigHandler.apply(subconfig));
                    continue;
                }
                while (expectedOrdinal < index) {
                    list.add(fill.apply(expectedOrdinal++));
                }
                list.add(subconfigHandler.apply(subconfig));
                ++expectedOrdinal;
            }
            catch (RuntimeException exception) {
                errorHandler.accept(key, exception);
            }
        }
    }

    public static void loadObjectsFromFolder(@NotNull Plugin plugin, @NotNull String path, boolean singleObject, @NotNull BiConsumer<String, ConfigurationSection> action, @NotNull String errorMessageFormat) {
        Consumer<File> fileAction = file -> {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            if (singleObject) {
                try {
                    String name = file.getName().substring(0, file.getName().length() - 4);
                    action.accept(name, (ConfigurationSection)config);
                }
                catch (Throwable throwable) {
                    plugin.getLogger().log(Level.WARNING, UtilityMethods.format(errorMessageFormat, file.getName(), throwable.getMessage()));
                }
            } else {
                for (String key : config.getKeys(false)) {
                    try {
                        action.accept(key, config.getConfigurationSection(key));
                    }
                    catch (Throwable throwable) {
                        plugin.getLogger().log(Level.WARNING, UtilityMethods.format(errorMessageFormat, key, file.getName(), throwable.getMessage()));
                    }
                }
            }
        };
        FileUtils.exploreFolderRecursively(FileUtils.getFile(plugin, path), fileAction);
    }

    public static void loadObjectsFromFolderRaw(@NotNull Plugin plugin, @NotNull String path, @NotNull Consumer<File> action, @NotNull String errorMessageFormat) {
        Consumer<File> fileAction = file -> {
            try {
                action.accept((File)file);
            }
            catch (Throwable throwable) {
                plugin.getLogger().log(Level.WARNING, UtilityMethods.format(errorMessageFormat, file.getName(), throwable.getMessage()));
            }
        };
        FileUtils.exploreFolderRecursively(FileUtils.getFile(plugin, path), fileAction);
    }

    private static void exploreFolderRecursively(@Nullable File file, @NotNull Consumer<File> action) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            action.accept(file);
        } else {
            Arrays.stream(file.listFiles()).sorted().forEach(subfile -> FileUtils.exploreFolderRecursively(subfile, action));
        }
    }

    @NotNull
    public static File getFile(@NotNull Plugin plugin, @NotNull String path) {
        return new File(plugin.getDataFolder() + "/" + path);
    }

    public static boolean moveIfExists(@NotNull Plugin plugin, @NotNull String filePath, @NotNull String newFolderPath) {
        File existing = FileUtils.getFile(plugin, filePath);
        boolean result = existing.exists();
        if (result) {
            String fullPath = newFolderPath + "/" + filePath;
            FileUtils.mkdirFolders(plugin, fullPath);
            Validate.isTrue(existing.renameTo(FileUtils.getFile(plugin, fullPath)), "Could not move '" + filePath + "' to '" + newFolderPath + "'", new Object[0]);
        }
        return result;
    }

    private static void mkdirFolders(@NotNull Plugin plugin, @NotNull String fullPath) {
        String currentPath = "";
        String[] subpaths = fullPath.split("/");
        for (int i = 0; i < subpaths.length - 1; ++i) {
            currentPath = currentPath + "/" + subpaths[i];
            FileUtils.getFile(plugin, currentPath).mkdir();
        }
    }

    public static void copyDefaultFile(@NotNull Plugin plugin, @NotNull String path) {
        FileUtils.mkdirFolders(plugin, path);
        File file = new File(plugin.getDataFolder(), path);
        if (!file.exists()) {
            try {
                Files.copy(plugin.getResource("default/" + path), file.getAbsoluteFile().toPath(), new CopyOption[0]);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Could not load default file '" + path + "'", throwable);
            }
        }
    }
}

