/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.trigger;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class TriggerType {
    @NotNull
    public static TriggerType KILL_ENTITY = new TriggerType("KILL_ENTITY");
    @NotNull
    public static TriggerType KILL_PLAYER = new TriggerType("KILL_PLAYER");
    @NotNull
    public static TriggerType ATTACK = new TriggerType("ATTACK", true, true, true);
    @NotNull
    public static TriggerType DAMAGED = new TriggerType("DAMAGED");
    @NotNull
    public static TriggerType DAMAGED_BY_ENTITY = new TriggerType("DAMAGED_BY_ENTITY");
    @NotNull
    public static TriggerType DEATH = new TriggerType("DEATH");
    @NotNull
    public static TriggerType PLACE_BLOCK = new TriggerType("PLACE_BLOCK");
    @NotNull
    public static TriggerType BREAK_BLOCK = new TriggerType("BREAK_BLOCK");
    @NotNull
    public static TriggerType SHOOT_BOW = new TriggerType("SHOOT_BOW", true, true, true);
    @NotNull
    public static TriggerType ARROW_TICK = new TriggerType("ARROW_TICK", true, true, true);
    @NotNull
    public static TriggerType ARROW_HIT = new TriggerType("ARROW_HIT", true, true, true);
    @NotNull
    public static TriggerType ARROW_LAND = new TriggerType("ARROW_LAND", true, true, true);
    @NotNull
    public static TriggerType SHOOT_TRIDENT = new TriggerType("SHOOT_TRIDENT", true, true, true);
    @NotNull
    public static TriggerType TRIDENT_TICK = new TriggerType("TRIDENT_TICK", true, true, true);
    @NotNull
    public static TriggerType TRIDENT_HIT = new TriggerType("TRIDENT_HIT", true, true, true);
    @NotNull
    public static TriggerType TRIDENT_LAND = new TriggerType("TRIDENT_LAND", true, true, true);
    @NotNull
    public static TriggerType RIGHT_CLICK = new TriggerType("RIGHT_CLICK", false, true, true);
    @NotNull
    public static TriggerType LEFT_CLICK = new TriggerType("LEFT_CLICK", false, true, true);
    @NotNull
    public static TriggerType SHIFT_RIGHT_CLICK = new TriggerType("SHIFT_RIGHT_CLICK", false, true, true);
    @NotNull
    public static TriggerType SHIFT_LEFT_CLICK = new TriggerType("SHIFT_LEFT_CLICK", false, true, true);
    @NotNull
    public static TriggerType DROP_ITEM = new TriggerType("DROP_ITEM", false);
    @NotNull
    public static TriggerType SHIFT_DROP_ITEM = new TriggerType("SHIFT_DROP_ITEM", false);
    @NotNull
    public static TriggerType SWAP_ITEMS = new TriggerType("SWAP_ITEMS", false);
    @NotNull
    public static TriggerType SHIFT_SWAP_ITEMS = new TriggerType("SHIFT_SWAP_ITEMS", false);
    @NotNull
    public static TriggerType LOGIN = new TriggerType("LOGIN");
    @NotNull
    public static TriggerType SNEAK = new TriggerType("SNEAK", false);
    @NotNull
    public static TriggerType TELEPORT = new TriggerType("TELEPORT");
    @NotNull
    public static TriggerType TIMER = new TriggerType("TIMER");
    @NotNull
    public static TriggerType CAST = new TriggerType("CAST", false, false);
    @NotNull
    public static TriggerType API = new TriggerType("API");
    public static final TriggerType EQUIP_ARMOR = new TriggerType("EQUIP_ARMOR", false);
    public static final TriggerType UNEQUIP_ARMOR = new TriggerType("UNEQUIP_ARMOR", false);
    private static final Map<String, TriggerType> BY_ID = new HashMap<String, TriggerType>();
    private final String id;
    private final boolean silent;
    private final boolean passive;
    private final boolean actionHandSpecific;

    public TriggerType(String id) {
        this(id, true, true);
    }

    public TriggerType(String id, boolean silent) {
        this(id, silent, true);
    }

    private TriggerType(String id, boolean silent, boolean passive) {
        this(id, silent, passive, false);
    }

    private TriggerType(String id, boolean silent, boolean passive, boolean actionHandSpecific) {
        this.id = id;
        this.silent = silent;
        this.passive = passive;
        this.actionHandSpecific = actionHandSpecific;
    }

    @NotNull
    public String name() {
        return this.id;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean isActionHandSpecific() {
        return this.actionHandSpecific;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public String getName() {
        return UtilityMethods.caseOnWords(this.name().toLowerCase().replace("_", " "));
    }

    public String getLowerCaseId() {
        return this.name().toLowerCase().replace("_", "-");
    }

    public String toString() {
        return this.name();
    }

    @NotNull
    public static TriggerType valueOf(String id) {
        return Objects.requireNonNull(BY_ID.get(id), "Could not find trigger type with ID '" + id + "'");
    }

    public static void register(@NotNull TriggerType trigger) {
        Validate.notNull(trigger, "Trigger type cannot be null", new Object[0]);
        BY_ID.put(trigger.name(), trigger);
    }

    public static Collection<TriggerType> values() {
        return BY_ID.values();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerType that = (TriggerType)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    static {
        TriggerType.register(KILL_ENTITY);
        TriggerType.register(KILL_PLAYER);
        TriggerType.register(ATTACK);
        TriggerType.register(DAMAGED);
        TriggerType.register(DAMAGED_BY_ENTITY);
        TriggerType.register(DEATH);
        TriggerType.register(PLACE_BLOCK);
        TriggerType.register(BREAK_BLOCK);
        TriggerType.register(SHOOT_BOW);
        TriggerType.register(ARROW_TICK);
        TriggerType.register(ARROW_HIT);
        TriggerType.register(ARROW_LAND);
        TriggerType.register(SHOOT_TRIDENT);
        TriggerType.register(TRIDENT_TICK);
        TriggerType.register(TRIDENT_HIT);
        TriggerType.register(TRIDENT_LAND);
        TriggerType.register(RIGHT_CLICK);
        TriggerType.register(LEFT_CLICK);
        TriggerType.register(DROP_ITEM);
        TriggerType.register(SWAP_ITEMS);
        TriggerType.register(SHIFT_RIGHT_CLICK);
        TriggerType.register(SHIFT_LEFT_CLICK);
        TriggerType.register(SHIFT_DROP_ITEM);
        TriggerType.register(SHIFT_SWAP_ITEMS);
        TriggerType.register(LOGIN);
        TriggerType.register(SNEAK);
        TriggerType.register(TELEPORT);
        TriggerType.register(TIMER);
        TriggerType.register(CAST);
        TriggerType.register(API);
    }
}

