/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.vector;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.util.TemporaryListener;
import io.lumine.mythic.lib.comp.interaction.InteractionType;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.VectorSkillResult;
import io.lumine.mythic.lib.version.Sounds;
import io.lumine.mythic.lib.version.VParticle;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class ShulkerMissile
extends SkillHandler<VectorSkillResult> {
    public ShulkerMissile() {
        super("SHULKER_MISSILE");
        this.registerModifiers("damage", "effect-duration", "duration");
    }

    @Override
    @NotNull
    public VectorSkillResult getResult(SkillMetadata meta) {
        return new VectorSkillResult(meta);
    }

    @Override
    public void whenCast(final VectorSkillResult result, final SkillMetadata skillMeta) {
        final Player caster = skillMeta.getCaster().getPlayer();
        new BukkitRunnable(){
            double n = 0.0;

            public void run() {
                double d = this.n;
                this.n = d + 1.0;
                if (d > 3.0) {
                    this.cancel();
                    return;
                }
                caster.getWorld().playSound(caster.getLocation(), Sounds.ENTITY_WITHER_SHOOT, 2.0f, 2.0f);
                ShulkerBullet shulkerBullet = (ShulkerBullet)caster.getWorld().spawnEntity(caster.getLocation().add(0.0, 1.0, 0.0), EntityType.SHULKER_BULLET);
                shulkerBullet.setShooter((ProjectileSource)caster);
                new ShulkerMissileHandler(skillMeta.getCaster(), shulkerBullet, result.getTarget(), (long)(skillMeta.getParameter("duration") * 20.0), skillMeta.getParameter("damage"), (int)(20.0 * skillMeta.getParameter("effect-duration")));
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 3L);
    }

    public static class ShulkerMissileHandler
    extends TemporaryListener {
        private final PlayerMetadata caster;
        private final ShulkerBullet bullet;
        private final Vector vel;
        private final long duration;
        private final double damage;
        private final int effectDuration;

        public ShulkerMissileHandler(PlayerMetadata caster, final ShulkerBullet bullet, final Vector vel, final long duration, double damage, int effectDuration) {
            super(new HandlerList[0]);
            this.caster = caster;
            this.bullet = bullet;
            this.vel = vel;
            this.duration = duration;
            this.damage = damage;
            this.effectDuration = effectDuration;
            this.registerRunnable(new BukkitRunnable(){
                double ti = 0.0;

                /*
                 * Enabled aggressive block sorting
                 */
                public void run() {
                    if (!bullet.isDead()) {
                        double d = this.ti;
                        this.ti = d + 1.0;
                        if (!(d >= (double)duration)) {
                            bullet.setVelocity(vel);
                            return;
                        }
                    }
                    this.close();
                }
            }, runnable -> runnable.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L));
        }

        @Override
        public void whenClosed() {
            if (!this.bullet.isDead()) {
                this.bullet.remove();
            }
        }

        @EventHandler
        public void onHit(EntityDamageByEntityEvent event) {
            if (!event.getDamager().equals((Object)this.bullet)) {
                return;
            }
            if (!UtilityMethods.canTarget(this.caster.getPlayer(), null, event.getEntity(), InteractionType.OFFENSE_SKILL)) {
                event.setCancelled(true);
                return;
            }
            final LivingEntity entity = (LivingEntity)event.getEntity();
            event.setDamage(this.damage);
            new BukkitRunnable(){
                final Location loc;
                double y;
                {
                    this.loc = entity.getLocation();
                    this.y = 0.0;
                }

                public void run() {
                    if (this.y == 0.0) {
                        entity.removePotionEffect(PotionEffectType.LEVITATION);
                        entity.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, effectDuration, 0));
                    }
                    for (int j1 = 0; j1 < 3; ++j1) {
                        this.y += 0.04;
                        for (int j = 0; j < 2; ++j) {
                            double xz = this.y * Math.PI * 1.3 + (double)j * Math.PI;
                            this.loc.getWorld().spawnParticle(VParticle.REDSTONE.get(), this.loc.clone().add(Math.cos(xz), this.y, Math.sin(xz)), 1, (Object)new Particle.DustOptions(Color.MAROON, 1.0f));
                        }
                    }
                    if (this.y >= 2.0) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
        }
    }
}

